/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.AddListEntryCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.AddManagedBeanPropertyCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.AddMapEntryCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.EditListEntryCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.EditManagedBeanPropertyCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.EditMapEntryCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.RemoveListEntryCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.RemoveManagedBeanPropertyCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.RemoveMapEntryCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.SetListValueClassCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.SetMapKeyClassCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.SetMapValueClassCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.RadiosDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.Alerts;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.ListEntriesEditGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.MapEntriesEditGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.PropertyInitializationEditGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ListEntriesRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedProperty;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedPropertyRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.MapEntriesRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractSSESection;

public class ManagedBeanInitializationSection
extends AbstractSSESection {
    private static EditorResources resource = EditorResources.getInstance();
    private static final String MANAGEDBEAN_GENERAL_CLASS = resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.ClassType.General");
    private static final String MANAGEDBEAN_MAP = resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.ClassType.Map");
    private static final String MANAGEDBEAN_LIST = resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.ClassType.List");
    private IFormPage editor;
    private Composite propertySection;
    private PropertyInitializationEditGroup propertyGroup;
    private Composite mapSection;
    private MapEntriesEditGroup mapEntryGroup;
    private Composite listSection;
    private ListEntriesEditGroup listEntryGroup;
    private PageBook pageBook;
    private RadiosDialogField beanTypeField;
    private int currentPageIndex = 0;
    private MapEntriesRecorder mapEntries;
    private ListEntriesRecorder listEntries;
    private Composite container;

    public ManagedBeanInitializationSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor) {
        super(parent, managedForm, toolkit, resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.HelpContextID"), resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.HelpToolTip"));
        this.setText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.Name"));
        this.setDescription(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.Description"));
        this.editor = editor;
        this.propertyGroup = new PropertyInitializationEditGroup();
        this.propertyGroup.initialize();
        this.mapEntryGroup = new MapEntriesEditGroup(null);
        this.mapEntryGroup.initialize();
        this.listEntryGroup = new ListEntriesEditGroup(null);
        this.listEntryGroup.initialize();
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        this.container = container;
        int numberOfColumns = 3;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        container.setLayout((Layout)gl);
        toolkit.paintBordersFor(container);
        this.createBeanTypeEntry(container, toolkit, numberOfColumns);
        this.createInitializationEntry(container, toolkit, numberOfColumns);
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.HelpContextID"));
    }

    public void setEnabled(boolean enabled) {
        if (this.container != null) {
            this.container.setEnabled(enabled);
        }
    }

    private void createBeanTypeEntry(Composite container, FormToolkit toolkit, int numberOfColumns) {
        this.beanTypeField = new RadiosDialogField();
        String[] items = new String[]{MANAGEDBEAN_GENERAL_CLASS, MANAGEDBEAN_MAP, MANAGEDBEAN_LIST};
        this.beanTypeField.setLabelText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.ClassType"));
        this.beanTypeField.setItems(items);
        this.beanTypeField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.beanTypeField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                RadiosDialogField beanTypeField = (RadiosDialogField)field;
                boolean bChangedSuccess = false;
                if (beanTypeField.getSelectedIndex() == 0) {
                    bChangedSuccess = ManagedBeanInitializationSection.this.switchPage("managed-property", false);
                } else if (beanTypeField.getSelectedIndex() == 1) {
                    bChangedSuccess = ManagedBeanInitializationSection.this.switchPage("map-entries", false);
                } else if (beanTypeField.getSelectedIndex() == 2) {
                    bChangedSuccess = ManagedBeanInitializationSection.this.switchPage("list-entries", false);
                }
                if (bChangedSuccess) {
                    ManagedBeanInitializationSection.this.currentPageIndex = beanTypeField.getSelectedIndex();
                } else {
                    beanTypeField.setSelectedIndexWithoutUpdate(-1);
                    beanTypeField.setSelectedIndexWithoutUpdate(ManagedBeanInitializationSection.this.currentPageIndex);
                }
            }
        });
    }

    private boolean switchPage(String pageID, boolean bForceClearOthers) {
        if (pageID == "managed-property") {
            if (this.clearPage("map-entries", bForceClearOthers) && this.clearPage("list-entries", bForceClearOthers)) {
                this.pageBook.showPage((Control)this.propertySection);
                this.setExpanded(false);
                this.setExpanded(true);
                return true;
            }
        } else if (pageID == "map-entries") {
            if (this.clearPage("managed-property", bForceClearOthers) && this.clearPage("list-entries", bForceClearOthers)) {
                this.pageBook.showPage((Control)this.mapSection);
                this.setExpanded(false);
                this.setExpanded(true);
                this.mapEntryGroup.getKeyClassField().setFocus();
                return true;
            }
        } else if (pageID == "list-entries" && this.clearPage("managed-property", bForceClearOthers) && this.clearPage("map-entries", bForceClearOthers)) {
            this.pageBook.showPage((Control)this.listSection);
            this.setExpanded(false);
            this.setExpanded(true);
            this.listEntryGroup.getValueClassField().setFocus();
            return true;
        }
        return false;
    }

    private boolean clearPage(String pageID, boolean bForceClear) {
        if (pageID == "managed-property") {
            ManagedBean bean = new ManagedBean((IDOMNode)this.getInput());
            if (bean.isEmptyProperties()) {
                return true;
            }
            if (bForceClear || EditorPlugin.getAlerts().confirm("ManagedBeanInitializationSection.Remove.Title", "ManagedBeanInitializationSection.RemoveManagedProperty")) {
                bean.removeAllProperties();
                return true;
            }
        } else if (pageID == "map-entries") {
            if (this.getMapEntries().isEmpty()) {
                return true;
            }
            if (bForceClear || EditorPlugin.getAlerts().confirm("ManagedBeanInitializationSection.Remove.Title", "ManagedBeanInitializationSection.RemoveMapEntries")) {
                this.getMapEntries().clearAll();
                return true;
            }
        } else if (pageID == "list-entries") {
            if (this.getListEntries().isEmpty()) {
                return true;
            }
            if (bForceClear || EditorPlugin.getAlerts().confirm("ManagedBeanInitializationSection.Remove.Title", "ManagedBeanInitializationSection.RemoveListEntries")) {
                this.getListEntries().clearAll();
                return true;
            }
        }
        return false;
    }

    private void createInitializationEntry(Composite container, FormToolkit toolkit, int numberOfColumns) {
        this.pageBook = new PageBook(container, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = numberOfColumns;
        this.pageBook.setLayoutData((Object)gd);
        toolkit.paintBordersFor((Composite)this.pageBook);
        this.propertySection = toolkit.createComposite((Composite)this.pageBook);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        this.propertySection.setLayout((Layout)gl);
        this.createPropertyEntry(this.propertySection, toolkit);
        this.mapSection = toolkit.createComposite((Composite)this.pageBook);
        this.createMapEntry(this.mapSection, toolkit);
        this.listSection = toolkit.createComposite((Composite)this.pageBook);
        this.createListEntry(this.listSection, toolkit);
        this.pageBook.showPage((Control)this.propertySection);
    }

    private void createPropertyEntry(Composite container, FormToolkit toolkit) {
        this.propertyGroup.layoutDialogFields(toolkit, container);
        this.propertyGroup.getAddButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.addPropertyButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.addPropertyButtonSelected(e);
            }
        });
        this.propertyGroup.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.removePropertyButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.removePropertyButtonSelected(e);
            }
        });
        this.propertyGroup.getEditButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.editPropertyButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.editPropertyButtonSelected(e);
            }
        });
        this.propertyGroup.getPropertyTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ManagedBeanInitializationSection.this.editPropertyButtonSelected(null);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createMapEntry(Composite container, FormToolkit toolkit) {
        this.mapEntryGroup.layoutDialogFields(toolkit, container);
        this.mapEntryGroup.getAddButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.addMapButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.addMapButtonSelected(e);
            }
        });
        this.mapEntryGroup.getEditButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.editMapButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.editMapButtonSelected(e);
            }
        });
        this.mapEntryGroup.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.removeMapButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.removeMapButtonSelected(e);
            }
        });
        this.mapEntryGroup.getValueClassField().setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                ManagedBeanInitializationSection.this.mapValueClassChanged(((StringDialogField)field).getText());
            }
        });
        this.mapEntryGroup.getKeyClassField().setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                ManagedBeanInitializationSection.this.mapKeyClassChanged(((StringDialogField)field).getText());
            }
        });
        this.mapEntryGroup.getMapTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ManagedBeanInitializationSection.this.editMapButtonSelected(null);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createListEntry(Composite container, FormToolkit toolkit) {
        this.listEntryGroup.layoutDialogFields(toolkit, container);
        this.listEntryGroup.getAddButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.addListButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.addListButtonSelected(e);
            }
        });
        this.listEntryGroup.getEditButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.editListButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.editListButtonSelected(e);
            }
        });
        this.listEntryGroup.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.removeListButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeanInitializationSection.this.removeListButtonSelected(e);
            }
        });
        this.listEntryGroup.getValueClassField().setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                ManagedBeanInitializationSection.this.listValueClassChanged(((StringDialogField)field).getText());
            }
        });
        this.listEntryGroup.getListTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ManagedBeanInitializationSection.this.editListButtonSelected(null);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    protected void editPropertyButtonSelected(SelectionEvent e) {
        if (this.propertyGroup.getPropertyTable().getSelectionCount() > 0) {
            ManagedPropertyRecorder propertyRecorder = new ManagedPropertyRecorder((ManagedProperty)this.propertyGroup.getPropertyTable().getSelection()[0].getData(), new ManagedBean((IDOMNode)this.getInput()));
            EditManagedBeanPropertyCommand editCommand = new EditManagedBeanPropertyCommand(EditorResources.getInstance().getString("ManagedBeanInitializationSection.Command.ChangeManagedProperty"), this.getSectionPart(), propertyRecorder);
            editCommand.execute();
        }
    }

    protected void removePropertyButtonSelected(SelectionEvent e) {
        if (this.propertyGroup.getPropertyTable().getSelectionCount() > 0) {
            String warningMsg = "managed-property";
            ManagedProperty managedbeanProperty = (ManagedProperty)this.propertyGroup.getPropertyTable().getSelection()[0].getData();
            warningMsg = String.valueOf(warningMsg) + " \"" + managedbeanProperty.getPropertyName() + "\"";
            Alerts alerts = new Alerts((AbstractUIPlugin)EditorPlugin.getDefault(), resource.getResourceBundle());
            if (!alerts.question("Remove.Title", "Remove.Msg", (Object)warningMsg)) {
                return;
            }
            RemoveManagedBeanPropertyCommand removeCommand = new RemoveManagedBeanPropertyCommand(EditorResources.getInstance().getString("ManagedBeanInitializationSection.Command.RemoveManagedProperty"), this.getSectionPart(), (ManagedProperty)this.propertyGroup.getPropertyTable().getSelection()[0].getData());
            removeCommand.execute();
        }
    }

    protected void addPropertyButtonSelected(SelectionEvent e) {
        ManagedPropertyRecorder propertyRecorder = new ManagedPropertyRecorder(null, new ManagedBean((IDOMNode)this.getInput()));
        AddManagedBeanPropertyCommand addCommand = new AddManagedBeanPropertyCommand(EditorResources.getInstance().getString("ManagedBeanInitializationSection.Command.AddManagedProperty"), this.getSectionPart(), propertyRecorder);
        addCommand.execute();
    }

    protected void mapKeyClassChanged(String newKeyClass) {
        SetMapKeyClassCommand setCommand = new SetMapKeyClassCommand(this.getMapEntries(), newKeyClass);
        setCommand.execute();
    }

    protected void mapValueClassChanged(String newValueClass) {
        SetMapValueClassCommand setCommand = new SetMapValueClassCommand(this.getMapEntries(), newValueClass);
        setCommand.execute();
    }

    protected void addMapButtonSelected(SelectionEvent e) {
        AddMapEntryCommand addMapCommand = new AddMapEntryCommand(this.getMapEntries());
        addMapCommand.execute();
    }

    protected void editMapButtonSelected(SelectionEvent e) {
        if (this.mapEntryGroup.getMapTable().getSelectionCount() == 0) {
            return;
        }
        TableItem tableItem = this.mapEntryGroup.getMapTable().getSelection()[0];
        MapEntriesRecorder.MapEntry mapEntry = (MapEntriesRecorder.MapEntry)tableItem.getData();
        EditMapEntryCommand editCommand = new EditMapEntryCommand(this.getMapEntries(), mapEntry);
        editCommand.execute();
    }

    protected void removeMapButtonSelected(SelectionEvent e) {
        if (this.mapEntryGroup.getMapTable().getSelectionCount() > 0) {
            MapEntriesRecorder.MapEntry mapEntry = (MapEntriesRecorder.MapEntry)this.mapEntryGroup.getMapTable().getSelection()[0].getData();
            String warningMsg = "map-entry";
            warningMsg = String.valueOf(warningMsg) + " \"" + mapEntry._key + "\"";
            Alerts alerts = new Alerts((AbstractUIPlugin)EditorPlugin.getDefault(), resource.getResourceBundle());
            if (!alerts.question("Remove.Title", "Remove.Msg", (Object)warningMsg)) {
                return;
            }
            RemoveMapEntryCommand removeCommand = new RemoveMapEntryCommand(this.getMapEntries(), mapEntry);
            removeCommand.execute();
        }
    }

    protected void listValueClassChanged(String newValueClass) {
        SetListValueClassCommand setCommand = new SetListValueClassCommand(this.getListEntries(), newValueClass);
        setCommand.execute();
    }

    protected void addListButtonSelected(SelectionEvent e) {
        AddListEntryCommand addListCommand = new AddListEntryCommand(this.getListEntries());
        addListCommand.execute();
    }

    protected void editListButtonSelected(SelectionEvent e) {
        if (this.listEntryGroup.getListTable().getSelectionCount() == 0) {
            return;
        }
        TableItem tableItem = this.listEntryGroup.getListTable().getSelection()[0];
        ListEntriesRecorder.ListEntry listEntry = (ListEntriesRecorder.ListEntry)tableItem.getData();
        EditListEntryCommand editCommand = new EditListEntryCommand(this.getListEntries(), listEntry);
        editCommand.execute();
    }

    protected void removeListButtonSelected(SelectionEvent e) {
        if (this.listEntryGroup.getListTable().getSelectionCount() > 0) {
            ListEntriesRecorder.ListEntry listEntry = (ListEntriesRecorder.ListEntry)this.listEntryGroup.getListTable().getSelection()[0].getData();
            String warningMsg = "list-entries value";
            warningMsg = String.valueOf(warningMsg) + " \"" + listEntry._value + "\"";
            Alerts alerts = new Alerts((AbstractUIPlugin)EditorPlugin.getDefault(), resource.getResourceBundle());
            if (!alerts.question("Remove.Title", "Remove.Msg", (Object)warningMsg)) {
                return;
            }
            RemoveListEntryCommand removeCommand = new RemoveListEntryCommand(this.getListEntries(), listEntry);
            removeCommand.execute();
        }
    }

    public void clearAll() {
        this.propertyGroup.getPropertyTable().removeAll();
        this.listEntryGroup.clearAll();
        this.mapEntryGroup.clearAll();
    }

    public IWorkbenchPartSite getSite() {
        return this.editor.getSite();
    }

    public void setInput(Object newInput) {
        super.setInput(newInput);
        if (this.getInput() instanceof IDOMNode) {
            this.propertyGroup.setInput(this.getInput());
            this.mapEntryGroup.setInput(this.getMapEntries());
            this.listEntryGroup.setInput(this.getListEntries());
        }
    }

    private MapEntriesRecorder getMapEntries() {
        boolean needUpdate = false;
        if (this.mapEntries != null) {
            if (this.getInput() != this.mapEntries.getBean().getNode()) {
                needUpdate = true;
            }
        } else {
            needUpdate = true;
        }
        if (needUpdate) {
            this.mapEntries = new MapEntriesRecorder((IDOMNode)this.getInput(), new ManagedBean((IDOMNode)this.getInput()));
            this.mapEntries.retrieve();
            this.mapEntries.setSynchronzeWithModel(true);
        }
        return this.mapEntries;
    }

    private ListEntriesRecorder getListEntries() {
        boolean needUpdate = false;
        if (this.listEntries != null) {
            if (this.getInput() != this.listEntries.getBean().getNode()) {
                needUpdate = true;
            }
        } else {
            needUpdate = true;
        }
        if (needUpdate) {
            this.listEntries = new ListEntriesRecorder((IDOMNode)this.getInput(), new ManagedBean((IDOMNode)this.getInput()));
            this.listEntries.retrieve();
            this.listEntries.setSynchronzeWithModel(true);
        }
        return this.listEntries;
    }

    public void refreshAll() {
        ManagedBean bean = new ManagedBean((IDOMNode)this.getInput());
        if (!bean.isEmptyProperties()) {
            this.getListEntries().clearAll();
            this.getMapEntries().clearAll();
            this.beanTypeField.setSelectedIndexWithoutUpdate(-1);
            this.beanTypeField.setSelectedIndex(0);
        } else if (!this.getMapEntries().isEmpty()) {
            this.getListEntries().clearAll();
            this.beanTypeField.setSelectedIndexWithoutUpdate(-1);
            this.beanTypeField.setSelectedIndex(1);
        } else if (!this.getListEntries().isEmpty()) {
            this.beanTypeField.setSelectedIndexWithoutUpdate(-1);
            this.beanTypeField.setSelectedIndex(2);
        } else {
            this.beanTypeField.setSelectedIndexWithoutUpdate(-1);
            this.beanTypeField.setSelectedIndex(0);
        }
    }

    public void setPropertyName(IDOMNode node, String newName) {
        if (node != null && newName != null) {
            this.propertyGroup.setPropertyName(node, newName);
        }
    }

    public void setPropertyClass(IDOMNode node, String newClass) {
        if (node != null && newClass != null) {
            this.propertyGroup.setPropertyClass(node, newClass);
        }
    }

    public void setPropertyValue(IDOMNode node, String newValue) {
        if (node != null && newValue != null) {
            this.propertyGroup.setPropertyValue(node, newValue);
        }
    }

    public void removeItem(IDOMNode node) {
        if (node != null) {
            this.propertyGroup.removeItem(node);
        }
    }

    public void addItem(IDOMNode node) {
        if (node != null) {
            this.propertyGroup.addItem(node);
        }
    }

    public void addMapEntry(IDOMNode node) {
        this.mapEntryGroup.addMapEntry(node);
    }

    public void updateMapEntry(IDOMNode node) {
        this.mapEntryGroup.updateMapEntry(node);
    }

    public void removeMapEntry(IDOMNode node) {
        this.mapEntryGroup.removeMapEntry(node);
    }

    public void updateMapValueClass(String textElementValue) {
        if (textElementValue != null && !textElementValue.trim().equals(this.mapEntryGroup.getValueClassField().getText().trim())) {
            this.mapEntryGroup.getValueClassField().setTextWithoutUpdate(textElementValue);
        }
    }

    public void updateMapKeyClass(String textElementValue) {
        if (textElementValue != null && !textElementValue.trim().equals(this.mapEntryGroup.getKeyClassField().getText().trim())) {
            this.mapEntryGroup.getKeyClassField().setTextWithoutUpdate(textElementValue);
        }
    }

    public void clearMapEntries() {
        this.mapEntryGroup.clearAll();
    }

    public void clearListEntries() {
        this.listEntryGroup.clearAll();
    }

    public void clearListEntriesValues() {
        this.listEntryGroup.getListTable().removeAll();
    }

    public void addListEntry(IDOMNode node) {
        this.listEntryGroup.addListEntry(node);
    }

    public void removeListEntry(IDOMNode node) {
        this.listEntryGroup.removeListEntry(node);
    }

    public void updateListValueClass(String textElementValue) {
        if (textElementValue != null && !textElementValue.trim().equals(this.listEntryGroup.getValueClassField().getText().trim())) {
            this.listEntryGroup.getValueClassField().setTextWithoutUpdate(textElementValue);
        }
    }

    public void updateListEntry(IDOMNode node) {
        this.listEntryGroup.updateListEntry(node);
    }
}

