/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.adopters.ClassRef;
import org.eclipse.wtp.releng.tools.component.adopters.ComponentTeamScanner;
import org.eclipse.wtp.releng.tools.component.adopters.FieldRef;
import org.eclipse.wtp.releng.tools.component.adopters.IOutputConstants;
import org.eclipse.wtp.releng.tools.component.adopters.MethodRef;
import org.eclipse.wtp.releng.tools.component.adopters.PluginRef;
import org.eclipse.wtp.releng.tools.component.adopters.References;
import org.eclipse.wtp.releng.tools.component.api.ComponentXMLVisitor;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.internal.Type;
import org.eclipse.wtp.releng.tools.component.xsl.XSLUtil;

public class CombineClass2Reference
extends ComponentTeamScanner
implements IOutputConstants {
    public static final String ARG_SOURCE = "src";
    public static final String ARG_OUTPUT = "output";
    public static final String ARG_API = "api";
    public static final String ARG_SHOW_ADOPTER_NUMBERS = "showAdopterNumbers";
    public static final String ARG_SHOW_DETAILED_NUMBERS = "showDetailedNumbers";
    private Collection src;
    private String output;
    private Collection api;
    private boolean shouldShowIndividualAdopters = false;
    private boolean shouldShowDetailedNumbers = false;
    private List contactNames;
    private static final String CLASS_CVS_FILE_EXTENSION = ".class.csv";
    private static final String PACKAGE_CVS_FILE_EXTENSION = ".pkg.csv";
    private static final String PLUGIN_CVS_FILE_EXTENSION = ".plugin.csv";
    private static final String CLASS_HTML_FILE_EXTENSION = ".class.html";
    private static final String PACKAGE_HTML_FILE_EXTENSION = ".pkg.html";
    private static final String PLUGIN_HTML_FILE_EXTENSION = ".plugin.html";
    private static final String COMBINE_PLUGINS_FILE = "org/eclipse/wtp/releng/tools/component/xsl/combine-plugin2ref.xsl";
    private static final String COMBINE_PACKAGES_FILE = "org/eclipse/wtp/releng/tools/component/xsl/combine-pkg2ref.xsl";
    private static final String COMBINE_CLASSES_FILE = "org/eclipse/wtp/releng/tools/component/xsl/combine-class2ref.xsl";
    private static final int CLASS_USAGE = 0;
    private static final int PACKAGE_USAGE = 1;
    private static final int PLUGIN_USAGE = 2;

    public Collection getSrc() {
        return this.src;
    }

    public void setSrc(Collection src) {
        this.src = src;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public Collection getApi() {
        return this.api;
    }

    public void setApi(Collection api) {
        this.api = api;
    }

    private Map collectComponentXMLFiles() {
        HashMap<String, ComponentXML> pluginId2CompXML = new HashMap<String, ComponentXML>();
        if (this.getApi() != null) {
            Iterator i = this.getApi().iterator();
            while (i.hasNext()) {
                ILocation apiLocation = Location.createLocation(new File((String)i.next()));
                ComponentXMLVisitor compXMLVisitor = new ComponentXMLVisitor();
                apiLocation.accept(compXMLVisitor);
                Iterator it = compXMLVisitor.getCompXMLs().iterator();
                while (it.hasNext()) {
                    ComponentXML compXML = (ComponentXML)it.next();
                    Iterator it2 = compXML.getPlugins().iterator();
                    while (it2.hasNext()) {
                        pluginId2CompXML.put(((Plugin)it2.next()).getId(), compXML);
                    }
                }
            }
        }
        return pluginId2CompXML;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processUsages(Map pluginId2CompXML) {
        Iterator it = this.getSrc().iterator();
        while (it.hasNext()) {
            Object var14_15;
            FileInputStream fis = null;
            try {
                try {
                    String file = (String)it.next();
                    fis = new FileInputStream(file);
                    References refs = new References();
                    refs.load(fis);
                    String currentContactName = refs.getContactInfo();
                    if (this.isShouldShowIndividualAdopters()) {
                        this.cacheContactName(currentContactName);
                    }
                    Iterator it2 = refs.getPluginRefs().iterator();
                    while (it2.hasNext()) {
                        PluginRef pluginRef = (PluginRef)it2.next();
                        String pluginId = pluginRef.getId();
                        ComponentXML compXML = (ComponentXML)pluginId2CompXML.get(pluginId);
                        ComponentTeamScanner.ComponentTeam compTeam = this.getComponentTeam(pluginId);
                        Iterator it3 = pluginRef.getClassRefs().iterator();
                        while (it3.hasNext()) {
                            ClassRef classRef = (ClassRef)it3.next();
                            this.updateComponentTeamUsageCounts(compTeam, compXML, classRef, pluginId, currentContactName);
                        }
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            catch (Throwable throwable) {
                var14_15 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                var14_15 = null;
                if (fis == null) continue;
            }
            try {}
            catch (IOException iOException) {}
            fis.close();
        }
        return;
    }

    private void cacheContactName(String aContactName) {
        if (!this.getContactNames().contains(aContactName)) {
            this.getContactNames().add(aContactName);
        }
    }

    private List getContactNames() {
        if (this.contactNames == null) {
            this.contactNames = new ArrayList();
        }
        return this.contactNames;
    }

    private void execute() {
        Map pluginId2CompXML = this.collectComponentXMLFiles();
        this.processUsages(pluginId2CompXML);
        this.generateCSVFiles();
        this.generateHTMLFiles();
    }

    private List getOrderedReferencedCountKeys(final TreeMap referenceCounts) {
        String[] keys = referenceCounts.keySet().toArray(new String[referenceCounts.keySet().size()]);
        Comparator nonAPIComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                UsageCount usageCount1 = (UsageCount)referenceCounts.get(o1);
                UsageCount usageCount2 = (UsageCount)referenceCounts.get(o2);
                return usageCount2.nonAPIUse - usageCount1.nonAPIUse;
            }
        };
        Arrays.sort(keys, nonAPIComparator);
        return Arrays.asList(keys);
    }

    private void updateComponentTeamUsageCounts(ComponentTeamScanner.ComponentTeam compTeam, ComponentXML compXML, ClassRef classRef, String pluginId, String contactInfo) {
        String name = classRef.getName();
        String pkgName = this.getPackageName(name);
        UsageCount usageCount = this.getUsageCount(compXML, classRef, pkgName, name.substring(pkgName.length() + 1));
        UsageCount classUsageCount = (UsageCount)compTeam.getClassReferenceCounts().get(name);
        if (classUsageCount == null) {
            classUsageCount = new UsageCount();
        }
        classUsageCount.addMethodRefs(usageCount.getMethodRefs());
        classUsageCount.addFieldRefs(usageCount.getFieldRefs());
        UsageCount nestedClassUsageCount = classUsageCount.getNestedUsageCount(contactInfo);
        classUsageCount.apiUse += usageCount.apiUse;
        classUsageCount.nonAPIUse += usageCount.nonAPIUse;
        nestedClassUsageCount.apiUse += usageCount.apiUse;
        nestedClassUsageCount.nonAPIUse += usageCount.nonAPIUse;
        classUsageCount.getNestedUsageCounts().put(contactInfo, nestedClassUsageCount);
        compTeam.getClassReferenceCounts().put(name, classUsageCount);
        UsageCount pkgUsageCount = (UsageCount)compTeam.getPackageReferenceCounts().get(pkgName);
        if (pkgUsageCount == null) {
            pkgUsageCount = new UsageCount();
        }
        UsageCount nestedPkgUsageCount = pkgUsageCount.getNestedUsageCount(contactInfo);
        pkgUsageCount.apiUse += usageCount.apiUse;
        pkgUsageCount.nonAPIUse += usageCount.nonAPIUse;
        nestedPkgUsageCount.apiUse += usageCount.apiUse;
        nestedPkgUsageCount.nonAPIUse += usageCount.nonAPIUse;
        pkgUsageCount.getNestedUsageCounts().put(contactInfo, nestedPkgUsageCount);
        compTeam.getPackageReferenceCounts().put(pkgName, pkgUsageCount);
        UsageCount pluginUsageCount = (UsageCount)compTeam.getPluginReferenceCounts().get(pluginId);
        if (pluginUsageCount == null) {
            pluginUsageCount = new UsageCount();
        }
        UsageCount nestedPluginUsageCount = pluginUsageCount.getNestedUsageCount(contactInfo);
        pluginUsageCount.apiUse += usageCount.apiUse;
        pluginUsageCount.nonAPIUse += usageCount.nonAPIUse;
        nestedPluginUsageCount.apiUse += usageCount.apiUse;
        nestedPluginUsageCount.nonAPIUse += usageCount.nonAPIUse;
        pluginUsageCount.getNestedUsageCounts().put(contactInfo, nestedPluginUsageCount);
        compTeam.getPluginReferenceCounts().put(pluginId, pluginUsageCount);
    }

    private UsageCount getUsageCount(ComponentXML compXML, ClassRef classRef, String pkgName, String localName) {
        UsageCount usageCount = new UsageCount();
        int refCount = classRef.getRefCount();
        int subclassCount = classRef.getSubclassCount();
        int implCount = classRef.getImplementCount();
        int instantiateCount = classRef.getInstantiateCount();
        if (compXML == null || compXML.getPackage(pkgName) == null) {
            usageCount.nonAPIUse = refCount + subclassCount + implCount + instantiateCount;
            usageCount.addMethodRefs(classRef.getMethodRefs());
            usageCount.addFieldRefs(classRef.getFieldRefs());
            return usageCount;
        }
        Package pkg = compXML.getPackage(pkgName);
        Type type = pkg.getType(localName);
        if (type == null) {
            if (pkg.isApi()) {
                usageCount.apiUse = refCount + subclassCount + implCount + instantiateCount;
                return usageCount;
            }
            usageCount.nonAPIUse = refCount + subclassCount + implCount + instantiateCount;
            return usageCount;
        }
        if (!type.isReference()) {
            usageCount.nonAPIUse += classRef.getRefCount();
            usageCount.addMethodRefs(classRef.getMethodRefs());
            usageCount.addFieldRefs(classRef.getFieldRefs());
        } else {
            usageCount.apiUse += classRef.getRefCount();
        }
        if (!type.isSubclass()) {
            usageCount.nonAPIUse += classRef.getSubclassCount();
        } else {
            usageCount.apiUse += classRef.getSubclassCount();
        }
        if (!type.isImplement()) {
            usageCount.nonAPIUse += classRef.getImplementCount();
        } else {
            usageCount.apiUse += classRef.getImplementCount();
        }
        if (!type.isInstantiate()) {
            usageCount.nonAPIUse += classRef.getInstantiateCount();
        } else {
            usageCount.apiUse += classRef.getInstantiateCount();
        }
        return usageCount;
    }

    private String getPackageName(String className) {
        int i = className.lastIndexOf(46);
        if (i != -1) {
            return className.substring(0, i);
        }
        return "";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateCSVFiles() {
        OutputStreamWriter pluginWriter;
        OutputStreamWriter pkgWriter;
        block20: {
            OutputStreamWriter classWriter = null;
            pkgWriter = null;
            pluginWriter = null;
            try {
                try {
                    classWriter = new FileWriter(String.valueOf(this.getOutput()) + CLASS_CVS_FILE_EXTENSION);
                    pkgWriter = new FileWriter(String.valueOf(this.getOutput()) + PACKAGE_CVS_FILE_EXTENSION);
                    pluginWriter = new FileWriter(String.valueOf(this.getOutput()) + PLUGIN_CVS_FILE_EXTENSION);
                    int i = 0;
                    while (i < this.getComponentTeams().size()) {
                        ComponentTeamScanner.ComponentTeam compTeam = (ComponentTeamScanner.ComponentTeam)this.getComponentTeams().get(i);
                        this.writeCompTeamCSV(compTeam, classWriter, pkgWriter, pluginWriter);
                        ++i;
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (classWriter != null) {
                    try {
                        classWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                if (pkgWriter != null) {
                    try {
                        pkgWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                if (pluginWriter == null) throw throwable;
                try {
                    pluginWriter.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_9 = null;
                if (classWriter == null) break block20;
            }
            try {}
            catch (IOException iOException) {}
            classWriter.close();
        }
        if (pkgWriter != null) {
            try {}
            catch (IOException iOException) {}
            pkgWriter.close();
        }
        if (pluginWriter == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        pluginWriter.close();
    }

    private void writeCompTeamCSV(ComponentTeamScanner.ComponentTeam compTeam, Writer classWriter, Writer pkgWriter, Writer pluginWriter) throws IOException {
        this.writeCompTeamCSV(compTeam, classWriter, compTeam.getClassReferenceCounts());
        this.writeCompTeamCSV(compTeam, pkgWriter, compTeam.getPackageReferenceCounts());
        this.writeCompTeamCSV(compTeam, pluginWriter, compTeam.getPluginReferenceCounts());
    }

    private void writeCompTeamCSV(ComponentTeamScanner.ComponentTeam compTeam, Writer writer, TreeMap referenceCounts) throws IOException {
        writer.write(compTeam.getTeamName());
        writer.write("\n");
        List orderedKeys = this.getOrderedReferencedCountKeys(referenceCounts);
        Iterator it = orderedKeys.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            UsageCount usageCount = (UsageCount)referenceCounts.get(name);
            writer.write(name);
            writer.write(",");
            writer.write(String.valueOf(usageCount.nonAPIUse));
            writer.write(",");
            writer.write(String.valueOf(usageCount.apiUse));
            writer.write("\n");
        }
        writer.write("\n");
    }

    private void generateHTMLFiles() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write("<root>".getBytes());
            int i = 0;
            while (i < this.getComponentTeams().size()) {
                ComponentTeamScanner.ComponentTeam compTeam = (ComponentTeamScanner.ComponentTeam)this.getComponentTeams().get(i);
                this.writeCompTeamXML(compTeam, baos);
                ++i;
            }
            baos.write("</root>".getBytes());
            baos.close();
            byte[] content = baos.toByteArray();
            XSLUtil.transform(ClassLoader.getSystemResourceAsStream(COMBINE_PLUGINS_FILE), new ByteArrayInputStream(content), (OutputStream)new FileOutputStream(String.valueOf(this.getOutput()) + PLUGIN_HTML_FILE_EXTENSION));
            XSLUtil.transform(ClassLoader.getSystemResourceAsStream(COMBINE_PACKAGES_FILE), new ByteArrayInputStream(content), (OutputStream)new FileOutputStream(String.valueOf(this.getOutput()) + PACKAGE_HTML_FILE_EXTENSION));
            XSLUtil.transform(ClassLoader.getSystemResourceAsStream(COMBINE_CLASSES_FILE), new ByteArrayInputStream(content), (OutputStream)new FileOutputStream(String.valueOf(this.getOutput()) + CLASS_HTML_FILE_EXTENSION));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private void writeCompTeamXML(ComponentTeamScanner.ComponentTeam compTeam, ByteArrayOutputStream baos) throws IOException {
        baos.write("<team lead=\"".getBytes());
        baos.write(compTeam.getTeamName().getBytes());
        baos.write("\">".getBytes());
        Iterator nestedKeys = this.getContactNames().iterator();
        while (nestedKeys.hasNext()) {
            String currentKey = (String)nestedKeys.next();
            baos.write("<source name=\"".getBytes());
            baos.write(currentKey.getBytes());
            baos.write("\"/>".getBytes());
        }
        this.writeCompTeamXML(baos, 0, compTeam.getClassReferenceCounts());
        this.writeCompTeamXML(baos, 1, compTeam.getPackageReferenceCounts());
        this.writeCompTeamXML(baos, 2, compTeam.getPluginReferenceCounts());
        baos.write("</team>".getBytes());
    }

    private void writeCompTeamXML(ByteArrayOutputStream baos, int usage, TreeMap referenceCounts) throws IOException {
        List orderedKeys = this.getOrderedReferencedCountKeys(referenceCounts);
        Iterator it = orderedKeys.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            UsageCount usageCount = (UsageCount)referenceCounts.get(name);
            switch (usage) {
                case 0: {
                    baos.write("<class name=\"".getBytes());
                    break;
                }
                case 1: {
                    baos.write("<package name=\"".getBytes());
                    break;
                }
                case 2: {
                    baos.write("<plugin id=\"".getBytes());
                }
            }
            baos.write(name.getBytes());
            baos.write("\" api=\"".getBytes());
            baos.write(String.valueOf(usageCount.apiUse).getBytes());
            baos.write("\" internal=\"".getBytes());
            baos.write(String.valueOf(usageCount.nonAPIUse).getBytes());
            baos.write("\">".getBytes());
            Iterator nestedKeys = this.getContactNames().iterator();
            while (nestedKeys.hasNext()) {
                String currentKey = (String)nestedKeys.next();
                UsageCount nestedCount = usageCount.getNestedUsageCount(currentKey);
                baos.write("<source name=\"".getBytes());
                baos.write(currentKey.getBytes());
                baos.write("\" api=\"".getBytes());
                baos.write(String.valueOf(nestedCount.apiUse).getBytes());
                baos.write("\" internal=\"".getBytes());
                baos.write(String.valueOf(nestedCount.nonAPIUse).getBytes());
                baos.write("\"/>".getBytes());
            }
            if (this.isShouldShowDetailedNumbers()) {
                this.showDetailedMethodAndFieldSections(baos, usageCount);
            }
            switch (usage) {
                case 0: {
                    baos.write("</class>".getBytes());
                    break;
                }
                case 1: {
                    baos.write("</package>".getBytes());
                    break;
                }
                case 2: {
                    baos.write("</plugin>".getBytes());
                }
            }
        }
    }

    private void showDetailedMethodAndFieldSections(ByteArrayOutputStream baos, UsageCount usageCount) throws IOException {
        int count;
        String currentKey;
        Iterator nestedMethodRefs = usageCount.getMethodRefs().keySet().iterator();
        while (nestedMethodRefs.hasNext()) {
            currentKey = (String)nestedMethodRefs.next();
            count = (Integer)usageCount.getMethodRefs().get(currentKey);
            baos.write("<method name=\"".getBytes());
            baos.write(this.encode(currentKey).getBytes());
            baos.write("\" internal=\"".getBytes());
            baos.write(String.valueOf(count).getBytes());
            baos.write("\"/>".getBytes());
        }
        Iterator nestedFieldRefs = usageCount.getFieldRefs().keySet().iterator();
        while (nestedFieldRefs.hasNext()) {
            currentKey = (String)nestedFieldRefs.next();
            count = (Integer)usageCount.getFieldRefs().get(currentKey);
            baos.write("<field name=\"".getBytes());
            baos.write(this.encode(currentKey).getBytes());
            baos.write("\" internal=\"".getBytes());
            baos.write(String.valueOf(count).getBytes());
            baos.write("\"/>".getBytes());
        }
    }

    protected String encode(String s) {
        int index = s.indexOf(60);
        if (index != -1) {
            StringBuffer sb = new StringBuffer(s);
            while (index != -1) {
                sb.deleteCharAt(index);
                sb.insert(index, new char[]{'&', 'l', 't', ';'}, 0, 4);
                index = sb.toString().indexOf(60);
            }
            return sb.toString();
        }
        return s;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        Collection src = (Collection)options.get(ARG_SOURCE);
        Collection output = (Collection)options.get(ARG_OUTPUT);
        Collection api = (Collection)options.get(ARG_API);
        Collection showAdopterNumbers = (Collection)options.get(ARG_SHOW_ADOPTER_NUMBERS);
        Collection showDetailedNumbers = (Collection)options.get(ARG_SHOW_DETAILED_NUMBERS);
        if (src == null || output == null || src.isEmpty() || output.isEmpty()) {
            CombineClass2Reference.printUsage();
            System.exit(-1);
        }
        CombineClass2Reference class2Ref = new CombineClass2Reference();
        class2Ref.setSrc(src);
        class2Ref.setOutput((String)output.iterator().next());
        class2Ref.setApi(api);
        if (showAdopterNumbers != null) {
            class2Ref.setShouldShowIndividualAdopters(new Boolean((String)showAdopterNumbers.iterator().next()));
        }
        if (showDetailedNumbers != null) {
            class2Ref.setShouldShowDetailedNumbers(new Boolean((String)showDetailedNumbers.iterator().next()));
        }
        class2Ref.execute();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.adopters.CombineClass2Reference -src <src> -output <output>");
        System.out.println("");
        System.out.println("\t-src\t\t<src>\t\tlocation of your usage reports");
        System.out.println("\t-output\t<output>\t\tlocation of the output file");
        System.out.println("\t-api\t\t<api>\t\tlocation of your component.xml");
    }

    public boolean isShouldShowIndividualAdopters() {
        return this.shouldShowIndividualAdopters;
    }

    public void setShouldShowIndividualAdopters(boolean shouldShowIndividualAdopters) {
        this.shouldShowIndividualAdopters = shouldShowIndividualAdopters;
    }

    public boolean isShouldShowDetailedNumbers() {
        return this.shouldShowDetailedNumbers;
    }

    public void setShouldShowDetailedNumbers(boolean shouldShowDetailedNumbers) {
        this.shouldShowDetailedNumbers = shouldShowDetailedNumbers;
    }

    private class UsageCount {
        public int apiUse = 0;
        public int nonAPIUse = 0;
        private HashMap methodRefs = null;
        private HashMap fieldRefs = null;
        private HashMap nestedUsageCounts;

        private UsageCount() {
        }

        public HashMap getMethodRefs() {
            if (this.methodRefs == null) {
                this.methodRefs = new HashMap();
            }
            return this.methodRefs;
        }

        public HashMap getFieldRefs() {
            if (this.fieldRefs == null) {
                this.fieldRefs = new HashMap();
            }
            return this.fieldRefs;
        }

        public HashMap getNestedUsageCounts() {
            if (this.nestedUsageCounts == null) {
                this.nestedUsageCounts = new HashMap();
            }
            return this.nestedUsageCounts;
        }

        public UsageCount getNestedUsageCount(String contactInfo) {
            UsageCount usageCount = (UsageCount)this.getNestedUsageCounts().get(contactInfo);
            if (usageCount == null) {
                usageCount = new UsageCount();
                this.getNestedUsageCounts().put(contactInfo, usageCount);
            }
            return usageCount;
        }

        public void addMethodRefs(Collection someMethodRefs) {
            Iterator i = someMethodRefs.iterator();
            while (i.hasNext()) {
                MethodRef aMethodRef = (MethodRef)i.next();
                if (!this.getMethodRefs().keySet().contains(aMethodRef.getName())) {
                    this.getMethodRefs().put(aMethodRef.getName(), new Integer(aMethodRef.getRefCount()));
                    continue;
                }
                int updatedCount = aMethodRef.getRefCount() + (Integer)this.getMethodRefs().get(aMethodRef.getName());
                this.getMethodRefs().put(aMethodRef.getName(), new Integer(updatedCount));
            }
        }

        public void addFieldRefs(Collection someFieldRefs) {
            Iterator i = someFieldRefs.iterator();
            while (i.hasNext()) {
                FieldRef aFieldRef = (FieldRef)i.next();
                if (!this.getFieldRefs().keySet().contains(aFieldRef.getName())) {
                    this.getFieldRefs().put(aFieldRef.getName(), new Integer(aFieldRef.getRefCount()));
                    continue;
                }
                int updatedCount = aFieldRef.getRefCount() + (Integer)this.getFieldRefs().get(aFieldRef.getName());
                this.getFieldRefs().put(aFieldRef.getName(), new Integer(updatedCount));
            }
        }

        public void addMethodRefs(HashMap someMethodRefs) {
            if (someMethodRefs == null) {
                return;
            }
            Iterator i = someMethodRefs.keySet().iterator();
            while (i.hasNext()) {
                String aMethodRefName = (String)i.next();
                if (!this.getMethodRefs().keySet().contains(aMethodRefName)) {
                    this.getMethodRefs().put(aMethodRefName, someMethodRefs.get(aMethodRefName));
                    continue;
                }
                int updatedCount = (Integer)someMethodRefs.get(aMethodRefName) + (Integer)this.getMethodRefs().get(aMethodRefName);
                this.getMethodRefs().put(aMethodRefName, new Integer(updatedCount));
            }
        }

        public void addFieldRefs(HashMap someFieldRefs) {
            if (someFieldRefs == null) {
                return;
            }
            Iterator i = someFieldRefs.keySet().iterator();
            while (i.hasNext()) {
                String aFieldRefName = (String)i.next();
                if (!this.getFieldRefs().keySet().contains(aFieldRefName)) {
                    this.getFieldRefs().put(aFieldRefName, someFieldRefs.get(aFieldRefName));
                    continue;
                }
                int updatedCount = (Integer)someFieldRefs.get(aFieldRefName) + (Integer)this.getFieldRefs().get(aFieldRefName);
                this.getFieldRefs().put(aFieldRefName, new Integer(updatedCount));
            }
        }
    }
}

