/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.compatibility;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;

public class APICompatibility {
    public static final String CONST_API_COMPATIBILITY_XML = "api-compatibility.xml";
    protected ILocation location;
    protected String name;
    private List newAPIs = new ArrayList();
    private List removedAPIs = new ArrayList(0);

    public ILocation getLocation() {
        return this.location;
    }

    public void setLocation(ILocation location) {
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addNewAPI(PackageAPI pkgAPI) {
        this.newAPIs.add(pkgAPI);
    }

    public List getNewAPIs() {
        return new ArrayList(this.newAPIs);
    }

    public void addRemovedAPI(PackageAPI pkgAPI) {
        this.removedAPIs.add(pkgAPI);
    }

    public List getRemovedAPIs() {
        return new ArrayList(this.removedAPIs);
    }

    public void saveAsHTML(ILocation html, String xsl) throws TransformerConfigurationException, TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(ClassLoader.getSystemResourceAsStream(xsl)));
        transformer.transform(new StreamSource(new ByteArrayInputStream(this.getBytes())), new StreamResult(new FileOutputStream(new File(html.getAbsolutePath()))));
    }

    public void save() throws IOException {
        if (this.location != null) {
            File file = new File(this.location.getAbsolutePath());
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(this.getBytes());
            fos.close();
        }
    }

    private byte[] getBytes() throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<api-compatibility ");
        this.saveAttribute(sb, "name", this.getName());
        sb.append(">");
        sb.append("<new-apis>");
        Iterator it = this.getNewAPIs().iterator();
        while (it.hasNext()) {
            sb.append(((PackageAPI)it.next()).toString());
        }
        sb.append("</new-apis>");
        sb.append("<removed-apis>");
        it = this.getRemovedAPIs().iterator();
        while (it.hasNext()) {
            sb.append(((PackageAPI)it.next()).toString());
        }
        sb.append("</removed-apis>");
        sb.append("</api-compatibility>");
        return sb.toString().getBytes("UTF-8");
    }

    protected void saveAttribute(StringBuffer sb, String key, String value) {
        if (key != null && value != null) {
            sb.append(" ");
            sb.append(key);
            sb.append("=\"");
            sb.append(value);
            sb.append("\"");
        }
    }
}

