/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.violation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.wtp.releng.tools.component.IClassVisitor;
import org.eclipse.wtp.releng.tools.component.IFileLocation;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationChildrenIterator;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.IZipLocation;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LibVisitor
implements ILocationVisitor {
    private IClassVisitor classVisitor = null;
    private Map lib2pluginId = new HashMap();

    public Map getLib2PluginId() {
        return this.lib2pluginId;
    }

    public void setClassVisitor(IClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    public boolean accept(ILocation location) {
        String locationName = location.getName();
        if (this.classVisitor == null) {
            if (locationName.endsWith("MANIFEST.MF")) {
                this.acceptManifest(location);
            } else {
                if (Location.isArchive(locationName)) {
                    return this.acceptSingleJar(location);
                }
                if (locationName.endsWith(".classpath")) {
                    this.acceptDotClasspath(location);
                }
            }
        } else if (this.classVisitor != null) {
            String id;
            String idTemp = (String)this.lib2pluginId.get(locationName.replace('\\', '/'));
            if (idTemp == null) {
                idTemp = (String)this.lib2pluginId.get(location.getAbsolutePath().replace('\\', '/'));
            }
            if ((id = idTemp) != null) {
                location.accept(new ILocationVisitor(){

                    public boolean accept(ILocation location) {
                        if (location.getName().endsWith(".class")) {
                            LibVisitor.this.classVisitor.visit(id, location);
                        }
                        return true;
                    }
                });
            }
        }
        if (location instanceof IZipLocation) {
            return true;
        }
        return location instanceof IFileLocation && ((IFileLocation)location).getFile().isDirectory();
    }

    private void acceptManifest(ILocation location) {
        String locationName = location.getName();
        try {
            Manifest manifest = new Manifest(location.getInputStream());
            Attributes attrs = manifest.getMainAttributes();
            String bundleNameAttr = attrs.getValue(new Attributes.Name("Bundle-SymbolicName"));
            if (bundleNameAttr != null) {
                String bundleName = new StringTokenizer(bundleNameAttr, ";").nextToken().trim();
                String bundleCPAttr = attrs.getValue("Bundle-ClassPath");
                if (bundleCPAttr != null) {
                    StringTokenizer cp = new StringTokenizer(bundleCPAttr, ",");
                    while (cp.hasMoreTokens()) {
                        String path = cp.nextToken().trim();
                        if (path == null || path.length() <= 0) continue;
                        StringBuffer sb = new StringBuffer();
                        if (locationName.equalsIgnoreCase("MANIFEST.MF")) {
                            locationName = location.getAbsolutePath();
                        }
                        sb.append(locationName.substring(0, locationName.length() - "META-INF/MANIFEST.MF".length() - 1));
                        sb.append("/");
                        sb.append(path);
                        this.lib2pluginId.put(sb.toString().replace('\\', '/'), bundleName);
                    }
                }
            }
        }
        catch (IOException iOException) {}
    }

    private boolean acceptSingleJar(ILocation location) {
        String bundleName;
        ILocationChildrenIterator it = location.childIterator();
        ILocation child = it.next();
        while (child != null) {
            String name = child.getName();
            if (name.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                try {
                    Manifest manifest = new Manifest(child.getInputStream());
                    Attributes attrs = manifest.getMainAttributes();
                    bundleName = attrs.getValue(new Attributes.Name("Bundle-SymbolicName"));
                    if (bundleName != null) {
                        bundleName = new StringTokenizer(bundleName, ";").nextToken().trim();
                        this.lib2pluginId.put(location.getName().replace('\\', '/'), bundleName);
                        return false;
                    }
                }
                catch (IOException iOException) {}
            }
            child = it.next();
        }
        if (Location.getExtension(location.getName()).equalsIgnoreCase("jar")) {
            try {
                Attributes attrs;
                String bundleNameAttr;
                JarInputStream jis = new JarInputStream(location.getInputStream());
                Manifest manifest = jis.getManifest();
                if (manifest != null && (bundleNameAttr = (attrs = manifest.getMainAttributes()).getValue(new Attributes.Name("Bundle-SymbolicName"))) != null && (bundleName = new StringTokenizer(bundleNameAttr, ";").nextToken().trim()) != null) {
                    bundleName = new StringTokenizer(bundleName, ";").nextToken().trim();
                    this.lib2pluginId.put(location.getName().replace('\\', '/'), bundleName);
                    return false;
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private void acceptDotClasspath(ILocation location) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(location.getInputStream());
            Element root = doc.getDocumentElement();
            if (root.getTagName().equals("classpath")) {
                NodeList cpEntries = root.getElementsByTagName("classpathentry");
                int i = 0;
                while (i < cpEntries.getLength()) {
                    Element cpEntry = (Element)cpEntries.item(i);
                    String kind = cpEntry.getAttribute("kind");
                    if (kind != null && kind.equals("output")) {
                        String path = cpEntry.getAttribute("path");
                        String absPath = location.getAbsolutePath().replace('\\', '/');
                        StringBuffer lib = new StringBuffer();
                        int j = absPath.lastIndexOf(47);
                        String s = absPath.substring(0, j);
                        String id = s.substring(s.lastIndexOf(47) + 1, j);
                        lib.append(s);
                        lib.append('/');
                        lib.append(path);
                        this.lib2pluginId.put(lib.toString(), id);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {}
    }
}

