/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.xsl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLUtil {
    private static final String USER_DIR = "user.dir";

    public static void transform(InputStream xsl, File f, OutputStream os, String userDir) throws TransformerException, TransformerConfigurationException, IOException {
        XSLUtil.transform(xsl, new FileInputStream(f), os, userDir);
    }

    public static void transform(InputStream xsl, InputStream data, OutputStream os, String userDir) throws TransformerException, TransformerConfigurationException, IOException {
        String currUserDir = System.getProperty(USER_DIR);
        System.setProperty(USER_DIR, userDir);
        XSLUtil.transform(xsl, data, os);
        System.setProperty(USER_DIR, currUserDir);
    }

    public static void transform(InputStream xsl, File f, OutputStream os) throws TransformerException, TransformerConfigurationException, IOException {
        XSLUtil.transform(xsl, new FileInputStream(f), os);
    }

    public static void transform(InputStream xsl, InputStream data, OutputStream os) throws TransformerException, TransformerConfigurationException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(xsl));
        transformer.transform(new StreamSource(data), new StreamResult(os));
        os.close();
        xsl.close();
    }
}

