/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;

public class LanguageConfigurationCharacterPairMatcher
implements ICharacterPairMatcher,
ICharacterPairMatcherExtension {
    private @Nullable DefaultCharacterPairMatcher matcher;
    private @Nullable IDocument document;

    public @Nullable IRegion match(@Nullable IDocument document, int offset) {
        if (document == null) {
            return null;
        }
        return this.getMatcher(document).match(document, offset);
    }

    public @Nullable IRegion match(@Nullable IDocument document, int offset, int length) {
        if (document == null) {
            return null;
        }
        return this.getMatcher(document).match(document, offset, length);
    }

    public int getAnchor() {
        return this.matcher != null ? this.matcher.getAnchor() : -1;
    }

    public @Nullable IRegion findEnclosingPeerCharacters(@Nullable IDocument document, int offset, int length) {
        if (document == null) {
            return null;
        }
        return this.getMatcher(document).findEnclosingPeerCharacters(document, offset, length);
    }

    public boolean isMatchedChar(char ch) {
        IDocument document = this.document;
        if (document == null) {
            return false;
        }
        return this.getMatcher(document).isMatchedChar(ch);
    }

    public boolean isMatchedChar(char ch, @Nullable IDocument document, int offset) {
        if (document == null) {
            return false;
        }
        return this.getMatcher(document).isMatchedChar(ch, document, offset);
    }

    public boolean isRecomputationOfEnclosingPairRequired(@Nullable IDocument document, @Nullable IRegion currentSelection, @Nullable IRegion previousSelection) {
        if (document == null) {
            return false;
        }
        return this.getMatcher(document).isRecomputationOfEnclosingPairRequired(document, currentSelection, previousSelection);
    }

    public void dispose() {
        if (this.matcher != null) {
            this.matcher.dispose();
        }
        this.matcher = null;
    }

    public void clear() {
        if (this.matcher != null) {
            this.matcher.clear();
        }
    }

    private DefaultCharacterPairMatcher getMatcher(IDocument document) {
        DefaultCharacterPairMatcher matcher = this.matcher;
        if (matcher == null || !document.equals(this.document)) {
            this.document = document;
            StringBuilder sb = new StringBuilder();
            IContentType[] contentTypes = this.findContentTypes(document);
            if (contentTypes != null) {
                LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
                IContentType[] iContentTypeArray = contentTypes;
                int n = contentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentType contentType = iContentTypeArray[n2];
                    if (registry.shouldSurroundingPairs(document, -1, contentType)) {
                        List<AutoClosingPair> surroundingPairs = registry.getSurroundingPairs(contentType);
                        for (AutoClosingPair surroundingPair : surroundingPairs) {
                            sb.append(surroundingPair.open);
                            sb.append(surroundingPair.close);
                        }
                    }
                    ++n2;
                }
            }
            char[] chars = new char[sb.length()];
            sb.getChars(0, sb.length(), chars, 0);
            this.matcher = matcher = new DefaultCharacterPairMatcher(chars);
        }
        return matcher;
    }

    private IContentType @Nullable [] findContentTypes(IDocument document) {
        try {
            ContentTypeInfo info = ContentTypeHelper.findContentTypes((IDocument)document);
            if (info != null) {
                return info.getContentTypes();
            }
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

