/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerToolTip;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.actions.NewServerWizardAction;
import org.eclipse.wst.server.ui.internal.view.servers.CopyAction;
import org.eclipse.wst.server.ui.internal.view.servers.GlobalDeleteAction;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleSloshAction;
import org.eclipse.wst.server.ui.internal.view.servers.MonitorServerPortAction;
import org.eclipse.wst.server.ui.internal.view.servers.OpenAction;
import org.eclipse.wst.server.ui.internal.view.servers.PasteAction;
import org.eclipse.wst.server.ui.internal.view.servers.PropertiesAction;
import org.eclipse.wst.server.ui.internal.view.servers.PublishAction;
import org.eclipse.wst.server.ui.internal.view.servers.PublishCleanAction;
import org.eclipse.wst.server.ui.internal.view.servers.RemoveModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.RenameAction;
import org.eclipse.wst.server.ui.internal.view.servers.RestartModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.ServerTableViewer;
import org.eclipse.wst.server.ui.internal.view.servers.ServersViewDropAdapter;
import org.eclipse.wst.server.ui.internal.view.servers.ShowInConsoleAction;
import org.eclipse.wst.server.ui.internal.view.servers.ShowInDebugAction;
import org.eclipse.wst.server.ui.internal.view.servers.StartAction;
import org.eclipse.wst.server.ui.internal.view.servers.StartModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.StopAction;
import org.eclipse.wst.server.ui.internal.view.servers.StopModuleAction;

public class ServersView
extends ViewPart {
    private static final String TAG_COLUMN_WIDTH = "columnWidth";
    private static final String SERVERS_VIEW_CONTEXT = "org.eclipse.ui.serverViewScope";
    protected Action noneAction = new Action(Messages.dialogMonitorNone){};
    protected int[] cols;
    protected Tree treeTable;
    protected ServerTableViewer tableViewer;
    protected Action[] actions;
    protected Action actionModifyModules;
    protected Action openAction;
    protected Action showInConsoleAction;
    protected Action showInDebugAction;
    protected Action propertiesAction;
    protected Action monitorPropertiesAction;
    protected Action globalDeleteAction;
    protected Action copyAction;
    protected Action pasteAction;
    protected Action deleteAction;
    protected Action renameAction;

    protected SelectionListener getHeaderListener(final int col) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServersView.this.tableViewer == null) {
                    return;
                }
                TreeColumn column = (TreeColumn)e.widget;
                ServersView.this.tableViewer.resortTable(column, col);
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.treeTable = new Tree(parent, 66308);
        this.treeTable.setHeaderVisible(true);
        this.treeTable.setLinesVisible(false);
        this.treeTable.setLayoutData((Object)new GridData(1808));
        this.treeTable.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.treeTable, "org.eclipse.wst.server.ui.svcp0000");
        TreeColumn column = new TreeColumn(this.treeTable, 4);
        column.setText(Messages.viewServer);
        column.setWidth(this.cols[0]);
        column.addSelectionListener(this.getHeaderListener(0));
        this.treeTable.setSortColumn(column);
        this.treeTable.setSortDirection(128);
        TreeColumn column2 = new TreeColumn(this.treeTable, 4);
        column2.setText(Messages.viewState);
        column2.setWidth(this.cols[1]);
        column2.addSelectionListener(this.getHeaderListener(1));
        TreeColumn column3 = new TreeColumn(this.treeTable, 4);
        column3.setText(Messages.viewStatus);
        column3.setWidth(this.cols[2]);
        column3.addSelectionListener(this.getHeaderListener(2));
        IContextService contextSupport = (IContextService)this.getSite().getService(IContextService.class);
        contextSupport.activateContext(SERVERS_VIEW_CONTEXT);
        this.deferInitialization();
    }

    private void deferInitialization() {
        TreeItem item = new TreeItem(this.treeTable, 0);
        item.setText(Messages.viewInitializing);
        this.tableViewer = new ServerTableViewer(this, this.treeTable);
        this.initializeActions((ISelectionProvider)this.tableViewer);
        Job job = new Job(Messages.jobInitializingServersView){

            public IStatus run(IProgressMonitor monitor) {
                IServer[] servers = ServerCore.getServers();
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    ((Server)servers[i]).getAllModules().iterator();
                    ++i;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServersView.this.deferredInitialize();
                        }
                        catch (Exception exception) {}
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    protected void deferredInitialize() {
        this.tableViewer.initialize();
        this.tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                block3: {
                    try {
                        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                        Object data = sel.getFirstElement();
                        if (!(data instanceof IServer)) {
                            return;
                        }
                        IServer server = (IServer)data;
                        ServerUIPlugin.editServer(server);
                    }
                    catch (Exception e) {
                        if (!Trace.SEVERE) break block3;
                        Trace.trace("/severe", "Could not open server", e);
                    }
                }
            }
        });
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        final Shell shell = this.treeTable.getShell();
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ServersView.this.fillContextMenu(shell, mgr);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.treeTable);
        this.treeTable.setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.initDragAndDrop();
        ServerToolTip toolTip = new ServerToolTip(this.treeTable);
        toolTip.setShift(new Point(10, 3));
        toolTip.setPopupDelay(400);
        toolTip.setHideOnMouseDown(true);
        toolTip.activate();
        if (this.tableViewer.getTree().getItemCount() > 0) {
            Object obj = this.tableViewer.getTree().getItem(0).getData();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(obj));
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                IServer[] servers = ServerCore.getServers();
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    IServer server = servers[i];
                    if (server.getServerType() != null) {
                        server.getServerState();
                    }
                    ++i;
                }
            }
        };
        thread.setDaemon(true);
        thread.setPriority(2);
        thread.start();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.cols = new int[3];
        int i = 0;
        while (i < 3) {
            Integer in;
            this.cols[i] = 200;
            if (memento != null && (in = memento.getInteger(TAG_COLUMN_WIDTH + i)) != null && in > 5) {
                this.cols[i] = in;
            }
            ++i;
        }
    }

    public void saveState(IMemento memento) {
        TreeColumn[] tc = this.treeTable.getColumns();
        int i = 0;
        while (i < 3) {
            int width = tc[i].getWidth();
            if (width != 0) {
                memento.putInteger(TAG_COLUMN_WIDTH + i, width);
            }
            ++i;
        }
    }

    public void initializeActions(ISelectionProvider provider) {
        Shell shell = this.getSite().getShell();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.actions = new Action[6];
        this.actions[0] = new StartAction(shell, provider, "debug");
        actionBars.setGlobalActionHandler("org.eclipse.wst.server.debug", (IAction)this.actions[0]);
        this.actions[1] = new StartAction(shell, provider, "run");
        actionBars.setGlobalActionHandler("org.eclipse.wst.server.run", (IAction)this.actions[1]);
        this.actions[2] = new StartAction(shell, provider, "profile");
        this.actions[3] = new StopAction(shell, provider);
        actionBars.setGlobalActionHandler("org.eclipse.wst.server.stop", (IAction)this.actions[3]);
        this.actions[4] = new PublishAction(shell, provider);
        actionBars.setGlobalActionHandler("org.eclipse.wst.server.publish", (IAction)this.actions[4]);
        this.actions[5] = new PublishCleanAction(shell, provider);
        this.openAction = new OpenAction(provider);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        this.pasteAction = new PasteAction(shell, provider, this.tableViewer.clipboard);
        this.copyAction = new CopyAction(provider, this.tableViewer.clipboard, this.pasteAction);
        this.deleteAction = new GlobalDeleteAction(shell, provider);
        this.globalDeleteAction = new GlobalDeleteAction(shell, provider);
        this.renameAction = new RenameAction(shell, this.tableViewer, provider);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.globalDeleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
        this.actionModifyModules = new ModuleSloshAction(shell, provider);
        this.showInConsoleAction = new ShowInConsoleAction(provider);
        this.showInDebugAction = new ShowInDebugAction(provider);
        this.propertiesAction = new PropertiesAction(shell, provider);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        this.monitorPropertiesAction = new PropertiesAction(shell, "org.eclipse.wst.server.ui.properties.monitor", provider);
        IToolBarManager cm = actionBars.getToolBarManager();
        int i = 0;
        while (i < this.actions.length - 1) {
            cm.add((IAction)this.actions[i]);
            ++i;
        }
        cm.add((IContributionItem)new Separator("additions"));
    }

    private static void fillNewContextMenu(Shell shell, ISelection selection, IMenuManager menu) {
        NewServerWizardAction newServerAction = new NewServerWizardAction();
        newServerAction.setText(Messages.actionNewServer);
        menu.add((IAction)newServerAction);
    }

    protected void fillContextMenu(Shell shell, IMenuManager menu) {
        IServer server = null;
        IModule[] module = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            Object obj = iterator.next();
            if (obj instanceof IServer) {
                server = (IServer)obj;
            }
            if (obj instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)obj;
                server = ms.server;
                module = ms.module;
            }
            if (iterator.hasNext()) {
                server = null;
                module = null;
            }
        }
        MenuManager newMenu = new MenuManager(Messages.actionNew);
        ServersView.fillNewContextMenu(null, (ISelection)selection, (IMenuManager)newMenu);
        menu.add((IContributionItem)newMenu);
        if (server != null && module == null) {
            menu.add((IAction)this.openAction);
            String text = Messages.actionShowIn;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IBindingService bindingService = (IBindingService)workbench.getAdapter(IBindingService.class);
            TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.navigate.showInQuickMenu");
            if (activeBindings.length > 0) {
                text = String.valueOf(text) + "\t" + activeBindings[0].format();
            }
            MenuManager showInMenu = new MenuManager(text);
            showInMenu.add((IAction)this.showInConsoleAction);
            showInMenu.add((IAction)this.showInDebugAction);
            menu.add((IContributionItem)showInMenu);
            menu.add((IContributionItem)new Separator());
        } else {
            menu.add((IContributionItem)new Separator());
        }
        if (server != null) {
            if (module == null) {
                menu.add((IAction)this.copyAction);
                menu.add((IAction)this.pasteAction);
                menu.add((IAction)this.deleteAction);
                menu.add((IAction)this.renameAction);
            } else if (module.length == 1) {
                menu.add((IAction)new RemoveModuleAction(shell, server, module[0]));
            }
            menu.add((IContributionItem)new Separator());
        }
        if (server != null && module == null) {
            int i = 0;
            while (i < this.actions.length) {
                menu.add((IAction)this.actions[i]);
                ++i;
            }
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.actionModifyModules);
            if (server.getServerType() != null) {
                final MenuManager menuManager = new MenuManager(Messages.actionMonitor);
                final IServer server2 = server;
                final Shell shell2 = shell;
                menuManager.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        ServerPort[] ports;
                        menuManager.removeAll();
                        if (server2.getAdapter(ServerDelegate.class) != null && (ports = server2.getServerPorts(null)) != null) {
                            int size = ports.length;
                            int i = 0;
                            while (i < size) {
                                if (!ports[i].isAdvanced()) {
                                    menuManager.add((IAction)new MonitorServerPortAction(shell2, server2, ports[i]));
                                }
                                ++i;
                            }
                        }
                        if (menuManager.isEmpty()) {
                            menuManager.add((IAction)ServersView.this.noneAction);
                        }
                        menuManager.add((IContributionItem)new Separator());
                        menuManager.add((IAction)ServersView.this.monitorPropertiesAction);
                    }
                });
                this.noneAction.setEnabled(false);
                menuManager.add((IAction)this.noneAction);
                menu.add((IContributionItem)menuManager);
            }
        }
        if (server != null && module != null) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)new StartModuleAction(server, module));
            menu.add((IAction)new StopModuleAction(server, module));
            menu.add((IAction)new RestartModuleAction(server, module));
        }
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        if (server != null) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.propertiesAction);
        }
    }

    public void setFocus() {
        if (this.treeTable != null) {
            this.treeTable.setFocus();
        }
    }

    protected void initDragAndDrop() {
        int ops = 1;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        this.tableViewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)new ServersViewDropAdapter((Viewer)this.tableViewer));
    }
}

