/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors.report2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.wb.internal.core.editor.errors.report2.FileReportEntry;

public final class ScreenshotFileReportEntry
extends FileReportEntry {
    public ScreenshotFileReportEntry(String filePath) {
        super(filePath);
    }

    @Override
    protected String getName() {
        String filePath = this.getFilePath();
        String name = this.isBmp() ? String.valueOf(FilenameUtils.getBaseName((String)filePath)) + ".png" : FilenameUtils.getName((String)filePath);
        return "screenshots/" + name;
    }

    @Override
    protected InputStream getContents() throws Exception {
        if (this.isBmp()) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.load(this.getFilePath());
            imageLoader.save((OutputStream)outStream, 5);
            return new ByteArrayInputStream(outStream.toByteArray());
        }
        return super.getContents();
    }

    private boolean isBmp() {
        return FilenameUtils.getExtension((String)this.getFilePath()).equalsIgnoreCase("bmp");
    }
}

