/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.internal.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.xwt.XWT;

public class ObjectUtil {
    public static final Class<?>[] EMPTY = new Class[0];

    private ObjectUtil() {
    }

    public static Class<?> normalizedType(Class<?> type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    public static boolean isAssignableFrom(Class<?> source, Class<?> target) {
        if (ObjectUtil.normalizedType(source) == ObjectUtil.normalizedType(target)) {
            return true;
        }
        return source.isAssignableFrom(target);
    }

    public static final Class<?>[] findCompatibleClasses(Class<?> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        classes.add(clazz);
        if (clazz == Boolean.class) {
            classes.add(Boolean.TYPE);
        } else if (clazz == Byte.class) {
            classes.add(Byte.TYPE);
        } else if (clazz == Short.class) {
            classes.add(Short.TYPE);
        } else if (clazz == Integer.class) {
            classes.add(Integer.TYPE);
        } else if (clazz == Long.class) {
            classes.add(Long.TYPE);
        } else if (clazz == Float.class) {
            classes.add(Float.TYPE);
        } else if (clazz == Double.class) {
            classes.add(Double.TYPE);
        } else if (clazz == Character.class) {
            classes.add(Character.TYPE);
        } else if (clazz == Boolean.TYPE) {
            classes.add(Boolean.class);
        } else if (clazz == Byte.TYPE) {
            classes.add(Byte.class);
        } else if (clazz == Short.TYPE) {
            classes.add(Short.class);
        } else if (clazz == Integer.TYPE) {
            classes.add(Integer.class);
        } else if (clazz == Long.TYPE) {
            classes.add(Long.class);
        } else if (clazz == Float.TYPE) {
            classes.add(Float.class);
        } else if (clazz == Double.TYPE) {
            classes.add(Double.class);
        } else if (clazz == Character.TYPE) {
            classes.add(Character.class);
        }
        ObjectUtil.findInterfaces(classes, clazz);
        ObjectUtil.findSuperClasses(classes, clazz);
        classes.add(Object.class);
        return classes.toArray(EMPTY);
    }

    public static Object resolveValue(Object value, Class<?> targetType, Object defaultValue) {
        return ObjectUtil.resolveValue(value, value.getClass(), targetType, defaultValue);
    }

    public static Object resolveValue(Object value, Class<?> sourceType, Class<?> targetType, Object defaultValue) {
        IConverter converter = XWT.findConvertor(sourceType, targetType);
        if (converter != null) {
            return converter.convert(value);
        }
        return defaultValue;
    }

    public static final Constructor<?> findConstructor(Class<?> clazz, Class<?> ... argumentTypes) {
        Class[][] classesArray = new Class[argumentTypes.length][];
        int i = 0;
        int len = argumentTypes.length;
        while (i < len) {
            Class<?>[] classArray = ObjectUtil.findCompatibleClasses(argumentTypes[i]);
            classesArray[i] = classArray;
            ++i;
        }
        int totalPossibles = 1;
        int i2 = 0;
        while (i2 < classesArray.length) {
            totalPossibles *= classesArray[i2].length;
            ++i2;
        }
        ArrayList<Class<?>[]> classList = new ArrayList<Class<?>[]>(totalPossibles);
        ObjectUtil.computeArguments(classList, classesArray, new Class[classesArray.length], 0);
        for (Class[] classArray : classList) {
            try {
                return clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final Method findMethod(Class<?> clazz, String name, Class<?> ... argumentTypes) {
        if (argumentTypes != null && argumentTypes.length > 0) {
            Class[][] classesArray = new Class[argumentTypes.length][];
            int i = 0;
            int len = argumentTypes.length;
            while (i < len) {
                Class<?>[] classArray = ObjectUtil.findCompatibleClasses(argumentTypes[i]);
                classesArray[i] = classArray;
                ++i;
            }
            int totalPossibles = 1;
            int i2 = 0;
            while (i2 < classesArray.length) {
                totalPossibles *= classesArray[i2].length;
                ++i2;
            }
            ArrayList<Class<?>[]> classList = new ArrayList<Class<?>[]>(totalPossibles);
            ObjectUtil.computeArguments(classList, classesArray, new Class[classesArray.length], 0);
            for (Class[] classArray : classList) {
                try {
                    return clazz.getDeclaredMethod(name, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        } else {
            Method[] methods;
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(name)) {
                    return method;
                }
                ++n2;
            }
        }
        return null;
    }

    public static final Method findDeclaredMethod(Class<?> clazz, String name, Class<?> ... argumentTypes) {
        if (argumentTypes != null && argumentTypes.length > 0) {
            Class[][] classesArray = new Class[argumentTypes.length][];
            int i = 0;
            int len = argumentTypes.length;
            while (i < len) {
                Class<?>[] classArray = ObjectUtil.findCompatibleClasses(argumentTypes[i]);
                classesArray[i] = classArray;
                ++i;
            }
            int totalPossibles = 1;
            int i2 = 0;
            while (i2 < classesArray.length) {
                totalPossibles *= classesArray[i2].length;
                ++i2;
            }
            ArrayList<Class<?>[]> classList = new ArrayList<Class<?>[]>(totalPossibles);
            ObjectUtil.computeArguments(classList, classesArray, new Class[classesArray.length], 0);
            for (Class[] classArray : classList) {
                try {
                    return clazz.getDeclaredMethod(name, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        } else {
            Method[] methods;
            Method[] methodArray = methods = clazz.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(name) && method.getParameterTypes().length == 0) {
                    return method;
                }
                ++n2;
            }
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            return ObjectUtil.findDeclaredMethod(superclass, name, argumentTypes);
        }
        return null;
    }

    public static final Method findGetter(Class<?> clazz, String name, Class<?> type) {
        Method method;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid getter method name, null value found");
        }
        String getterName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            method = clazz.isEnum() ? clazz.getClass().getMethod(getterName, EMPTY) : clazz.getMethod(getterName, EMPTY);
        }
        catch (NoSuchMethodException e1) {
            getterName = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
            try {
                method = clazz.getMethod(getterName, EMPTY);
                if (method.getReturnType() != Boolean.class && method.getReturnType() != Boolean.TYPE) {
                    return null;
                }
            }
            catch (NoSuchMethodException e2) {
                method = ObjectUtil.findCaseIgnoreGetter(clazz, name, type);
            }
        }
        if (type == null) {
            return method;
        }
        if (method != null) {
            Class<?>[] types;
            Class<?> returnType = method.getReturnType();
            Class<?>[] classArray = types = ObjectUtil.findCompatibleClasses(type);
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> t = classArray[n2];
                if (t == returnType) {
                    return method;
                }
                ++n2;
            }
        }
        return null;
    }

    private static Method findCaseIgnoreGetter(Class<?> clazz, String name, Class<?> type) {
        String getterName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        String isName = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method element = methodArray[n2];
            if (element.getParameterTypes().length == 0) {
                if (element.getName().equalsIgnoreCase(getterName)) {
                    return element;
                }
                if (element.getName().equalsIgnoreCase(isName) && element.getReturnType() != Boolean.class && element.getReturnType() != Boolean.TYPE) {
                    return element;
                }
            }
            ++n2;
        }
        return null;
    }

    private static void findSuperClasses(Set<Class<?>> list, Class<?> clazz) {
        Class<?> superClass;
        if (clazz != null && (superClass = clazz.getSuperclass()) != Object.class) {
            list.add(superClass);
            ObjectUtil.findInterfaces(list, superClass);
            ObjectUtil.findSuperClasses(list, superClass);
        }
    }

    private static void findInterfaces(Set<Class<?>> list, Class<?> clazz) {
        if (clazz != null) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = clazz.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfac1 = classArray[n2];
                list.add(interfac1);
                ObjectUtil.findInterfaces(list, interfac1);
                ++n2;
            }
        }
    }

    private static void computeArguments(List<Class<?>[]> list, Class<?>[][] arguments, Class<?>[] buffer, int start) {
        if (start >= arguments.length) {
            Class[] classes = new Class[arguments.length];
            int i = 0;
            while (i < arguments.length) {
                classes[i] = buffer[i];
                ++i;
            }
            list.add(classes);
            return;
        }
        int i = 0;
        while (i < arguments[start].length) {
            buffer[start] = arguments[start][i];
            ObjectUtil.computeArguments(list, arguments, buffer, start + 1);
            ++i;
        }
    }
}

