/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SelectAllAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ActionGroup {
    public static final int SELECTION_GRP = 0;
    public static final int PROPERTY_GRP = 1;
    public static final int STACK_GRP = 2;
    private IEditorPart editor;
    private ActionRegistry actionRegistry;
    private List<String> selectionActions = new ArrayList<String>();
    private List<String> stackActions = new ArrayList<String>();
    private List<String> propertyActions = new ArrayList<String>();

    public ActionGroup(IEditorPart editor) {
        this.editor = editor;
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = (ActionRegistry)this.editor.getAdapter(ActionRegistry.class);
        }
        return this.actionRegistry;
    }

    public void createActions() {
        UndoAction action = new UndoAction(this.editor);
        action.setText("&Undo \tCTRL+Z");
        this.getActionRegistry().registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction(this.editor);
        action.setText("&Redo \tCTRL+Y");
        this.getActionRegistry().registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new SelectAllAction((IWorkbenchPart)this.editor);
        this.getActionRegistry().registerAction((IAction)action);
        DeleteAction deleteAction = new DeleteAction((IWorkbenchPart)this.editor);
        deleteAction.setAccelerator(Integer.valueOf(127).intValue());
        this.getActionRegistry().registerAction((IAction)deleteAction);
        this.getSelectionActions().add(deleteAction.getId());
    }

    protected List<String> getSelectionActions() {
        return this.selectionActions;
    }

    protected List<String> getPropertyActions() {
        return this.propertyActions;
    }

    protected List<String> getStackActions() {
        return this.stackActions;
    }

    public void updateActions(int gourp) {
        switch (gourp) {
            case 0: {
                this.updateActions(this.selectionActions);
                break;
            }
            case 1: {
                this.updateActions(this.propertyActions);
                break;
            }
            case 2: {
                this.updateActions(this.stackActions);
            }
        }
    }

    protected void updateActions(List<String> actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        for (String actionId : actionIds) {
            UndoAction undoAction;
            String text;
            IAction action = registry.getAction((Object)actionId);
            if (!(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
            if (action instanceof RedoAction) {
                RedoAction redoAction = (RedoAction)action;
                text = redoAction.getText();
                if (text.endsWith("\tCtrl+Y")) continue;
                if (text.endsWith("Ctrl+Y")) {
                    text = text.substring(0, text.length() - 6);
                }
                redoAction.setText(text + "\tCtrl+Y");
                continue;
            }
            if (!(action instanceof UndoAction) || (text = (undoAction = (UndoAction)action).getText()).endsWith("\tCtrl+Z")) continue;
            if (text.endsWith("Ctrl+Z")) {
                text = text.substring(0, text.length() - 6);
            }
            undoAction.setText(text + "\tCtrl+Z");
        }
    }

    public Action getAction(String actionId) {
        return null;
    }
}

