/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex.palette;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IEditorInput;
import org.eclipse.xwt.vex.Activator;
import org.eclipse.xwt.vex.EditorMessages;
import org.eclipse.xwt.vex.VEXEditor;
import org.eclipse.xwt.vex.palette.IPaletteContentProvider;
import org.eclipse.xwt.vex.palette.PalettePathRegistry;

public class PaletteResourceManager {
    private static final String DEFAULT_PATH = EditorMessages.PaletteResourceManager_toolkit;
    private static final String DEFAULT_ICON_PATH = EditorMessages.PaletteResourceManager_icons;
    public static final String PALETTE_CONTENT_PROVIDER_ID = "org.eclipse.xwt.vex.paletteContentProvider";
    public static final String GENARATOR = "generator";
    public static final String CLASS = "class";
    private URI resourcePath;
    private URI iconsPath;
    private Resource resource;
    private Resource dynamicResource;
    private Resource customizeResource;
    private VEXEditor host = null;

    public PaletteResourceManager(VEXEditor editor) {
        assert (this.host != null);
        this.host = editor;
    }

    public Resource getResource() {
        URI modelFilePath;
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(PALETTE_CONTENT_PROVIDER_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (GENARATOR.equals(configurationElement.getName())) {
                try {
                    IPaletteContentProvider paletteContentProvider = (IPaletteContentProvider)configurationElement.createExecutableExtension(CLASS);
                    if (paletteContentProvider != null) {
                        ResourceSetImpl rs = new ResourceSetImpl();
                        String location = Activator.getDefault().getStateLocation().toPortableString();
                        URI uri = URI.createFileURI((String)(location + "/tools/toolkit.toolpalette"));
                        Resource newResource = rs.createResource(uri);
                        newResource.load(paletteContentProvider.getPaletteInputStream(), null);
                        return newResource;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        if (this.resource == null && (modelFilePath = this.getResourceFile()) != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            this.resource = resourceSet.getResource(modelFilePath, true);
        }
        return this.resource;
    }

    public Resource getDynamicResource() {
        if (this.dynamicResource == null) {
            this.dynamicResource = new ResourceImpl();
        }
        return this.dynamicResource;
    }

    public Resource getCustomizeResource() {
        if (this.customizeResource == null) {
            this.customizeResource = new ResourceImpl();
        }
        return this.customizeResource;
    }

    private IProject getCurrentProject() {
        IEditorInput editorInput = this.host.getEditorInput();
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        IProject project = file.getProject();
        if (!project.exists()) {
            return null;
        }
        return project;
    }

    public URI getIconsPath() {
        if (this.iconsPath == null) {
            this.iconsPath = this.computeIconsPath();
        }
        return this.iconsPath;
    }

    private URI computeIconsPath() {
        String pluginId;
        Object path;
        IProject currentProject = this.getCurrentProject();
        if (currentProject != null) {
            try {
                currentProject.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            IFile file = currentProject.getFile(DEFAULT_ICON_PATH);
            if (file.exists()) {
                return URI.createFileURI((String)file.getLocation().toString());
            }
        }
        if (!((String)(path = PalettePathRegistry.getIconsPath(pluginId = this.host.getEditorSite().getPluginId()))).startsWith("/")) {
            path = "/" + (String)path;
        }
        return URI.createPlatformPluginURI((String)(pluginId + (String)path), (boolean)false);
    }

    public URI getResourceFile() {
        if (this.resourcePath == null) {
            this.resourcePath = this.computeResourcePath();
        }
        return this.resourcePath;
    }

    private URI computeResourcePath() {
        String pluginId;
        Object path;
        IProject currentProject = this.getCurrentProject();
        if (currentProject != null) {
            try {
                currentProject.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            IFile file = currentProject.getFile(DEFAULT_PATH);
            if (file.exists()) {
                return URI.createFileURI((String)file.getLocation().toString());
            }
        }
        if (!((String)(path = PalettePathRegistry.getPath(pluginId = this.host.getEditorSite().getPluginId()))).startsWith("/")) {
            path = "/" + (String)path;
        }
        return URI.createPlatformPluginURI((String)(pluginId + (String)path), (boolean)false);
    }

    public void saveToolDefinition() {
        IProject currentProject = this.getCurrentProject();
        if (currentProject != null) {
            String currentProjectPath = currentProject.getName();
            String filePath = currentProjectPath + "/" + DEFAULT_PATH;
            try {
                this.resource.setURI(URI.createPlatformResourceURI((String)filePath, (boolean)false));
                this.resource.save(null);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }
}

