/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.xwt.tools.ui.designer.editor.palette.CreateReqHelper;
import org.eclipse.xwt.tools.ui.designer.editor.palette.InitializeHelper;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public abstract class AbstractCreateCommand
extends Command {
    protected EditPart parent;
    protected CreateRequest createRequest;
    protected CreateReqHelper helper;
    protected Command addChildCommand;
    private XamlNode child;

    public AbstractCreateCommand(EditPart parent, CreateRequest createRequest) {
        this.parent = parent;
        this.createRequest = createRequest;
        this.helper = new CreateReqHelper(createRequest);
        this.setLabel("Creation Command");
    }

    public void execute() {
        this.preExecute(this.child, this.createRequest);
        this.addChildCommand.execute();
    }

    protected Command createCreateCommand(XamlNode parent, XamlNode child) {
        return new AddNewChildCommand(parent, child);
    }

    public boolean canExecute() {
        if (this.child == null) {
            this.child = this.helper.getNewObject();
        }
        if (!InitializeHelper.checkValue(this.child)) {
            return false;
        }
        if (this.addChildCommand == null) {
            this.addChildCommand = this.createCreateCommand((XamlNode)this.getParentModel(), this.child);
        }
        if (this.addChildCommand == null || !this.addChildCommand.canExecute()) {
            return false;
        }
        return this.parent != null && this.getParentModel() != null && this.helper.canCreate(this.parent);
    }

    public boolean canUndo() {
        return this.addChildCommand != null && this.addChildCommand.canUndo();
    }

    public void undo() {
        this.addChildCommand.undo();
    }

    public EditPart getParent() {
        return this.parent;
    }

    public XamlElement getParentModel() {
        Object model = this.parent.getModel();
        if (!(model instanceof XamlElement)) {
            return null;
        }
        return (XamlElement)model;
    }

    protected abstract void preExecute(XamlNode var1, CreateRequest var2);
}

