/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.actions;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xwt.tools.ui.designer.dialogs.LayoutAssistantWindow;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;

public class LayoutAssistantAction
extends SelectionAction {
    public static final String ID = "org.eclipse.xwt.tools.ui.designer.editor.actions.LayoutAssistantAction";
    private LayoutAssistantWindow window;

    public LayoutAssistantAction(IWorkbenchPart part) {
        super(part);
        this.setText("Layout Assistant...");
        this.setImageDescriptor(ImageShop.getImageDescriptor("/icons/full/tools/layout_assist.gif"));
        this.setId(ID);
    }

    public void run() {
        EditPart editPart = this.getEditPart();
        if (editPart == null) {
            return;
        }
        if (this.window == null || this.window.isClosed()) {
            this.window = new LayoutAssistantWindow(this.getWorkbenchPart().getSite().getShell());
        }
        this.window.setEditPart(editPart);
        if (!this.window.isOpened()) {
            this.window.open();
        } else {
            this.window.refresh();
        }
    }

    public void dispose() {
        if (this.window != null) {
            this.window.close();
        }
        super.dispose();
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        EditPart editPart = this.getEditPart();
        if (this.window != null && this.window.isOpened() && editPart != null) {
            this.window.setEditPart(editPart);
        }
    }

    public EditPart getEditPart() {
        List selectedObjects = this.getSelectedObjects();
        if (selectedObjects.size() == 1 && selectedObjects.get(0) instanceof EditPart) {
            return (EditPart)selectedObjects.get(0);
        }
        return null;
    }

    protected boolean calculateEnabled() {
        EObject object;
        EditPart editPart = this.getEditPart();
        if (editPart == null) {
            return false;
        }
        Object model = editPart.getModel();
        return !(model instanceof EObject) || (object = (EObject)model).eContainer() != null;
    }
}

