/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.sash;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.xwt.tools.ui.designer.parts.SashFormEditPart;
import org.eclipse.xwt.tools.ui.designer.policies.NewResizableEditPolicy;

public class SashFormChildResizableEditPolicy
extends NewResizableEditPolicy {
    public static final int WIDTH = 10;

    public SashFormChildResizableEditPolicy(int directions, boolean displayNonHandles) {
        super(directions, displayNonHandles);
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart part = SashFormChildResizableEditPolicy.getTargetEditPart(request, this.getHost());
        if (part != null) {
            return part;
        }
        return super.getTargetEditPart(request);
    }

    public static EditPart getTargetEditPart(Request request, GraphicalEditPart editPart) {
        SashFormEditPart sashFormEditPart = (SashFormEditPart)editPart.getParent();
        IFigure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        Transposer transposer = new Transposer();
        transposer.setEnabled(!sashFormEditPart.isHorizontal());
        bounds = transposer.t(bounds);
        if (request instanceof CreateRequest) {
            CreateRequest createRequest = (CreateRequest)request;
            Point location = createRequest.getLocation().getCopy();
            location = transposer.t(location);
            if (location.x <= bounds.x + 10 || location.x > bounds.x + bounds.width - 10) {
                return sashFormEditPart;
            }
        } else if (request instanceof SelectionRequest) {
            SelectionRequest locationRequest = (SelectionRequest)request;
            Point location = locationRequest.getLocation().getCopy();
            location = transposer.t(location);
            List children = sashFormEditPart.getChildren();
            int index = children.indexOf(editPart);
            if (index != 0 && location.x <= bounds.x + 10) {
                return (EditPart)children.get(index - 1);
            }
            if (location.x > bounds.x + bounds.width - 10 && index != children.size() - 1) {
                return (EditPart)children.get(index + 1);
            }
        }
        return null;
    }
}

