/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ExternalizeStringsCommon {
    public static StringBuffer getHistoryContents(IFile iFile) throws IOException {
        StringBuffer fileContent = new StringBuffer();
        File file = iFile.getLocation().toFile();
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String line = br.readLine();
        while (line != null) {
            if (line.indexOf("static {") != -1) break;
            fileContent.append(line + "\r");
            line = br.readLine();
        }
        fr.close();
        br.close();
        return fileContent;
    }

    public static IFile getIFile(String folderName, String fileName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(folderName));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            ExternalizeStringsCommon.throwCoreException("Container \"" + folderName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(fileName));
        return file;
    }

    public static void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.xwt.tools.ui.designer", 0, message, null);
        throw new CoreException((IStatus)status);
    }
}

