/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.javabean.metadata.properties;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.xwt.internal.utils.ObjectUtil;
import org.eclipse.xwt.javabean.metadata.properties.AbstractProperty;
import org.eclipse.xwt.metadata.ILoadingType;

public class DynamicProperty
extends AbstractProperty {
    private final Method setter;
    private final Method getter;

    public DynamicProperty(Class<?> type, Class<?> propertyType, String name) {
        this(propertyType, DynamicProperty.createSetter0(type, propertyType, name), DynamicProperty.createGetter0(propertyType, name), name);
    }

    public DynamicProperty(Class<?> type, Class<?> propertyType, String name, ILoadingType loadingType) {
        this(propertyType, DynamicProperty.createSetter0(type, propertyType, name), DynamicProperty.createGetter0(propertyType, name), name, loadingType);
    }

    public DynamicProperty(Class<?> propertyType, Method setter, Method getter, String name) {
        this(propertyType, setter, getter, name, ILoadingType.DEFAULT);
    }

    public DynamicProperty(Class<?> propertyType, Method setter, Method getter, String name, ILoadingType loadingType) {
        super(name, propertyType, loadingType);
        this.setter = setter;
        this.getter = getter;
    }

    @Override
    public void setValue(Object target, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        this.setter.invoke(target, value);
        this.fireSetPostAction(target, this, value);
    }

    @Override
    public Object getValue(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        return this.getter.invoke(target, null);
    }

    protected static Method createSetter0(Class<?> type, Class<?> propertyType, String name) {
        try {
            return DynamicProperty.createSetter(type, propertyType, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Method createSetter(Class<?> type, Class<?> propertyType, String name) throws SecurityException, NoSuchMethodException {
        return type.getMethod("set" + Character.toUpperCase(name.charAt(0)) + name.substring(1), propertyType);
    }

    protected static Method createGetter0(Class<?> type, String name) {
        try {
            return DynamicProperty.createGetter(type, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Method createGetter(Class<?> type, String name) throws SecurityException, NoSuchMethodException {
        return ObjectUtil.findGetter(type, name, null);
    }
}

