@ECHO OFF

REM *******************************************
REM ** File Name : TsmMSSqlLogTruncation.bat **
REM *******************************************

SET ERRORLEVEL=
SET ServerName=
SET HostName=
SET DBName=
SET SQLCMDFAILED=1
SET TraceFile=%1.

REM IT15333 - using system env vars instead of user due to vmtools defect

SETX TSM_VM_SQL_LOG_TRUNC_STAT "All SQL logs truncated successfully" /m

IF NOT "%TraceFile%"=="." (
   REM Trace file was specified. Save it and trace out first message.
   SET TraceFile=%1
   ECHO Tracing started for TsmMSSqlLogTruncation.bat >> %TraceFile%
   ECHO. >> %TraceFile%
)

REM Get hostname
FOR /F "usebackq" %%I IN (`hostname`) DO SET HostName=%%I

REM Get Value from 'SQLCMD -Q :serverlist' command output
FOR /F %%G IN ('SQLCMD -Q :serverlist') DO ( 

   REM reset ERRORLEVEL
   SET ERRORLEVEL=
   REM set ServerName
   SET ServerName=%%G
   REM SQLCMD worked without error
   SET SQLCMDFAILED=0


   REM Find from output list those servers that are part of this machine.
   ECHO %%G | FIND /I "%HostName%">NUL

   IF ERRORLEVEL 1 (
      REM We want to skip this server 
   ) ELSE (
      REM Trace stmts is trace file is specified
      IF NOT "%TraceFile%"=="." (
         ECHO =========================================== >> %TraceFile%
         ECHO SERVER: %%G                                 >> %TraceFile%
         ECHO =========================================== >> %TraceFile%
      )

      REM reset ERRORLEVEL
      SET ERRORLEVEL=

      REM See if we can connect to the SQL server instance
      (SQLCMD -E -S "%%G" -Q sp_databases) | FIND /I "Error Location Server/Instance Specified">NUL
      IF ERRORLEVEL 1 (
         REM Can connect to this SQL Server instance, move to next step
         CALL :LOOP
      ) ELSE (
         IF NOT "%TraceFile%"=="." (
            ECHO Cannot connect to this SQL server instance, %%G, skip to the next instance on this VM! >> %TraceFile%
            ECHO. >> %TraceFile%
         )
      )
   )
)
GOTO :EXIT

:LOOP
REM List databases for this sql server instance
FOR /F "skip=2 tokens=*" %%H IN ('SQLCMD -E -S "%ServerName%" -W -Q "select name from sys.databases"') DO (
   
   REM set database name
   SET DBName=%%H

   REM reset ERRORLEVEL
   SET ERRORLEVEL=
   
   REM The list databases command returns (# rows affected). Checking for that last line so that we do not process it.
   ECHO %%H | FIND /I "rows affected)">NUL 
   IF ERRORLEVEL 1 (     
      IF NOT "%TraceFile%"=="." (
         ECHO ------------------------------------------- >> %TraceFile%
         ECHO Database: %%H                               >> %TraceFile%
         ECHO ------------------------------------------- >> %TraceFile%
      )

      REM Find the recovery model for each database
      (SQLCMD -E -S "%ServerName%" -Q "select recovery_model_desc from sys.databases where name = '%%H'") | FIND "FULL">NUL

      IF ERRORLEVEL 1 ( 
         REM We want to skip this database since it does not have FULL recovery model
         IF NOT "%TraceFile%"=="." (
            ECHO Skipping database since it does not have FULL recovery model >> %TraceFile%
         )
      )
      IF NOT ERRORLEVEL 1 ( 
         CALL :TRUNC_LOGS 
      )
   )
)
GOTO :EOF


:TRUNC_LOGS
REM Run the backup log command to truncate the SQL logs.
FOR /F "tokens=*" %%J IN ('SQLCMD -E -S "%ServerName%" -Q "BACKUP LOG [%DBName%] TO DISK = N'NUL' WITH NOFORMAT, NOINIT, NAME = N'%DBName%-logbackup', SKIP, NOREWIND, NOUNLOAD, STATS = 10"') DO (
   
   IF NOT "%TraceFile%"=="." (
      ECHO %%J >> %TraceFile%
   )

   IF "%%J" == "BACKUP LOG is terminating abnormally." (
      SETX TSM_VM_SQL_LOG_TRUNC_STAT "BACKUP LOG cannot be performed because there is no current database backup for %DBNAME%." /m
   )
)
GOTO :EOF


:EXIT

IF %SQLCMDFAILED%==1 (
   SETX TSM_VM_SQL_LOG_TRUNC_STAT "BACKUP LOG cannot be performed because 'SQLCMD -Q :serverlist' failed." /m
)

IF NOT "%TraceFile%"=="." (
   REM Trace file was specified. Save it and trace out first message.
   ECHO. >> %TraceFile%
   ECHO ** %TSM_VM_SQL_LOG_TRUNC_STAT% >> %TraceFile%
   ECHO Tracing ended for TsmMSSqlLogTruncation.bat >> %TraceFile%
)
