/***********************************************************************
* Name:
*        dapirc.c
*
* Function:
*        Outputs text for the return code passed.
*
* Environment:
*        This is a PLATFORM-INDEPENDENT source file. As such it may
*        contain no dependencies on any specific operating system
*        environment or hardware platform.
*
* Public Routines:
*        rcApiOut(rc)
***********************************************************************/
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dsmapitd.h"
#include "dsmapifp.h"
#include "dsmrc.h"
#include "dapitype.h"
#include "dapiproc.h"

void rcApiOut(dsUint32_t dsmHandle, dsInt16_t rc)
{

     char *msgBuf ;

     if ((msgBuf = (char *)malloc(DSM_MAX_RC_MSG_LENGTH+1)) == NULL)
     {
          printf("Abort: Not enough memory.\n") ;
          exit(1) ;
     }

     dsmRCMsg(dsmHandle,rc, msgBuf);
#ifdef WIN32
     CharToOemBuff(msgBuf, msgBuf, strlen(msgBuf));
#endif
     printf("%s\n",msgBuf);

     free(msgBuf) ;

     return;
}
