/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Named;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.SvgElementFinder;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class GraphElementFinder
extends SvgElementFinder {
    private final Map<String, MutableNode> nodes;
    private final Map<String, Link> links;
    private final Map<String, MutableGraph> graphs;

    public static String use(String svg, Graph g, Consumer<GraphElementFinder> actions) {
        GraphElementFinder finder = new SvgElementFinder(svg).fromGraph(g);
        actions.accept(finder);
        return finder.getSvg();
    }

    GraphElementFinder(SvgElementFinder finder, MutableGraph graph) {
        super(finder);
        this.nodes = graph.nodes().stream().collect(Collectors.toMap(n -> GraphElementFinder.name(n), n -> n));
        this.links = graph.edges().stream().collect(Collectors.toMap(e -> GraphElementFinder.name(e.from()) + "--" + GraphElementFinder.name(e.to()), e -> e));
        this.graphs = graph.graphs().stream().collect(Collectors.toMap(g -> GraphElementFinder.name(g), g -> g));
    }

    private static String name(Named named) {
        return named.name().simpleSerialized();
    }

    public MutableNode nodeOf(Element e) {
        return this.nodes.get(SvgElementFinder.nodeNameOf(e));
    }

    public Link linkOf(Element e) {
        List<String> fromTo = SvgElementFinder.linkedNodeNamesOf(e);
        return this.links.get(fromTo.get(0) + "--" + fromTo.get(1));
    }

    public MutableGraph clusterOf(Element e) {
        return this.graphs.get(SvgElementFinder.clusterNameOf(e));
    }
}

