/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger-memory.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
* SECTION:ianjuta-debugger-memory
* @title: IAnjutaDebuggerMemory
* @short_description: Memory interface for debuggers
* @see_also: 
* @stability: Unstable
* @include: libanjuta/interfaces/ianjuta-debugger-memory.h
* 
 	* This interface is used to examine the target memory.
*/

#include "ianjuta-debugger-memory.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_debugger_memory_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-debugger-memory-quark");
	}
	
	return quark;
}

/**
* ianjuta_debugger_memory_inspect:
* @obj: Self
* @address: Start address of the memory block
* @length: Length of memory block
* @callback: Call back with a IAnjutaDebuggerMemoryBlock as argument
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Read a block of the target memory.
*
* Returns: TRUE if the request succeed and the callback is
* called. If FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_memory_inspect (IAnjutaDebuggerMemory *obj, gulong address,   guint length,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_MEMORY(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_MEMORY_GET_IFACE (obj)->inspect (obj, address, length, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_memory_inspect_default (IAnjutaDebuggerMemory *obj, gulong address,   guint length,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_debugger_memory_base_init (IAnjutaDebuggerMemoryIface* klass)
{
	static gboolean initialized = FALSE;

	klass->inspect = ianjuta_debugger_memory_inspect_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_debugger_memory_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDebuggerMemoryIface),
			(GBaseInitFunc) ianjuta_debugger_memory_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDebuggerMemory", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_DEBUGGER);
	}
	return type;			
}
