/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-project.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_PROJECT_H_
#define _IANJUTA_PROJECT_H_

#include <glib-object.h>
#include <libanjuta/anjuta-project.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_PROJECT (ianjuta_project_get_type ())
#define IANJUTA_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_PROJECT, IAnjutaProject))
#define IANJUTA_IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_PROJECT))
#define IANJUTA_PROJECT_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_PROJECT, IAnjutaProjectIface))

#define IANJUTA_TYPE_PROJECT_CAPABILITIES (ianjuta_project_capabilities_get_type())
#define IANJUTA_TYPE_PROJECT_ERROR (ianjuta_project_error_get_type())
#define IANJUTA_TYPE_PROJECT_PROBE (ianjuta_project_probe_get_type())

#define IANJUTA_PROJECT_ERROR ianjuta_project_error_quark()

typedef struct _IAnjutaProject IAnjutaProject;
typedef struct _IAnjutaProjectIface IAnjutaProjectIface;

typedef enum {
	IANJUTA_PROJECT_CAN_ADD_NONE	= 0,
	IANJUTA_PROJECT_CAN_ADD_GROUP	= 1 << 0,
	IANJUTA_PROJECT_CAN_ADD_TARGET	= 1 << 1,
	IANJUTA_PROJECT_CAN_ADD_SOURCE	= 1 << 2,
	IANJUTA_PROJECT_HAS_PACKAGES	= 1 << 3
} IAnjutaProjectCapabilities;

/* Types */
typedef enum {
	IANJUTA_PROJECT_ERROR_SUCCESS = 0,
	IANJUTA_PROJECT_ERROR_DOESNT_EXIST,
	IANJUTA_PROJECT_ERROR_ALREADY_EXISTS,
	IANJUTA_PROJECT_ERROR_VALIDATION_FAILED,
	IANJUTA_PROJECT_ERROR_PROJECT_MALFORMED,
	IANJUTA_PROJECT_ERROR_GENERAL_FAILURE
} IAnjutaProjectError;

typedef enum {
	IANJUTA_PROJECT_PROBE_FILES = 10,
	IANJUTA_PROJECT_PROBE_MAKE_FILES = 100,
	IANJUTA_PROJECT_PROBE_PROJECT_FILES = 200
} IAnjutaProjectProbe;


struct _IAnjutaProjectIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*project_updated) (IAnjutaProject *obj);

	AnjutaProjectGroup* (*add_group) (IAnjutaProject *obj, AnjutaProjectGroup *parent,  const gchar *name, GError **err);
	AnjutaProjectSource* (*add_source) (IAnjutaProject *obj, AnjutaProjectTarget *parent,  GFile *file, GError **err);
	AnjutaProjectTarget* (*add_target) (IAnjutaProject *obj, AnjutaProjectGroup *parent,  const gchar *name,  AnjutaProjectTargetType type, GError **err);
	GtkWidget* (*configure) (IAnjutaProject *obj, GError **err);
	GtkWidget* (*configure_node) (IAnjutaProject *obj, AnjutaProjectNode *node, GError **err);
	guint (*get_capabilities) (IAnjutaProject *obj, GError **err);
	GList* (*get_packages) (IAnjutaProject *obj, GError **err);
	AnjutaProjectGroup* (*get_root) (IAnjutaProject *obj, GError **err);
	GList* (*get_target_types) (IAnjutaProject *obj, GError **err);
	gboolean (*load) (IAnjutaProject *obj, GFile *file, GError **err);
	gboolean (*refresh) (IAnjutaProject *obj, GError **err);
	gboolean (*remove_node) (IAnjutaProject *obj, AnjutaProjectNode *node, GError **err);

};

GType ianjuta_project_capabilities_get_type (void);
GType ianjuta_project_error_get_type (void);
GType ianjuta_project_probe_get_type (void);

GQuark ianjuta_project_error_quark     (void);
GType  ianjuta_project_get_type        (void);

AnjutaProjectGroup* ianjuta_project_add_group (IAnjutaProject *obj, AnjutaProjectGroup *parent,  const gchar *name, GError **err);

AnjutaProjectSource* ianjuta_project_add_source (IAnjutaProject *obj, AnjutaProjectTarget *parent,  GFile *file, GError **err);

AnjutaProjectTarget* ianjuta_project_add_target (IAnjutaProject *obj, AnjutaProjectGroup *parent,  const gchar *name,  AnjutaProjectTargetType type, GError **err);

GtkWidget* ianjuta_project_configure (IAnjutaProject *obj, GError **err);

GtkWidget* ianjuta_project_configure_node (IAnjutaProject *obj, AnjutaProjectNode *node, GError **err);

guint ianjuta_project_get_capabilities (IAnjutaProject *obj, GError **err);

GList* ianjuta_project_get_packages (IAnjutaProject *obj, GError **err);

AnjutaProjectGroup* ianjuta_project_get_root (IAnjutaProject *obj, GError **err);

GList* ianjuta_project_get_target_types (IAnjutaProject *obj, GError **err);

gboolean ianjuta_project_load (IAnjutaProject *obj, GFile *file, GError **err);

gboolean ianjuta_project_refresh (IAnjutaProject *obj, GError **err);

gboolean ianjuta_project_remove_node (IAnjutaProject *obj, AnjutaProjectNode *node, GError **err);


G_END_DECLS

#endif
