
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 29 "scannerparser.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "sourcescanner.h"
#include "scannerparser.h"

extern FILE *yyin;
extern int lineno;
extern char linebuf[2000];
extern char *yytext;

extern int yylex (GISourceScanner *scanner);
static void yyerror (GISourceScanner *scanner, const char *str);

extern void ctype_free (GISourceType * type);

static int last_enum_value = -1;
static gboolean is_bitfield;
static GHashTable *const_table = NULL;

/**
 * parse_c_string_literal:
 * @str: A string containing a C string literal
 *
 * Based on g_strcompress(), but also handles
 * hexadecimal escapes.
 */
static char *
parse_c_string_literal (const char *str)
{
  const gchar *p = str, *num;
  gchar *dest = g_malloc (strlen (str) + 1);
  gchar *q = dest;

  while (*p)
    {
      if (*p == '\\')
        {
          p++;
          switch (*p)
            {
            case '\0':
              g_warning ("parse_c_string_literal: trailing \\");
              goto out;
            case '0':  case '1':  case '2':  case '3':  case '4':
            case '5':  case '6':  case '7':
              *q = 0;
              num = p;
              while ((p < num + 3) && (*p >= '0') && (*p <= '7'))
                {
                  *q = (*q * 8) + (*p - '0');
                  p++;
                }
              q++;
              p--;
              break;
	    case 'x':
	      *q = 0;
	      p++;
	      num = p;
	      while ((p < num + 2) && (g_ascii_isxdigit(*p)))
		{
		  *q = (*q * 16) + g_ascii_xdigit_value(*p);
		  p++;
		}
              q++;
              p--;
	      break;
            case 'b':
              *q++ = '\b';
              break;
            case 'f':
              *q++ = '\f';
              break;
            case 'n':
              *q++ = '\n';
              break;
            case 'r':
              *q++ = '\r';
              break;
            case 't':
              *q++ = '\t';
              break;
            default:            /* Also handles \" and \\ */
              *q++ = *p;
              break;
            }
        }
      else
        *q++ = *p;
      p++;
    }
out:
  *q = 0;

  return dest;
}



/* Line 189 of yacc.c  */
#line 178 "scannerparser.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     IDENTIFIER = 258,
     TYPEDEF_NAME = 259,
     INTEGER = 260,
     FLOATING = 261,
     CHARACTER = 262,
     STRING = 263,
     ELLIPSIS = 264,
     ADDEQ = 265,
     SUBEQ = 266,
     MULEQ = 267,
     DIVEQ = 268,
     MODEQ = 269,
     XOREQ = 270,
     ANDEQ = 271,
     OREQ = 272,
     SL = 273,
     SR = 274,
     SLEQ = 275,
     SREQ = 276,
     EQ = 277,
     NOTEQ = 278,
     LTEQ = 279,
     GTEQ = 280,
     ANDAND = 281,
     OROR = 282,
     PLUSPLUS = 283,
     MINUSMINUS = 284,
     ARROW = 285,
     AUTO = 286,
     BOOL = 287,
     BREAK = 288,
     CASE = 289,
     CHAR = 290,
     CONST = 291,
     CONTINUE = 292,
     DEFAULT = 293,
     DO = 294,
     DOUBLE = 295,
     ELSE = 296,
     ENUM = 297,
     EXTENSION = 298,
     EXTERN = 299,
     FLOAT = 300,
     FOR = 301,
     GOTO = 302,
     IF = 303,
     INLINE = 304,
     INT = 305,
     LONG = 306,
     REGISTER = 307,
     RESTRICT = 308,
     RETURN = 309,
     SHORT = 310,
     SIGNED = 311,
     SIZEOF = 312,
     STATIC = 313,
     STRUCT = 314,
     SWITCH = 315,
     TYPEDEF = 316,
     UNION = 317,
     UNSIGNED = 318,
     VOID = 319,
     VOLATILE = 320,
     WHILE = 321,
     FUNCTION_MACRO = 322,
     OBJECT_MACRO = 323
   };
#endif
/* Tokens.  */
#define IDENTIFIER 258
#define TYPEDEF_NAME 259
#define INTEGER 260
#define FLOATING 261
#define CHARACTER 262
#define STRING 263
#define ELLIPSIS 264
#define ADDEQ 265
#define SUBEQ 266
#define MULEQ 267
#define DIVEQ 268
#define MODEQ 269
#define XOREQ 270
#define ANDEQ 271
#define OREQ 272
#define SL 273
#define SR 274
#define SLEQ 275
#define SREQ 276
#define EQ 277
#define NOTEQ 278
#define LTEQ 279
#define GTEQ 280
#define ANDAND 281
#define OROR 282
#define PLUSPLUS 283
#define MINUSMINUS 284
#define ARROW 285
#define AUTO 286
#define BOOL 287
#define BREAK 288
#define CASE 289
#define CHAR 290
#define CONST 291
#define CONTINUE 292
#define DEFAULT 293
#define DO 294
#define DOUBLE 295
#define ELSE 296
#define ENUM 297
#define EXTENSION 298
#define EXTERN 299
#define FLOAT 300
#define FOR 301
#define GOTO 302
#define IF 303
#define INLINE 304
#define INT 305
#define LONG 306
#define REGISTER 307
#define RESTRICT 308
#define RETURN 309
#define SHORT 310
#define SIGNED 311
#define SIZEOF 312
#define STATIC 313
#define STRUCT 314
#define SWITCH 315
#define TYPEDEF 316
#define UNION 317
#define UNSIGNED 318
#define VOID 319
#define VOLATILE 320
#define WHILE 321
#define FUNCTION_MACRO 322
#define OBJECT_MACRO 323




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 134 "scannerparser.y"

  char *str;
  GList *list;
  GISourceSymbol *symbol;
  GISourceType *ctype;
  StorageClassSpecifier storage_class_specifier;
  TypeQualifier type_qualifier;
  FunctionSpecifier function_specifier;
  UnaryOperator unary_operator;



/* Line 214 of yacc.c  */
#line 363 "scannerparser.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 375 "scannerparser.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  67
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1949

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  93
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  76
/* YYNRULES -- Number of rules.  */
#define YYNRULES  243
/* YYNRULES -- Number of states.  */
#define YYNSTATES  401

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   323

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    80,     2,     2,     2,    82,    75,     2,
      69,    70,    76,    77,    74,    78,    73,    81,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    88,    90,
      83,    89,    84,    87,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    71,     2,    72,    85,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    91,    86,    92,    79,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    17,    19,
      22,    24,    26,    28,    30,    35,    40,    44,    48,    52,
      55,    58,    60,    64,    66,    69,    72,    75,    78,    83,
      85,    87,    89,    91,    93,    95,    97,   102,   104,   108,
     112,   116,   118,   122,   126,   128,   132,   136,   138,   142,
     146,   150,   154,   156,   160,   164,   166,   170,   172,   176,
     178,   182,   184,   188,   190,   194,   196,   202,   204,   208,
     210,   212,   214,   216,   218,   220,   222,   224,   226,   228,
     230,   232,   236,   239,   241,   245,   248,   251,   253,   256,
     258,   261,   263,   266,   268,   270,   274,   276,   280,   282,
     284,   286,   288,   290,   292,   294,   296,   298,   300,   302,
     304,   306,   308,   310,   312,   314,   316,   322,   327,   330,
     332,   334,   336,   339,   343,   346,   348,   351,   353,   355,
     359,   360,   362,   365,   369,   375,   380,   387,   393,   396,
     398,   399,   402,   406,   408,   412,   414,   416,   418,   420,
     422,   425,   427,   429,   433,   438,   442,   447,   452,   456,
     459,   461,   465,   468,   470,   473,   475,   479,   482,   485,
     487,   489,   491,   495,   497,   500,   502,   504,   507,   511,
     514,   518,   522,   527,   530,   534,   538,   543,   545,   547,
     551,   556,   558,   562,   564,   566,   568,   570,   572,   574,
     578,   583,   587,   590,   594,   596,   599,   601,   603,   605,
     608,   614,   622,   628,   634,   642,   649,   657,   665,   674,
     682,   691,   700,   710,   714,   717,   720,   723,   727,   729,
     732,   734,   736,   738,   743,   747,   749,   752,   754,   756,
     761,   764,   766,   768
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     160,     0,    -1,    96,    -1,     5,    -1,     7,    -1,     6,
      -1,    95,    -1,    69,   116,    70,    -1,     8,    -1,    95,
       8,    -1,     3,    -1,    96,    -1,   148,    -1,    94,    -1,
      98,    71,   116,    72,    -1,    98,    69,    99,    70,    -1,
      98,    69,    70,    -1,    98,    73,    97,    -1,    98,    30,
      97,    -1,    98,    28,    -1,    98,    29,    -1,   114,    -1,
      99,    74,   114,    -1,    98,    -1,    28,   100,    -1,    29,
     100,    -1,   101,   102,    -1,    57,   100,    -1,    57,    69,
     145,    70,    -1,    75,    -1,    76,    -1,    77,    -1,    78,
      -1,    79,    -1,    80,    -1,   100,    -1,    69,   145,    70,
     102,    -1,   102,    -1,   103,    76,   102,    -1,   103,    81,
     102,    -1,   103,    82,   102,    -1,   103,    -1,   104,    77,
     103,    -1,   104,    78,   103,    -1,   104,    -1,   105,    18,
     104,    -1,   105,    19,   104,    -1,   105,    -1,   106,    83,
     105,    -1,   106,    84,   105,    -1,   106,    24,   105,    -1,
     106,    25,   105,    -1,   106,    -1,   107,    22,   106,    -1,
     107,    23,   106,    -1,   107,    -1,   108,    75,   107,    -1,
     108,    -1,   109,    85,   108,    -1,   109,    -1,   110,    86,
     109,    -1,   110,    -1,   111,    26,   110,    -1,   111,    -1,
     112,    27,   111,    -1,   112,    -1,   112,    87,   116,    88,
     113,    -1,   113,    -1,   100,   115,   114,    -1,    89,    -1,
      12,    -1,    13,    -1,    14,    -1,    10,    -1,    11,    -1,
      20,    -1,    21,    -1,    16,    -1,    15,    -1,    17,    -1,
     114,    -1,   116,    74,   114,    -1,    43,   116,    -1,   113,
      -1,   119,   120,    90,    -1,   119,    90,    -1,   122,   119,
      -1,   122,    -1,   123,   119,    -1,   123,    -1,   136,   119,
      -1,   136,    -1,   137,   119,    -1,   137,    -1,   121,    -1,
     120,    74,   121,    -1,   138,    -1,   138,    89,   149,    -1,
      61,    -1,    44,    -1,    58,    -1,    31,    -1,    52,    -1,
      64,    -1,    35,    -1,    55,    -1,    50,    -1,    51,    -1,
      45,    -1,    40,    -1,    56,    -1,    63,    -1,    32,    -1,
     124,    -1,   131,    -1,   148,    -1,   125,    97,    91,   126,
      92,    -1,   125,    91,   126,    92,    -1,   125,    97,    -1,
      59,    -1,    62,    -1,   127,    -1,   126,   127,    -1,   128,
     129,    90,    -1,   123,   128,    -1,   123,    -1,   136,   128,
      -1,   136,    -1,   130,    -1,   129,    74,   130,    -1,    -1,
     138,    -1,    88,   117,    -1,   138,    88,   117,    -1,   132,
      97,    91,   133,    92,    -1,   132,    91,   133,    92,    -1,
     132,    97,    91,   133,    74,    92,    -1,   132,    91,   133,
      74,    92,    -1,   132,    97,    -1,    42,    -1,    -1,   134,
     135,    -1,   133,    74,   135,    -1,    96,    -1,    96,    89,
     117,    -1,    36,    -1,    53,    -1,    43,    -1,    65,    -1,
      49,    -1,   140,   139,    -1,   139,    -1,    96,    -1,    69,
     138,    70,    -1,   139,    71,   114,    72,    -1,   139,    71,
      72,    -1,   139,    69,   142,    70,    -1,   139,    69,   144,
      70,    -1,   139,    69,    70,    -1,    76,   141,    -1,    76,
      -1,    76,   141,   140,    -1,    76,   140,    -1,   136,    -1,
     141,   136,    -1,   143,    -1,   142,    74,   143,    -1,   119,
     138,    -1,   119,   146,    -1,   119,    -1,     9,    -1,    96,
      -1,   144,    74,    96,    -1,   128,    -1,   128,   146,    -1,
     140,    -1,   147,    -1,   140,   147,    -1,    69,   146,    70,
      -1,    71,    72,    -1,    71,   114,    72,    -1,   147,    71,
      72,    -1,   147,    71,   114,    72,    -1,    69,    70,    -1,
      69,   142,    70,    -1,   147,    69,    70,    -1,   147,    69,
     142,    70,    -1,     4,    -1,   114,    -1,    91,   150,    92,
      -1,    91,   150,    74,    92,    -1,   149,    -1,   150,    74,
     149,    -1,   152,    -1,   153,    -1,   156,    -1,   157,    -1,
     158,    -1,   159,    -1,    97,    88,   151,    -1,    34,   117,
      88,   151,    -1,    38,    88,   151,    -1,    91,    92,    -1,
      91,   154,    92,    -1,   155,    -1,   154,   155,    -1,   118,
      -1,   151,    -1,    90,    -1,   116,    90,    -1,    48,    69,
     116,    70,   151,    -1,    48,    69,   116,    70,   151,    41,
     151,    -1,    60,    69,   116,    70,   151,    -1,    66,    69,
     116,    70,   151,    -1,    39,   151,    66,    69,   116,    70,
      90,    -1,    46,    69,    90,    90,    70,   151,    -1,    46,
      69,   116,    90,    90,    70,   151,    -1,    46,    69,    90,
     116,    90,    70,   151,    -1,    46,    69,   116,    90,   116,
      90,    70,   151,    -1,    46,    69,    90,    90,   116,    70,
     151,    -1,    46,    69,   116,    90,    90,   116,    70,   151,
      -1,    46,    69,    90,   116,    90,   116,    70,   151,    -1,
      46,    69,   116,    90,   116,    90,   116,    70,   151,    -1,
      47,    97,    90,    -1,    37,    90,    -1,    33,    90,    -1,
      54,    90,    -1,    54,   116,    90,    -1,   161,    -1,   160,
     161,    -1,   162,    -1,   118,    -1,   168,    -1,   119,   138,
     163,   153,    -1,   119,   138,   153,    -1,   118,    -1,   163,
     118,    -1,    67,    -1,    68,    -1,   164,    69,   144,    70,
      -1,   165,   117,    -1,   166,    -1,   167,    -1,     1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   223,   223,   232,   244,   248,   255,   256,   264,   279,
     293,   300,   301,   305,   306,   310,   314,   318,   322,   326,
     330,   337,   338,   342,   343,   347,   351,   374,   378,   386,
     390,   394,   398,   402,   406,   413,   414,   422,   423,   429,
     437,   448,   449,   455,   464,   465,   477,   486,   487,   493,
     499,   505,   514,   515,   521,   530,   531,   540,   541,   550,
     551,   560,   561,   572,   573,   584,   585,   592,   593,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   610,
     614,   615,   616,   623,   629,   647,   654,   659,   664,   677,
     678,   683,   688,   693,   701,   705,   712,   713,   717,   721,
     725,   729,   733,   740,   744,   748,   752,   756,   760,   764,
     768,   772,   776,   780,   781,   782,   790,   809,   814,   822,
     827,   835,   836,   843,   863,   868,   869,   874,   882,   886,
     894,   897,   898,   902,   913,   920,   927,   934,   941,   948,
     957,   957,   966,   974,   982,   994,   998,  1002,  1006,  1013,
    1020,  1025,  1029,  1034,  1038,  1043,  1048,  1058,  1065,  1074,
    1079,  1083,  1088,  1095,  1096,  1103,  1107,  1114,  1119,  1124,
    1129,  1136,  1142,  1151,  1152,  1156,  1161,  1162,  1170,  1174,
    1179,  1184,  1189,  1194,  1200,  1210,  1216,  1229,  1236,  1237,
    1238,  1242,  1243,  1249,  1250,  1251,  1252,  1253,  1254,  1258,
    1259,  1260,  1264,  1265,  1269,  1270,  1274,  1275,  1279,  1280,
    1284,  1285,  1286,  1290,  1291,  1292,  1293,  1294,  1295,  1296,
    1297,  1298,  1299,  1303,  1304,  1305,  1306,  1307,  1313,  1314,
    1318,  1319,  1320,  1324,  1325,  1329,  1330,  1336,  1343,  1350,
    1354,  1365,  1366,  1367
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"identifier\"", "\"typedef-name\"",
  "INTEGER", "FLOATING", "CHARACTER", "STRING", "ELLIPSIS", "ADDEQ",
  "SUBEQ", "MULEQ", "DIVEQ", "MODEQ", "XOREQ", "ANDEQ", "OREQ", "SL", "SR",
  "SLEQ", "SREQ", "EQ", "NOTEQ", "LTEQ", "GTEQ", "ANDAND", "OROR",
  "PLUSPLUS", "MINUSMINUS", "ARROW", "AUTO", "BOOL", "BREAK", "CASE",
  "CHAR", "CONST", "CONTINUE", "DEFAULT", "DO", "DOUBLE", "ELSE", "ENUM",
  "EXTENSION", "EXTERN", "FLOAT", "FOR", "GOTO", "IF", "INLINE", "INT",
  "LONG", "REGISTER", "RESTRICT", "RETURN", "SHORT", "SIGNED", "SIZEOF",
  "STATIC", "STRUCT", "SWITCH", "TYPEDEF", "UNION", "UNSIGNED", "VOID",
  "VOLATILE", "WHILE", "FUNCTION_MACRO", "OBJECT_MACRO", "'('", "')'",
  "'['", "']'", "'.'", "','", "'&'", "'*'", "'+'", "'-'", "'~'", "'!'",
  "'/'", "'%'", "'<'", "'>'", "'^'", "'|'", "'?'", "':'", "'='", "';'",
  "'{'", "'}'", "$accept", "primary_expression", "strings", "identifier",
  "identifier_or_typedef_name", "postfix_expression",
  "argument_expression_list", "unary_expression", "unary_operator",
  "cast_expression", "multiplicative_expression", "additive_expression",
  "shift_expression", "relational_expression", "equality_expression",
  "and_expression", "exclusive_or_expression", "inclusive_or_expression",
  "logical_and_expression", "logical_or_expression",
  "conditional_expression", "assignment_expression", "assignment_operator",
  "expression", "constant_expression", "declaration",
  "declaration_specifiers", "init_declarator_list", "init_declarator",
  "storage_class_specifier", "type_specifier", "struct_or_union_specifier",
  "struct_or_union", "struct_declaration_list", "struct_declaration",
  "specifier_qualifier_list", "struct_declarator_list",
  "struct_declarator", "enum_specifier", "enum_keyword", "enumerator_list",
  "$@1", "enumerator", "type_qualifier", "function_specifier",
  "declarator", "direct_declarator", "pointer", "type_qualifier_list",
  "parameter_list", "parameter_declaration", "identifier_list",
  "type_name", "abstract_declarator", "direct_abstract_declarator",
  "typedef_name", "initializer", "initializer_list", "statement",
  "labeled_statement", "compound_statement", "block_item_list",
  "block_item", "expression_statement", "selection_statement",
  "iteration_statement", "jump_statement", "translation_unit",
  "external_declaration", "function_definition", "declaration_list",
  "function_macro", "object_macro", "function_macro_define",
  "object_macro_define", "macro", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    40,
      41,    91,    93,    46,    44,    38,    42,    43,    45,   126,
      33,    47,    37,    60,    62,    94,   124,    63,    58,    61,
      59,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    93,    94,    94,    94,    94,    94,    94,    95,    95,
      96,    97,    97,    98,    98,    98,    98,    98,    98,    98,
      98,    99,    99,   100,   100,   100,   100,   100,   100,   101,
     101,   101,   101,   101,   101,   102,   102,   103,   103,   103,
     103,   104,   104,   104,   105,   105,   105,   106,   106,   106,
     106,   106,   107,   107,   107,   108,   108,   109,   109,   110,
     110,   111,   111,   112,   112,   113,   113,   114,   114,   115,
     115,   115,   115,   115,   115,   115,   115,   115,   115,   115,
     116,   116,   116,   117,   118,   118,   119,   119,   119,   119,
     119,   119,   119,   119,   120,   120,   121,   121,   122,   122,
     122,   122,   122,   123,   123,   123,   123,   123,   123,   123,
     123,   123,   123,   123,   123,   123,   124,   124,   124,   125,
     125,   126,   126,   127,   128,   128,   128,   128,   129,   129,
     130,   130,   130,   130,   131,   131,   131,   131,   131,   132,
     134,   133,   133,   135,   135,   136,   136,   136,   136,   137,
     138,   138,   139,   139,   139,   139,   139,   139,   139,   140,
     140,   140,   140,   141,   141,   142,   142,   143,   143,   143,
     143,   144,   144,   145,   145,   146,   146,   146,   147,   147,
     147,   147,   147,   147,   147,   147,   147,   148,   149,   149,
     149,   150,   150,   151,   151,   151,   151,   151,   151,   152,
     152,   152,   153,   153,   154,   154,   155,   155,   156,   156,
     157,   157,   157,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   159,   159,   159,   159,   159,   160,   160,
     161,   161,   161,   162,   162,   163,   163,   164,   165,   166,
     167,   168,   168,   168
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     3,     1,     2,
       1,     1,     1,     1,     4,     4,     3,     3,     3,     2,
       2,     1,     3,     1,     2,     2,     2,     2,     4,     1,
       1,     1,     1,     1,     1,     1,     4,     1,     3,     3,
       3,     1,     3,     3,     1,     3,     3,     1,     3,     3,
       3,     3,     1,     3,     3,     1,     3,     1,     3,     1,
       3,     1,     3,     1,     3,     1,     5,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     2,     1,     3,     2,     2,     1,     2,     1,
       2,     1,     2,     1,     1,     3,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     4,     2,     1,
       1,     1,     2,     3,     2,     1,     2,     1,     1,     3,
       0,     1,     2,     3,     5,     4,     6,     5,     2,     1,
       0,     2,     3,     1,     3,     1,     1,     1,     1,     1,
       2,     1,     1,     3,     4,     3,     4,     4,     3,     2,
       1,     3,     2,     1,     2,     1,     3,     2,     2,     1,
       1,     1,     3,     1,     2,     1,     1,     2,     3,     2,
       3,     3,     4,     2,     3,     3,     4,     1,     1,     3,
       4,     1,     3,     1,     1,     1,     1,     1,     1,     3,
       4,     3,     2,     3,     1,     2,     1,     1,     1,     2,
       5,     7,     5,     5,     7,     6,     7,     7,     8,     7,
       8,     8,     9,     3,     2,     2,     2,     3,     1,     2,
       1,     1,     1,     4,     3,     1,     2,     1,     1,     4,
       2,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,   243,   187,   101,   112,   104,   145,   109,   139,   147,
      99,   108,   149,   106,   107,   102,   146,   105,   110,   100,
     119,    98,   120,   111,   103,   148,   237,   238,   231,     0,
      87,    89,   113,     0,   114,     0,    91,    93,   115,     0,
     228,   230,     0,     0,   241,   242,   232,    10,     0,   160,
      85,   152,     0,    94,    96,   151,     0,    86,    88,     0,
      11,   118,    12,   140,   138,    90,    92,     1,   229,     0,
       3,     5,     4,     8,     0,     0,     0,     0,    29,    30,
      31,    32,    33,    34,    13,     6,     2,    23,    35,     0,
      37,    41,    44,    47,    52,    55,    57,    59,    61,    63,
      65,    83,   240,     0,   163,   162,   159,     0,    84,     0,
       0,   235,     0,   234,     0,     0,     0,   150,   125,     0,
     121,   130,   127,     0,     0,     0,   140,   171,     0,     0,
      24,    25,     0,    27,   147,    35,    67,    80,     0,   173,
       0,     9,    19,    20,     0,     0,     0,     0,    26,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   153,   164,
     161,    95,    96,     0,   188,    97,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   208,   202,     2,
       0,     0,   206,   115,   207,   193,   194,     0,   204,   195,
     196,   197,   198,   236,   233,   170,   158,   169,     0,   165,
       0,   155,     0,   124,   117,   122,     0,     0,   128,   131,
     126,     0,     0,   135,   143,   141,     0,   239,     0,     0,
       0,    82,    73,    74,    70,    71,    72,    78,    77,    79,
      75,    76,    69,     0,     7,     0,     0,     0,   175,   174,
     176,     0,    18,    16,     0,    21,     0,    17,    38,    39,
      40,    42,    43,    45,    46,    50,    51,    48,    49,    53,
      54,    56,    58,    60,    62,    64,     0,   191,     0,   225,
       0,   224,     0,     0,     0,     0,     0,   226,     0,     0,
       0,     0,   209,   203,   205,     0,   167,   175,   168,   156,
       0,   157,   154,   132,   130,   123,     0,   116,   137,   142,
       0,     0,   134,   172,    28,    68,    81,   183,     0,     0,
     179,     0,   177,     0,     0,    36,    15,     0,    14,     0,
       0,   189,     0,   201,     0,     0,     0,   223,     0,   227,
       0,     0,   199,   166,   129,   133,   144,   136,   184,   178,
     180,   185,     0,   181,     0,    22,    66,   190,   192,   200,
       0,     0,     0,     0,     0,     0,     0,   186,   182,     0,
       0,     0,     0,     0,     0,   210,   212,   213,     0,   215,
       0,     0,     0,     0,     0,     0,     0,   214,   219,   217,
       0,   216,     0,     0,     0,   211,   221,   220,   218,     0,
     222
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    84,    85,    86,   190,    87,   254,   135,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     136,   137,   243,   191,   102,    28,   207,    52,    53,    30,
      31,    32,    33,   119,   120,   121,   217,   218,    34,    35,
     124,   125,   309,    36,    37,   103,    55,    56,   106,   318,
     209,   128,   140,   319,   250,    38,   175,   278,   194,   195,
     196,   197,   198,   199,   200,   201,   202,    39,    40,    41,
     114,    42,    43,    44,    45,    46
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -223
static const yytype_int16 yypact[] =
{
    1675,  -223,  -223,  -223,  -223,  -223,  -223,  -223,  -223,  -223,
    -223,  -223,  -223,  -223,  -223,  -223,  -223,  -223,  -223,  -223,
    -223,  -223,  -223,  -223,  -223,  -223,  -223,  -223,  -223,    15,
    1850,  1850,  -223,    25,  -223,    31,  1850,  1850,  -223,  1622,
    -223,  -223,   -39,  1358,  -223,  -223,  -223,  -223,    56,   221,
    -223,  -223,   -35,  -223,   802,   -17,    33,  -223,  -223,  1884,
    -223,   -58,  -223,  -223,   -46,  -223,  -223,  -223,  -223,    61,
    -223,  -223,  -223,  -223,  1423,  1423,  1436,  1046,  -223,  -223,
    -223,  -223,  -223,  -223,  -223,    48,  -223,   210,  -223,  1358,
    -223,    57,    53,   266,   161,   293,     1,   104,    20,   115,
      21,  -223,  -223,    30,  -223,  -223,   221,    56,  -223,   752,
     420,  -223,    15,  -223,   845,  1741,  1221,   -17,  1884,   671,
    -223,    66,  1884,  1884,   -51,    61,  -223,  -223,    95,  1248,
    -223,  -223,  1046,  -223,  1248,   419,  -223,  -223,   113,   -18,
      86,  -223,  -223,  -223,   204,  1301,  1248,   204,  -223,  1358,
    1358,  1358,  1358,  1358,  1358,  1358,  1358,  1358,  1358,  1358,
    1358,  1358,  1358,  1358,  1358,  1358,  1358,  1248,  -223,  -223,
    -223,  -223,   127,   752,  -223,  -223,   203,  1358,   208,   214,
     619,   235,   204,   241,   909,   243,   250,  -223,  -223,   237,
     238,   -11,  -223,   239,  -223,  -223,  -223,   498,  -223,  -223,
    -223,  -223,  -223,  -223,  -223,  -223,  -223,    28,   118,  -223,
     121,  -223,   257,  -223,  -223,  -223,  1358,    -8,  -223,   242,
    -223,   711,    17,  -223,   244,  -223,   -50,  -223,    61,  1248,
     262,   264,  -223,  -223,  -223,  -223,  -223,  -223,  -223,  -223,
    -223,  -223,  -223,  1358,  -223,  1358,  1549,  1328,   172,  -223,
     189,  1358,  -223,  -223,   124,  -223,   206,  -223,  -223,  -223,
    -223,    57,    57,    53,    53,   266,   266,   266,   266,   161,
     161,   293,     1,   104,    20,   115,    93,  -223,   -25,  -223,
     251,  -223,   619,   274,   925,   252,  1248,  -223,    60,  1248,
    1248,   619,  -223,  -223,  -223,  1486,  -223,    19,  -223,  -223,
    1815,  -223,  -223,  -223,    66,  -223,  1358,  -223,  -223,  -223,
    1358,    18,  -223,  -223,  -223,  -223,  -223,  -223,   132,   276,
    -223,   275,   189,  1778,  1344,  -223,  -223,  1358,  -223,  1358,
     563,  -223,   619,  -223,   279,   952,    62,  -223,   139,  -223,
     145,   176,  -223,  -223,  -223,  -223,  -223,  -223,  -223,  -223,
    -223,  -223,   182,  -223,   278,  -223,  -223,  -223,  -223,  -223,
    1248,  1111,    74,   968,   619,   619,   619,  -223,  -223,   185,
     619,   195,  1127,  1166,    89,   312,  -223,  -223,   268,  -223,
     619,   619,   197,   619,   220,  1205,   619,  -223,  -223,  -223,
     619,  -223,   619,   619,   222,  -223,  -223,  -223,  -223,   619,
    -223
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -223,  -223,  -223,   -29,   -20,  -223,  -223,    71,  -223,   -79,
     165,   166,   150,   163,   194,   205,   202,   209,   201,  -223,
     -34,     4,  -223,   -72,  -166,    -7,     7,  -223,   269,  -223,
      78,  -223,  -223,   256,  -102,   -45,  -223,    69,  -223,  -223,
     249,  -223,   255,    52,  -223,   -27,   -55,   -41,  -223,  -112,
      82,   270,   254,  -114,  -222,   -21,  -157,  -223,    23,  -223,
      14,  -223,   186,  -223,  -223,  -223,  -223,  -223,   345,  -223,
    -223,  -223,  -223,  -223,  -223,  -223
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -13
static const yytype_int16 yytable[] =
{
      51,   117,    54,   208,    60,   138,    60,    29,   105,   101,
     148,   280,    62,    61,    62,    64,   277,   215,    47,    51,
      47,    47,    47,   222,   311,   249,   322,    51,    47,     2,
      69,    47,   139,   123,    47,     2,    47,    57,    58,   107,
     127,   223,   312,    65,    66,   126,    29,   111,   166,   330,
     303,   246,   115,   247,   116,   108,   141,   138,    49,    47,
     138,   112,   231,   245,    47,   170,   304,   331,   113,    47,
     258,   259,   260,   213,   256,   322,   162,   220,    51,   292,
     172,   189,   305,    51,    48,   172,   127,   139,   295,   193,
     247,    49,    51,   298,   219,   276,   224,   295,   248,   247,
     168,   104,    48,   192,    49,    50,   164,   203,   167,   308,
     347,   122,   288,   174,    88,    60,    59,   112,    60,   215,
     212,   112,    63,    62,   252,    48,    62,   257,   204,   122,
     152,   153,    49,   149,   245,    48,   245,   118,   150,   151,
     345,   165,    49,   101,   346,   130,   131,   133,   245,   255,
     339,   189,   363,    60,   216,   118,   251,   231,   169,    62,
      88,    62,   285,   245,   372,   227,   297,   245,   189,   228,
     122,   122,   325,   358,   122,   122,   193,   174,    51,   385,
     296,   329,   101,   244,   122,   156,   157,   245,   299,   163,
     192,   301,   300,   224,   326,   228,   118,   118,   327,   313,
     118,   118,   348,   283,   112,   248,   300,    47,     2,   364,
     118,   352,   336,   245,   338,   365,   109,   340,   341,   245,
      88,    88,    88,    88,    88,    88,    88,    88,    88,    88,
      88,    88,    88,    88,    88,    88,    88,    88,   142,   143,
     144,   246,   117,   247,   158,   159,   366,   315,    88,   316,
     245,   321,   367,   189,   297,   378,   300,     6,   323,   245,
     324,    62,   189,   362,     9,   380,    51,   390,    51,   245,
      62,   245,   101,   122,    16,    51,   101,   219,   328,   145,
     245,   146,   224,   147,   154,   155,    25,    88,   369,   371,
     392,   374,   399,   279,   245,   356,   245,    49,   281,   118,
     382,   384,   282,   189,   284,   333,   265,   266,   267,   268,
     286,    62,   289,   394,   342,   160,   161,   261,   262,   290,
     263,   264,    88,   269,   270,   -11,   291,   -12,   354,   302,
     306,   355,   314,   310,   174,   189,   189,   189,   245,   332,
     334,   189,   337,    62,    62,    62,   349,   350,   360,    62,
     368,   189,   189,   386,   189,   359,   271,   189,   387,    62,
      62,   189,    62,   189,   189,    62,   273,   275,   272,    62,
     189,    62,    62,   344,   274,   226,   171,    88,    62,   221,
     225,    88,   343,   294,    68,   210,   230,   375,   376,   377,
       0,     0,     0,   379,     0,     0,     0,     0,     0,     0,
      88,     0,     0,   388,   389,     0,   391,     0,     0,   395,
       0,     0,     0,   396,     0,   397,   398,     0,     0,     0,
       0,     0,   400,    47,     2,    70,    71,    72,    73,   232,
     233,   234,   235,   236,   237,   238,   239,     0,     0,   240,
     241,     0,     0,     0,     0,     0,     0,     0,    74,    75,
       0,     3,     4,   176,   177,     5,     6,   178,   179,   180,
       7,     0,     8,   134,    10,    11,   181,   182,   183,    12,
      13,    14,    15,    16,   184,    17,    18,    76,    19,    20,
     185,    21,    22,    23,    24,    25,   186,     0,     0,    77,
       0,     0,     0,     0,     0,    78,    79,    80,    81,    82,
      83,    47,     2,    70,    71,    72,    73,     0,   242,     0,
     187,   110,   188,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    74,    75,     0,     3,
       4,   176,   177,     5,     6,   178,   179,   180,     7,     0,
       8,   134,    10,    11,   181,   182,   183,    12,    13,    14,
      15,    16,   184,    17,    18,    76,    19,    20,   185,    21,
      22,    23,    24,    25,   186,     0,    47,    77,    70,    71,
      72,    73,     0,    78,    79,    80,    81,    82,    83,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   110,
     293,    74,    75,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,     0,    47,     2,    70,    71,    72,    73,     0,     0,
       0,     0,    77,     0,     0,     0,     0,     0,    78,    79,
      80,    81,    82,    83,     0,     0,     0,    74,    75,     0,
       0,     0,   176,   177,   173,   357,   178,   179,   180,     0,
       0,     0,   229,     0,     0,   181,   182,   183,     0,     0,
       0,     0,     0,   184,     0,     2,    76,     0,     0,   185,
       0,     0,     0,     0,     0,   186,     0,     0,    77,     0,
       0,     0,     0,     0,    78,    79,    80,    81,    82,    83,
       0,     0,     0,     4,     0,     0,     5,     6,     0,   187,
     110,     7,     0,     8,     9,     2,    11,     0,     0,     0,
       0,    13,    14,     0,    16,     0,    17,    18,     0,     0,
      20,     0,     0,    22,    23,    24,    25,     0,     0,     0,
       0,     0,     0,     4,     0,     0,     5,     6,     0,     0,
       0,     7,     0,     8,     9,    47,    11,    70,    71,    72,
      73,    13,    14,   214,    16,     0,    17,    18,     0,     0,
      20,     0,     0,    22,    23,    24,    25,     0,     0,     0,
      74,    75,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   307,     0,     0,     2,     0,     0,    76,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    77,     0,     0,     0,     0,     0,    78,    79,    80,
      81,    82,    83,     3,     4,     0,     0,     5,     6,     0,
       0,     0,     7,   173,     8,     9,    10,    11,     0,     2,
       0,    12,    13,    14,    15,    16,     0,    17,    18,     0,
      19,    20,     0,    21,    22,    23,    24,    25,     0,     0,
       0,     0,     0,     0,     0,     0,     3,     4,     0,     0,
       5,     6,     0,     0,     0,     7,     0,     8,     9,    10,
      11,   109,     0,   110,    12,    13,    14,    15,    16,     0,
      17,    18,     0,    19,    20,     0,    21,    22,    23,    24,
      25,     0,    47,     0,    70,    71,    72,    73,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
      70,    71,    72,    73,     0,     0,   110,    74,    75,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   229,    74,    75,    47,     0,    70,    71,    72,
      73,     0,     0,     0,     0,     0,    76,     0,   229,     0,
       0,    47,     0,    70,    71,    72,    73,     0,    77,     0,
      74,    75,    76,     0,    78,    79,    80,    81,    82,    83,
       0,     0,     0,     0,    77,   229,    74,    75,     0,   287,
      78,    79,    80,    81,    82,    83,     0,     0,     0,    76,
       0,   229,     0,     0,     0,   335,     0,     0,     0,     0,
       0,    77,     0,     0,     0,    76,     0,    78,    79,    80,
      81,    82,    83,     0,     0,     0,     0,    77,     0,     0,
       0,     0,   361,    78,    79,    80,    81,    82,    83,    47,
       2,    70,    71,    72,    73,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    74,    75,     0,     0,     4,     0,
       0,     5,     6,     0,     0,     0,     7,     0,     8,   134,
       0,    11,     0,     0,     0,     0,    13,    14,     0,    16,
       0,    17,    18,    76,     0,    20,     0,     0,    22,    23,
      24,    25,     0,     0,    47,    77,    70,    71,    72,    73,
       0,    78,    79,    80,    81,    82,    83,     0,     0,     0,
      47,     0,    70,    71,    72,    73,     0,     0,     0,    74,
      75,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   229,    74,    75,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    47,
     229,    70,    71,    72,    73,     0,     0,     0,     0,     0,
      77,   370,     0,     0,    76,     0,    78,    79,    80,    81,
      82,    83,     0,     0,    74,    75,    77,   381,     0,     0,
       0,     0,    78,    79,    80,    81,    82,    83,    47,   229,
      70,    71,    72,    73,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    47,     0,    70,    71,    72,    73,
       0,     0,     0,    74,    75,    77,   383,     0,     0,     0,
       0,    78,    79,    80,    81,    82,    83,     0,   229,    74,
      75,    47,     0,    70,    71,    72,    73,     0,     0,     0,
       0,     0,    76,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    77,   393,    74,    75,    76,     0,
      78,    79,    80,    81,    82,    83,     0,     0,     0,     0,
      77,   229,     0,   211,     0,     0,    78,    79,    80,    81,
      82,    83,     0,     0,    47,    76,    70,    71,    72,    73,
       0,     0,     0,     0,     0,     0,     0,    77,     0,     0,
       0,     0,     0,    78,    79,    80,    81,    82,    83,    74,
      75,    47,     0,    70,    71,    72,    73,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,    70,
      71,    72,    73,     0,     0,     0,    74,    75,    76,     0,
       0,    47,     0,    70,    71,    72,    73,     0,     0,     0,
      77,   253,    74,    75,     0,     0,    78,    79,    80,    81,
      82,    83,     0,     0,     0,    76,    74,    75,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    77,     0,     0,
     320,    76,     0,    78,    79,    80,    81,    82,    83,     0,
       0,     0,     0,    77,     0,    76,   353,     0,     0,    78,
      79,    80,    81,    82,    83,     0,    47,    77,    70,    71,
      72,    73,     0,    78,    79,    80,    81,    82,    83,    47,
       0,    70,    71,    72,    73,     0,     0,     0,     0,     0,
       0,    74,    75,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    74,    75,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       2,     0,   129,    76,     0,   205,     0,     0,    78,    79,
      80,    81,    82,    83,     0,   132,     0,     0,     0,     0,
       0,    78,    79,    80,    81,    82,    83,     3,     4,     0,
       0,     5,     6,     0,     0,     0,     7,     0,     8,     9,
      10,    11,     0,     0,     0,    12,    13,    14,    15,    16,
       0,    17,    18,     0,    19,    20,     0,    21,    22,    23,
      24,    25,     0,     2,     0,   295,   317,   247,   205,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       3,     4,     0,     0,     5,     6,     0,     0,     0,     7,
       0,     8,     9,    10,    11,     0,     0,     0,    12,    13,
      14,    15,    16,     0,    17,    18,     0,    19,    20,     0,
      21,    22,    23,    24,    25,     0,     0,     0,   246,   317,
     247,     0,    67,     1,     0,    49,     2,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     3,     4,     0,     0,     5,     6,     0,
       0,     0,     7,     0,     8,     9,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,     1,    17,    18,     2,
      19,    20,     0,    21,    22,    23,    24,    25,     0,    26,
      27,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     3,     4,     0,     0,
       5,     6,     0,     0,     0,     7,     0,     8,     9,    10,
      11,     0,     0,     0,    12,    13,    14,    15,    16,     0,
      17,    18,     0,    19,    20,     0,    21,    22,    23,    24,
      25,     0,    26,    27,    47,     2,     0,     0,     0,     0,
     205,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     3,     4,     0,     0,     5,     6,     0,     0,
       0,     7,     2,     8,     9,    10,    11,   205,     0,     0,
      12,    13,    14,    15,    16,     0,    17,    18,     0,    19,
      20,     0,    21,    22,    23,    24,    25,     0,     0,     3,
       4,   206,     0,     5,     6,     0,     0,     0,     7,     2,
       8,     9,    10,    11,   205,     0,     0,    12,    13,    14,
      15,    16,     0,    17,    18,     0,    19,    20,     0,    21,
      22,    23,    24,    25,     0,     0,     3,     4,   351,     0,
       5,     6,     0,     0,     2,     7,     0,     8,     9,    10,
      11,     0,     0,     0,    12,    13,    14,    15,    16,     0,
      17,    18,     0,    19,    20,     0,    21,    22,    23,    24,
      25,     3,     4,     0,     0,     5,     6,     0,     2,     0,
       7,     0,     8,     9,    10,    11,     0,     0,     0,    12,
      13,    14,    15,    16,     0,    17,    18,     0,    19,    20,
       0,    21,    22,    23,    24,    25,     4,     0,     0,     5,
       6,     0,     0,     0,     7,     0,     8,     9,     0,    11,
       0,     0,     0,     0,    13,    14,     0,    16,     0,    17,
      18,     0,     0,    20,     0,     0,    22,    23,    24,    25
};

static const yytype_int16 yycheck[] =
{
      29,    56,    29,   115,    33,    77,    35,     0,    49,    43,
      89,   177,    33,    33,    35,    35,   173,   119,     3,    48,
       3,     3,     3,    74,    74,   139,   248,    56,     3,     4,
      69,     3,    77,    91,     3,     4,     3,    30,    31,    74,
      69,    92,    92,    36,    37,    91,    39,    54,    27,    74,
     216,    69,    69,    71,    71,    90,     8,   129,    76,     3,
     132,    54,   134,    74,     3,   106,    74,    92,    54,     3,
     149,   150,   151,   118,   146,   297,    75,   122,   107,    90,
     107,   110,    90,   112,    69,   112,   115,   132,    69,   110,
      71,    76,   121,   207,   121,   167,   125,    69,   139,    71,
      70,    49,    69,   110,    76,    90,    86,   114,    87,    92,
      92,    59,   184,   109,    43,   144,    91,   110,   147,   221,
     116,   114,    91,   144,   144,    69,   147,   147,   114,    77,
      77,    78,    76,    76,    74,    69,    74,    59,    81,    82,
     306,    26,    76,   177,   310,    74,    75,    76,    74,   145,
      90,   180,    90,   182,    88,    77,    70,   229,   106,   180,
      89,   182,   182,    74,    90,    70,   207,    74,   197,    74,
     118,   119,   251,   330,   122,   123,   197,   173,   207,    90,
     207,    88,   216,    70,   132,    24,    25,    74,    70,    85,
     197,    70,    74,   222,    70,    74,   118,   119,    74,   228,
     122,   123,    70,   180,   197,   246,    74,     3,     4,    70,
     132,   323,   284,    74,   286,    70,    89,   289,   290,    74,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,    28,    29,
      30,    69,   297,    71,    83,    84,    70,   243,   177,   245,
      74,   247,    70,   282,   295,    70,    74,    36,    69,    74,
      71,   282,   291,   335,    43,    70,   295,    70,   297,    74,
     291,    74,   306,   221,    53,   304,   310,   304,    72,    69,
      74,    71,   311,    73,    18,    19,    65,   216,   360,   361,
      70,   363,    70,    90,    74,   329,    74,    76,    90,   221,
     372,   373,    88,   332,    69,   282,   156,   157,   158,   159,
      69,   332,    69,   385,   291,    22,    23,   152,   153,    69,
     154,   155,   251,   160,   161,    88,    88,    88,   324,    72,
      88,   327,    70,    89,   330,   364,   365,   366,    74,    88,
      66,   370,    90,   364,   365,   366,    70,    72,    69,   370,
      72,   380,   381,    41,   383,   332,   162,   386,    90,   380,
     381,   390,   383,   392,   393,   386,   164,   166,   163,   390,
     399,   392,   393,   304,   165,   126,   107,   306,   399,   123,
     125,   310,   300,   197,    39,   115,   132,   364,   365,   366,
      -1,    -1,    -1,   370,    -1,    -1,    -1,    -1,    -1,    -1,
     329,    -1,    -1,   380,   381,    -1,   383,    -1,    -1,   386,
      -1,    -1,    -1,   390,    -1,   392,   393,    -1,    -1,    -1,
      -1,    -1,   399,     3,     4,     5,     6,     7,     8,    10,
      11,    12,    13,    14,    15,    16,    17,    -1,    -1,    20,
      21,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    29,
      -1,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    -1,    -1,    69,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,     3,     4,     5,     6,     7,     8,    -1,    89,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    28,    29,    -1,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    -1,     3,    69,     5,     6,
       7,     8,    -1,    75,    76,    77,    78,    79,    80,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,
      92,    28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      57,    -1,     3,     4,     5,     6,     7,     8,    -1,    -1,
      -1,    -1,    69,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    -1,    -1,    -1,    28,    29,    -1,
      -1,    -1,    33,    34,    91,    92,    37,    38,    39,    -1,
      -1,    -1,    43,    -1,    -1,    46,    47,    48,    -1,    -1,
      -1,    -1,    -1,    54,    -1,     4,    57,    -1,    -1,    60,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    -1,    69,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      -1,    -1,    -1,    32,    -1,    -1,    35,    36,    -1,    90,
      91,    40,    -1,    42,    43,     4,    45,    -1,    -1,    -1,
      -1,    50,    51,    -1,    53,    -1,    55,    56,    -1,    -1,
      59,    -1,    -1,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    32,    -1,    -1,    35,    36,    -1,    -1,
      -1,    40,    -1,    42,    43,     3,    45,     5,     6,     7,
       8,    50,    51,    92,    53,    -1,    55,    56,    -1,    -1,
      59,    -1,    -1,    62,    63,    64,    65,    -1,    -1,    -1,
      28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    92,    -1,    -1,     4,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    31,    32,    -1,    -1,    35,    36,    -1,
      -1,    -1,    40,    91,    42,    43,    44,    45,    -1,     4,
      -1,    49,    50,    51,    52,    53,    -1,    55,    56,    -1,
      58,    59,    -1,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    31,    32,    -1,    -1,
      35,    36,    -1,    -1,    -1,    40,    -1,    42,    43,    44,
      45,    89,    -1,    91,    49,    50,    51,    52,    53,    -1,
      55,    56,    -1,    58,    59,    -1,    61,    62,    63,    64,
      65,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    91,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    43,    28,    29,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    -1,    -1,    -1,    57,    -1,    43,    -1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    69,    -1,
      28,    29,    57,    -1,    75,    76,    77,    78,    79,    80,
      -1,    -1,    -1,    -1,    69,    43,    28,    29,    -1,    90,
      75,    76,    77,    78,    79,    80,    -1,    -1,    -1,    57,
      -1,    43,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,    69,    -1,    -1,    -1,    57,    -1,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    69,    -1,    -1,
      -1,    -1,    90,    75,    76,    77,    78,    79,    80,     3,
       4,     5,     6,     7,     8,    -1,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    28,    29,    -1,    -1,    32,    -1,
      -1,    35,    36,    -1,    -1,    -1,    40,    -1,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    50,    51,    -1,    53,
      -1,    55,    56,    57,    -1,    59,    -1,    -1,    62,    63,
      64,    65,    -1,    -1,     3,    69,     5,     6,     7,     8,
      -1,    75,    76,    77,    78,    79,    80,    -1,    -1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    -1,    28,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    43,    28,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    57,     3,
      43,     5,     6,     7,     8,    -1,    -1,    -1,    -1,    -1,
      69,    70,    -1,    -1,    57,    -1,    75,    76,    77,    78,
      79,    80,    -1,    -1,    28,    29,    69,    70,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,     3,    43,
       5,     6,     7,     8,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    -1,    28,    29,    69,    70,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    -1,    43,    28,
      29,     3,    -1,     5,     6,     7,     8,    -1,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    28,    29,    57,    -1,
      75,    76,    77,    78,    79,    80,    -1,    -1,    -1,    -1,
      69,    43,    -1,    72,    -1,    -1,    75,    76,    77,    78,
      79,    80,    -1,    -1,     3,    57,     5,     6,     7,     8,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    28,
      29,     3,    -1,     5,     6,     7,     8,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    -1,    28,    29,    57,    -1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    -1,
      69,    70,    28,    29,    -1,    -1,    75,    76,    77,    78,
      79,    80,    -1,    -1,    -1,    57,    28,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,
      72,    57,    -1,    75,    76,    77,    78,    79,    80,    -1,
      -1,    -1,    -1,    69,    -1,    57,    72,    -1,    -1,    75,
      76,    77,    78,    79,    80,    -1,     3,    69,     5,     6,
       7,     8,    -1,    75,    76,    77,    78,    79,    80,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    -1,    -1,    -1,
      -1,    28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    28,    29,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,    -1,    69,    57,    -1,     9,    -1,    -1,    75,    76,
      77,    78,    79,    80,    -1,    69,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    31,    32,    -1,
      -1,    35,    36,    -1,    -1,    -1,    40,    -1,    42,    43,
      44,    45,    -1,    -1,    -1,    49,    50,    51,    52,    53,
      -1,    55,    56,    -1,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,     4,    -1,    69,    70,    71,     9,    -1,
      -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      31,    32,    -1,    -1,    35,    36,    -1,    -1,    -1,    40,
      -1,    42,    43,    44,    45,    -1,    -1,    -1,    49,    50,
      51,    52,    53,    -1,    55,    56,    -1,    58,    59,    -1,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    69,    70,
      71,    -1,     0,     1,    -1,    76,     4,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    31,    32,    -1,    -1,    35,    36,    -1,
      -1,    -1,    40,    -1,    42,    43,    44,    45,    -1,    -1,
      -1,    49,    50,    51,    52,    53,     1,    55,    56,     4,
      58,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    31,    32,    -1,    -1,
      35,    36,    -1,    -1,    -1,    40,    -1,    42,    43,    44,
      45,    -1,    -1,    -1,    49,    50,    51,    52,    53,    -1,
      55,    56,    -1,    58,    59,    -1,    61,    62,    63,    64,
      65,    -1,    67,    68,     3,     4,    -1,    -1,    -1,    -1,
       9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    31,    32,    -1,    -1,    35,    36,    -1,    -1,
      -1,    40,     4,    42,    43,    44,    45,     9,    -1,    -1,
      49,    50,    51,    52,    53,    -1,    55,    56,    -1,    58,
      59,    -1,    61,    62,    63,    64,    65,    -1,    -1,    31,
      32,    70,    -1,    35,    36,    -1,    -1,    -1,    40,     4,
      42,    43,    44,    45,     9,    -1,    -1,    49,    50,    51,
      52,    53,    -1,    55,    56,    -1,    58,    59,    -1,    61,
      62,    63,    64,    65,    -1,    -1,    31,    32,    70,    -1,
      35,    36,    -1,    -1,     4,    40,    -1,    42,    43,    44,
      45,    -1,    -1,    -1,    49,    50,    51,    52,    53,    -1,
      55,    56,    -1,    58,    59,    -1,    61,    62,    63,    64,
      65,    31,    32,    -1,    -1,    35,    36,    -1,     4,    -1,
      40,    -1,    42,    43,    44,    45,    -1,    -1,    -1,    49,
      50,    51,    52,    53,    -1,    55,    56,    -1,    58,    59,
      -1,    61,    62,    63,    64,    65,    32,    -1,    -1,    35,
      36,    -1,    -1,    -1,    40,    -1,    42,    43,    -1,    45,
      -1,    -1,    -1,    -1,    50,    51,    -1,    53,    -1,    55,
      56,    -1,    -1,    59,    -1,    -1,    62,    63,    64,    65
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     4,    31,    32,    35,    36,    40,    42,    43,
      44,    45,    49,    50,    51,    52,    53,    55,    56,    58,
      59,    61,    62,    63,    64,    65,    67,    68,   118,   119,
     122,   123,   124,   125,   131,   132,   136,   137,   148,   160,
     161,   162,   164,   165,   166,   167,   168,     3,    69,    76,
      90,    96,   120,   121,   138,   139,   140,   119,   119,    91,
      96,    97,   148,    91,    97,   119,   119,     0,   161,    69,
       5,     6,     7,     8,    28,    29,    57,    69,    75,    76,
      77,    78,    79,    80,    94,    95,    96,    98,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   117,   138,   136,   140,   141,    74,    90,    89,
      91,   118,   119,   153,   163,    69,    71,   139,   123,   126,
     127,   128,   136,    91,   133,   134,    91,    96,   144,    69,
     100,   100,    69,   100,    43,   100,   113,   114,   116,   128,
     145,     8,    28,    29,    30,    69,    71,    73,   102,    76,
      81,    82,    77,    78,    18,    19,    24,    25,    83,    84,
      22,    23,    75,    85,    86,    26,    27,    87,    70,   136,
     140,   121,   138,    91,   114,   149,    33,    34,    37,    38,
      39,    46,    47,    48,    54,    60,    66,    90,    92,    96,
      97,   116,   118,   148,   151,   152,   153,   154,   155,   156,
     157,   158,   159,   118,   153,     9,    70,   119,   142,   143,
     144,    72,   114,   128,    92,   127,    88,   129,   130,   138,
     128,   126,    74,    92,    96,   135,   133,    70,    74,    43,
     145,   116,    10,    11,    12,    13,    14,    15,    16,    17,
      20,    21,    89,   115,    70,    74,    69,    71,   140,   146,
     147,    70,    97,    70,    99,   114,   116,    97,   102,   102,
     102,   103,   103,   104,   104,   105,   105,   105,   105,   106,
     106,   107,   108,   109,   110,   111,   116,   149,   150,    90,
     117,    90,    88,   151,    69,    97,    69,    90,   116,    69,
      69,    88,    90,    92,   155,    69,   138,   140,   146,    70,
      74,    70,    72,   117,    74,    90,    88,    92,    92,   135,
      89,    74,    92,    96,    70,   114,   114,    70,   142,   146,
      72,   114,   147,    69,    71,   102,    70,    74,    72,    88,
      74,    92,    88,   151,    66,    90,   116,    90,   116,    90,
     116,   116,   151,   143,   130,   117,   117,    92,    70,    70,
      72,    70,   142,    72,   114,   114,   113,    92,   149,   151,
      69,    90,   116,    90,    70,    70,    70,    70,    72,   116,
      70,   116,    90,    90,   116,   151,   151,   151,    70,   151,
      70,    70,   116,    70,   116,    90,    41,    90,   151,   151,
      70,   151,    70,    70,   116,   151,   151,   151,   151,    70,
     151
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (scanner, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex (scanner)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, scanner); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, scanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    GISourceScanner* scanner;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (scanner);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, scanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    GISourceScanner* scanner;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep, scanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule, GISourceScanner* scanner)
#else
static void
yy_reduce_print (yyvsp, yyrule, scanner)
    YYSTYPE *yyvsp;
    int yyrule;
    GISourceScanner* scanner;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       , scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule, scanner); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, GISourceScanner* scanner)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, scanner)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    GISourceScanner* scanner;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (scanner);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (GISourceScanner* scanner);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (GISourceScanner* scanner)
#else
int
yyparse (scanner)
    GISourceScanner* scanner;
#endif
#endif
{


    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1455 of yacc.c  */
#line 224 "scannerparser.y"
    {
		(yyval.symbol) = g_hash_table_lookup (const_table, (yyvsp[(1) - (1)].str));
		if ((yyval.symbol) == NULL) {
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		} else {
			(yyval.symbol) = gi_source_symbol_ref ((yyval.symbol));
		}
	  }
    break;

  case 3:

/* Line 1455 of yacc.c  */
#line 233 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if (g_str_has_prefix (yytext, "0x") && strlen (yytext) > 2) {
			(yyval.symbol)->const_int = g_ascii_strtoll (yytext + 2, NULL, 16);
		} else if (g_str_has_prefix (yytext, "0") && strlen (yytext) > 1) {
			(yyval.symbol)->const_int = g_ascii_strtoll (yytext + 1, NULL, 8);
		} else {
			(yyval.symbol)->const_int = g_ascii_strtoll (yytext, NULL, 10);
		}
	  }
    break;

  case 4:

/* Line 1455 of yacc.c  */
#line 245 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 5:

/* Line 1455 of yacc.c  */
#line 249 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_double_set = TRUE;
		(yyval.symbol)->const_double = 0.0;
        sscanf (yytext, "%lf", &((yyval.symbol)->const_double));
	  }
    break;

  case 7:

/* Line 1455 of yacc.c  */
#line 257 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (3)].symbol);
	  }
    break;

  case 8:

/* Line 1455 of yacc.c  */
#line 265 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		yytext[strlen (yytext) - 1] = '\0';
		(yyval.symbol)->const_string = parse_c_string_literal (yytext + 1);
                if (!g_utf8_validate ((yyval.symbol)->const_string, -1, NULL))
                  {
#if 0
                    g_warning ("Ignoring non-UTF-8 constant string \"%s\"", yytext + 1);
#endif
                    g_free((yyval.symbol)->const_string);
                    (yyval.symbol)->const_string = NULL;
                  }

	  }
    break;

  case 9:

/* Line 1455 of yacc.c  */
#line 280 "scannerparser.y"
    {
		char *strings, *string2;
		(yyval.symbol) = (yyvsp[(1) - (2)].symbol);
		yytext[strlen (yytext) - 1] = '\0';
		string2 = parse_c_string_literal (yytext + 1);
		strings = g_strconcat ((yyval.symbol)->const_string, string2, NULL);
		g_free ((yyval.symbol)->const_string);
		g_free (string2);
		(yyval.symbol)->const_string = strings;
	  }
    break;

  case 10:

/* Line 1455 of yacc.c  */
#line 294 "scannerparser.y"
    {
		(yyval.str) = g_strdup (yytext);
	  }
    break;

  case 14:

/* Line 1455 of yacc.c  */
#line 307 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 15:

/* Line 1455 of yacc.c  */
#line 311 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 16:

/* Line 1455 of yacc.c  */
#line 315 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 17:

/* Line 1455 of yacc.c  */
#line 319 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 18:

/* Line 1455 of yacc.c  */
#line 323 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 19:

/* Line 1455 of yacc.c  */
#line 327 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 20:

/* Line 1455 of yacc.c  */
#line 331 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 24:

/* Line 1455 of yacc.c  */
#line 344 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 25:

/* Line 1455 of yacc.c  */
#line 348 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 26:

/* Line 1455 of yacc.c  */
#line 352 "scannerparser.y"
    {
		switch ((yyvsp[(1) - (2)].unary_operator)) {
		case UNARY_PLUS:
			(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
			break;
		case UNARY_MINUS:
			(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
			(yyval.symbol)->const_int = -(yyvsp[(2) - (2)].symbol)->const_int;
			break;
		case UNARY_BITWISE_COMPLEMENT:
			(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
			(yyval.symbol)->const_int = ~(yyvsp[(2) - (2)].symbol)->const_int;
			break;
		case UNARY_LOGICAL_NEGATION:
			(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
			(yyval.symbol)->const_int = !gi_source_symbol_get_const_boolean ((yyvsp[(2) - (2)].symbol));
			break;
		default:
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
			break;
		}
	  }
    break;

  case 27:

/* Line 1455 of yacc.c  */
#line 375 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 28:

/* Line 1455 of yacc.c  */
#line 379 "scannerparser.y"
    {
		ctype_free ((yyvsp[(3) - (4)].ctype));
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 29:

/* Line 1455 of yacc.c  */
#line 387 "scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_ADDRESS_OF;
	  }
    break;

  case 30:

/* Line 1455 of yacc.c  */
#line 391 "scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_POINTER_INDIRECTION;
	  }
    break;

  case 31:

/* Line 1455 of yacc.c  */
#line 395 "scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_PLUS;
	  }
    break;

  case 32:

/* Line 1455 of yacc.c  */
#line 399 "scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_MINUS;
	  }
    break;

  case 33:

/* Line 1455 of yacc.c  */
#line 403 "scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_BITWISE_COMPLEMENT;
	  }
    break;

  case 34:

/* Line 1455 of yacc.c  */
#line 407 "scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_LOGICAL_NEGATION;
	  }
    break;

  case 36:

/* Line 1455 of yacc.c  */
#line 415 "scannerparser.y"
    {
		ctype_free ((yyvsp[(2) - (4)].ctype));
		(yyval.symbol) = (yyvsp[(4) - (4)].symbol);
	  }
    break;

  case 38:

/* Line 1455 of yacc.c  */
#line 424 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int * (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 39:

/* Line 1455 of yacc.c  */
#line 430 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[(3) - (3)].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int / (yyvsp[(3) - (3)].symbol)->const_int;
		}
	  }
    break;

  case 40:

/* Line 1455 of yacc.c  */
#line 438 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[(3) - (3)].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int % (yyvsp[(3) - (3)].symbol)->const_int;
		}
	  }
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 450 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int + (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 43:

/* Line 1455 of yacc.c  */
#line 456 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int - (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 466 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int << (yyvsp[(3) - (3)].symbol)->const_int;

		/* assume this is a bitfield/flags declaration
		 * if a left shift operator is sued in an enum value
                 * This mimics the glib-mkenum behavior.
		 */
		is_bitfield = TRUE;
	  }
    break;

  case 46:

/* Line 1455 of yacc.c  */
#line 478 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int >> (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 488 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int < (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 49:

/* Line 1455 of yacc.c  */
#line 494 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int > (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 50:

/* Line 1455 of yacc.c  */
#line 500 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int <= (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 506 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int >= (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 516 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int == (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 54:

/* Line 1455 of yacc.c  */
#line 522 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int != (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 532 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int & (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 58:

/* Line 1455 of yacc.c  */
#line 542 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int ^ (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 552 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int | (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 562 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[(1) - (3)].symbol)) &&
		  gi_source_symbol_get_const_boolean ((yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 574 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[(1) - (3)].symbol)) ||
		  gi_source_symbol_get_const_boolean ((yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 66:

/* Line 1455 of yacc.c  */
#line 586 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_get_const_boolean ((yyvsp[(1) - (5)].symbol)) ? (yyvsp[(3) - (5)].symbol) : (yyvsp[(5) - (5)].symbol);
	  }
    break;

  case 68:

/* Line 1455 of yacc.c  */
#line 594 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 82:

/* Line 1455 of yacc.c  */
#line 617 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 84:

/* Line 1455 of yacc.c  */
#line 630 "scannerparser.y"
    {
		GList *l;
		for (l = (yyvsp[(2) - (3)].list); l != NULL; l = l->next) {
			GISourceSymbol *sym = l->data;
			gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[(1) - (3)].ctype)));
			if ((yyvsp[(1) - (3)].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF) {
				sym->type = CSYMBOL_TYPE_TYPEDEF;
			} else if (sym->base_type->type == CTYPE_FUNCTION) {
				sym->type = CSYMBOL_TYPE_FUNCTION;
			} else {
				sym->type = CSYMBOL_TYPE_OBJECT;
			}
			gi_source_scanner_add_symbol (scanner, sym);
			gi_source_symbol_unref (sym);
		}
		ctype_free ((yyvsp[(1) - (3)].ctype));
	  }
    break;

  case 85:

/* Line 1455 of yacc.c  */
#line 648 "scannerparser.y"
    {
		ctype_free ((yyvsp[(1) - (2)].ctype));
	  }
    break;

  case 86:

/* Line 1455 of yacc.c  */
#line 655 "scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(2) - (2)].ctype);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[(1) - (2)].storage_class_specifier);
	  }
    break;

  case 87:

/* Line 1455 of yacc.c  */
#line 660 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[(1) - (1)].storage_class_specifier);
	  }
    break;

  case 88:

/* Line 1455 of yacc.c  */
#line 665 "scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(1) - (2)].ctype);
		/* combine basic types like unsigned int and long long */
		if ((yyval.ctype)->type == CTYPE_BASIC_TYPE && (yyvsp[(2) - (2)].ctype)->type == CTYPE_BASIC_TYPE) {
			char *name = g_strdup_printf ("%s %s", (yyval.ctype)->name, (yyvsp[(2) - (2)].ctype)->name);
			g_free ((yyval.ctype)->name);
			(yyval.ctype)->name = name;
			ctype_free ((yyvsp[(2) - (2)].ctype));
		} else {
			(yyval.ctype)->base_type = (yyvsp[(2) - (2)].ctype);
		}
	  }
    break;

  case 90:

/* Line 1455 of yacc.c  */
#line 679 "scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(2) - (2)].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[(1) - (2)].type_qualifier);
	  }
    break;

  case 91:

/* Line 1455 of yacc.c  */
#line 684 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[(1) - (1)].type_qualifier);
	  }
    break;

  case 92:

/* Line 1455 of yacc.c  */
#line 689 "scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(2) - (2)].ctype);
		(yyval.ctype)->function_specifier |= (yyvsp[(1) - (2)].function_specifier);
	  }
    break;

  case 93:

/* Line 1455 of yacc.c  */
#line 694 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->function_specifier |= (yyvsp[(1) - (1)].function_specifier);
	  }
    break;

  case 94:

/* Line 1455 of yacc.c  */
#line 702 "scannerparser.y"
    {
		(yyval.list) = g_list_append (NULL, (yyvsp[(1) - (1)].symbol));
	  }
    break;

  case 95:

/* Line 1455 of yacc.c  */
#line 706 "scannerparser.y"
    {
		(yyval.list) = g_list_append ((yyvsp[(1) - (3)].list), (yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 98:

/* Line 1455 of yacc.c  */
#line 718 "scannerparser.y"
    {
		(yyval.storage_class_specifier) = STORAGE_CLASS_TYPEDEF;
	  }
    break;

  case 99:

/* Line 1455 of yacc.c  */
#line 722 "scannerparser.y"
    {
		(yyval.storage_class_specifier) = STORAGE_CLASS_EXTERN;
	  }
    break;

  case 100:

/* Line 1455 of yacc.c  */
#line 726 "scannerparser.y"
    {
		(yyval.storage_class_specifier) = STORAGE_CLASS_STATIC;
	  }
    break;

  case 101:

/* Line 1455 of yacc.c  */
#line 730 "scannerparser.y"
    {
		(yyval.storage_class_specifier) = STORAGE_CLASS_AUTO;
	  }
    break;

  case 102:

/* Line 1455 of yacc.c  */
#line 734 "scannerparser.y"
    {
		(yyval.storage_class_specifier) = STORAGE_CLASS_REGISTER;
	  }
    break;

  case 103:

/* Line 1455 of yacc.c  */
#line 741 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_type_new (CTYPE_VOID);
	  }
    break;

  case 104:

/* Line 1455 of yacc.c  */
#line 745 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("char");
	  }
    break;

  case 105:

/* Line 1455 of yacc.c  */
#line 749 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("short");
	  }
    break;

  case 106:

/* Line 1455 of yacc.c  */
#line 753 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("int");
	  }
    break;

  case 107:

/* Line 1455 of yacc.c  */
#line 757 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("long");
	  }
    break;

  case 108:

/* Line 1455 of yacc.c  */
#line 761 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("float");
	  }
    break;

  case 109:

/* Line 1455 of yacc.c  */
#line 765 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("double");
	  }
    break;

  case 110:

/* Line 1455 of yacc.c  */
#line 769 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("signed");
	  }
    break;

  case 111:

/* Line 1455 of yacc.c  */
#line 773 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("unsigned");
	  }
    break;

  case 112:

/* Line 1455 of yacc.c  */
#line 777 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("bool");
	  }
    break;

  case 115:

/* Line 1455 of yacc.c  */
#line 783 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_typedef_new ((yyvsp[(1) - (1)].str));
		g_free ((yyvsp[(1) - (1)].str));
	  }
    break;

  case 116:

/* Line 1455 of yacc.c  */
#line 791 "scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(1) - (5)].ctype);
		(yyval.ctype)->name = (yyvsp[(2) - (5)].str);
		(yyval.ctype)->child_list = (yyvsp[(4) - (5)].list);

		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		if ((yyval.ctype)->type == CTYPE_STRUCT) {
			sym->type = CSYMBOL_TYPE_STRUCT;
		} else if ((yyval.ctype)->type == CTYPE_UNION) {
			sym->type = CSYMBOL_TYPE_UNION;
		} else {
			g_assert_not_reached ();
		}
		sym->ident = g_strdup ((yyval.ctype)->name);
		sym->base_type = gi_source_type_copy ((yyval.ctype));
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	  }
    break;

  case 117:

/* Line 1455 of yacc.c  */
#line 810 "scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(1) - (4)].ctype);
		(yyval.ctype)->child_list = (yyvsp[(3) - (4)].list);
	  }
    break;

  case 118:

/* Line 1455 of yacc.c  */
#line 815 "scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(1) - (2)].ctype);
		(yyval.ctype)->name = (yyvsp[(2) - (2)].str);
	  }
    break;

  case 119:

/* Line 1455 of yacc.c  */
#line 823 "scannerparser.y"
    {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_struct_new (NULL);
	  }
    break;

  case 120:

/* Line 1455 of yacc.c  */
#line 828 "scannerparser.y"
    {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_union_new (NULL);
	  }
    break;

  case 122:

/* Line 1455 of yacc.c  */
#line 837 "scannerparser.y"
    {
		(yyval.list) = g_list_concat ((yyvsp[(1) - (2)].list), (yyvsp[(2) - (2)].list));
	  }
    break;

  case 123:

/* Line 1455 of yacc.c  */
#line 844 "scannerparser.y"
    {
	    GList *l;
	    (yyval.list) = NULL;
	    for (l = (yyvsp[(2) - (3)].list); l != NULL; l = l->next)
	      {
		GISourceSymbol *sym = l->data;
		if ((yyvsp[(1) - (3)].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF)
		    sym->type = CSYMBOL_TYPE_TYPEDEF;
		else
		    sym->type = CSYMBOL_TYPE_MEMBER;
		gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[(1) - (3)].ctype)));
                sym->private = scanner->private;
                (yyval.list) = g_list_append ((yyval.list), sym);
	      }
	    ctype_free ((yyvsp[(1) - (3)].ctype));
	  }
    break;

  case 124:

/* Line 1455 of yacc.c  */
#line 864 "scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(1) - (2)].ctype);
		(yyval.ctype)->base_type = (yyvsp[(2) - (2)].ctype);
	  }
    break;

  case 126:

/* Line 1455 of yacc.c  */
#line 870 "scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(2) - (2)].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[(1) - (2)].type_qualifier);
	  }
    break;

  case 127:

/* Line 1455 of yacc.c  */
#line 875 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[(1) - (1)].type_qualifier);
	  }
    break;

  case 128:

/* Line 1455 of yacc.c  */
#line 883 "scannerparser.y"
    {
		(yyval.list) = g_list_append (NULL, (yyvsp[(1) - (1)].symbol));
	  }
    break;

  case 129:

/* Line 1455 of yacc.c  */
#line 887 "scannerparser.y"
    {
		(yyval.list) = g_list_append ((yyvsp[(1) - (3)].list), (yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 130:

/* Line 1455 of yacc.c  */
#line 894 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 132:

/* Line 1455 of yacc.c  */
#line 899 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
	  }
    break;

  case 133:

/* Line 1455 of yacc.c  */
#line 903 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(1) - (3)].symbol);
		if ((yyvsp[(3) - (3)].symbol)->const_int_set) {
		  (yyval.symbol)->const_int_set = TRUE;
		  (yyval.symbol)->const_int = (yyvsp[(3) - (3)].symbol)->const_int;
		}
	  }
    break;

  case 134:

/* Line 1455 of yacc.c  */
#line 914 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[(2) - (5)].str));
		(yyval.ctype)->child_list = (yyvsp[(4) - (5)].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
    break;

  case 135:

/* Line 1455 of yacc.c  */
#line 921 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[(3) - (4)].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
    break;

  case 136:

/* Line 1455 of yacc.c  */
#line 928 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[(2) - (6)].str));
		(yyval.ctype)->child_list = (yyvsp[(4) - (6)].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
    break;

  case 137:

/* Line 1455 of yacc.c  */
#line 935 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[(3) - (5)].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
    break;

  case 138:

/* Line 1455 of yacc.c  */
#line 942 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[(2) - (2)].str));
	  }
    break;

  case 139:

/* Line 1455 of yacc.c  */
#line 949 "scannerparser.y"
    {
                scanner->flags = FALSE;
                scanner->private = FALSE;
          }
    break;

  case 140:

/* Line 1455 of yacc.c  */
#line 957 "scannerparser.y"
    {
		/* reset flag before the first enum value */
		is_bitfield = FALSE;
	  }
    break;

  case 141:

/* Line 1455 of yacc.c  */
#line 962 "scannerparser.y"
    {
            (yyvsp[(2) - (2)].symbol)->private = scanner->private;
            (yyval.list) = g_list_append (NULL, (yyvsp[(2) - (2)].symbol));
	  }
    break;

  case 142:

/* Line 1455 of yacc.c  */
#line 967 "scannerparser.y"
    {
            (yyvsp[(3) - (3)].symbol)->private = scanner->private;
            (yyval.list) = g_list_append ((yyvsp[(1) - (3)].list), (yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 143:

/* Line 1455 of yacc.c  */
#line 975 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, lineno);
		(yyval.symbol)->ident = (yyvsp[(1) - (1)].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = ++last_enum_value;
		g_hash_table_insert (const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
    break;

  case 144:

/* Line 1455 of yacc.c  */
#line 983 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, lineno);
		(yyval.symbol)->ident = (yyvsp[(1) - (3)].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(3) - (3)].symbol)->const_int;
		last_enum_value = (yyval.symbol)->const_int;
		g_hash_table_insert (const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
    break;

  case 145:

/* Line 1455 of yacc.c  */
#line 995 "scannerparser.y"
    {
		(yyval.type_qualifier) = TYPE_QUALIFIER_CONST;
	  }
    break;

  case 146:

/* Line 1455 of yacc.c  */
#line 999 "scannerparser.y"
    {
		(yyval.type_qualifier) = TYPE_QUALIFIER_RESTRICT;
	  }
    break;

  case 147:

/* Line 1455 of yacc.c  */
#line 1003 "scannerparser.y"
    {
		(yyval.type_qualifier) = TYPE_QUALIFIER_EXTENSION;
	  }
    break;

  case 148:

/* Line 1455 of yacc.c  */
#line 1007 "scannerparser.y"
    {
		(yyval.type_qualifier) = TYPE_QUALIFIER_VOLATILE;
	  }
    break;

  case 149:

/* Line 1455 of yacc.c  */
#line 1014 "scannerparser.y"
    {
		(yyval.function_specifier) = FUNCTION_INLINE;
	  }
    break;

  case 150:

/* Line 1455 of yacc.c  */
#line 1021 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[(1) - (2)].ctype));
	  }
    break;

  case 152:

/* Line 1455 of yacc.c  */
#line 1030 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		(yyval.symbol)->ident = (yyvsp[(1) - (1)].str);
	  }
    break;

  case 153:

/* Line 1455 of yacc.c  */
#line 1035 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (3)].symbol);
	  }
    break;

  case 154:

/* Line 1455 of yacc.c  */
#line 1039 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(1) - (4)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[(3) - (4)].symbol)));
	  }
    break;

  case 155:

/* Line 1455 of yacc.c  */
#line 1044 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(1) - (3)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
    break;

  case 156:

/* Line 1455 of yacc.c  */
#line 1049 "scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[(3) - (4)].list) != NULL && ((yyvsp[(3) - (4)].list)->next != NULL || ((GISourceSymbol *) (yyvsp[(3) - (4)].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[(3) - (4)].list);
		}
		(yyval.symbol) = (yyvsp[(1) - (4)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 157:

/* Line 1455 of yacc.c  */
#line 1059 "scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		func->child_list = (yyvsp[(3) - (4)].list);
		(yyval.symbol) = (yyvsp[(1) - (4)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 158:

/* Line 1455 of yacc.c  */
#line 1066 "scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[(1) - (3)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 159:

/* Line 1455 of yacc.c  */
#line 1075 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_pointer_new (NULL);
		(yyval.ctype)->type_qualifier = (yyvsp[(2) - (2)].type_qualifier);
	  }
    break;

  case 160:

/* Line 1455 of yacc.c  */
#line 1080 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_pointer_new (NULL);
	  }
    break;

  case 161:

/* Line 1455 of yacc.c  */
#line 1084 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_pointer_new ((yyvsp[(3) - (3)].ctype));
		(yyval.ctype)->type_qualifier = (yyvsp[(2) - (3)].type_qualifier);
	  }
    break;

  case 162:

/* Line 1455 of yacc.c  */
#line 1089 "scannerparser.y"
    {
		(yyval.ctype) = gi_source_pointer_new ((yyvsp[(2) - (2)].ctype));
	  }
    break;

  case 164:

/* Line 1455 of yacc.c  */
#line 1097 "scannerparser.y"
    {
		(yyval.type_qualifier) = (yyvsp[(1) - (2)].type_qualifier) | (yyvsp[(2) - (2)].type_qualifier);
	  }
    break;

  case 165:

/* Line 1455 of yacc.c  */
#line 1104 "scannerparser.y"
    {
		(yyval.list) = g_list_append (NULL, (yyvsp[(1) - (1)].symbol));
	  }
    break;

  case 166:

/* Line 1455 of yacc.c  */
#line 1108 "scannerparser.y"
    {
		(yyval.list) = g_list_append ((yyvsp[(1) - (3)].list), (yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 167:

/* Line 1455 of yacc.c  */
#line 1115 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[(1) - (2)].ctype));
	  }
    break;

  case 168:

/* Line 1455 of yacc.c  */
#line 1120 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[(1) - (2)].ctype));
	  }
    break;

  case 169:

/* Line 1455 of yacc.c  */
#line 1125 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		(yyval.symbol)->base_type = (yyvsp[(1) - (1)].ctype);
	  }
    break;

  case 170:

/* Line 1455 of yacc.c  */
#line 1130 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_ELLIPSIS, lineno);
	  }
    break;

  case 171:

/* Line 1455 of yacc.c  */
#line 1137 "scannerparser.y"
    {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		sym->ident = (yyvsp[(1) - (1)].str);
		(yyval.list) = g_list_append (NULL, sym);
	  }
    break;

  case 172:

/* Line 1455 of yacc.c  */
#line 1143 "scannerparser.y"
    {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		sym->ident = (yyvsp[(3) - (3)].str);
		(yyval.list) = g_list_append ((yyvsp[(1) - (3)].list), sym);
	  }
    break;

  case 175:

/* Line 1455 of yacc.c  */
#line 1157 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[(1) - (1)].ctype));
	  }
    break;

  case 177:

/* Line 1455 of yacc.c  */
#line 1163 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[(1) - (2)].ctype));
	  }
    break;

  case 178:

/* Line 1455 of yacc.c  */
#line 1171 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (3)].symbol);
	  }
    break;

  case 179:

/* Line 1455 of yacc.c  */
#line 1175 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
    break;

  case 180:

/* Line 1455 of yacc.c  */
#line 1180 "scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[(2) - (3)].symbol)));
	  }
    break;

  case 181:

/* Line 1455 of yacc.c  */
#line 1185 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(1) - (3)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
    break;

  case 182:

/* Line 1455 of yacc.c  */
#line 1190 "scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(1) - (4)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[(3) - (4)].symbol)));
	  }
    break;

  case 183:

/* Line 1455 of yacc.c  */
#line 1195 "scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 184:

/* Line 1455 of yacc.c  */
#line 1201 "scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[(2) - (3)].list) != NULL && ((yyvsp[(2) - (3)].list)->next != NULL || ((GISourceSymbol *) (yyvsp[(2) - (3)].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[(2) - (3)].list);
		}
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 185:

/* Line 1455 of yacc.c  */
#line 1211 "scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[(1) - (3)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 186:

/* Line 1455 of yacc.c  */
#line 1217 "scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[(3) - (4)].list) != NULL && ((yyvsp[(3) - (4)].list)->next != NULL || ((GISourceSymbol *) (yyvsp[(3) - (4)].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[(3) - (4)].list);
		}
		(yyval.symbol) = (yyvsp[(1) - (4)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 187:

/* Line 1455 of yacc.c  */
#line 1230 "scannerparser.y"
    {
		(yyval.str) = g_strdup (yytext);
	  }
    break;

  case 237:

/* Line 1455 of yacc.c  */
#line 1337 "scannerparser.y"
    {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
    break;

  case 238:

/* Line 1455 of yacc.c  */
#line 1344 "scannerparser.y"
    {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
    break;

  case 240:

/* Line 1455 of yacc.c  */
#line 1355 "scannerparser.y"
    {
		if ((yyvsp[(2) - (2)].symbol)->const_int_set || (yyvsp[(2) - (2)].symbol)->const_double_set || (yyvsp[(2) - (2)].symbol)->const_string != NULL) {
			(yyvsp[(2) - (2)].symbol)->ident = (yyvsp[(1) - (2)].str);
			gi_source_scanner_add_symbol (scanner, (yyvsp[(2) - (2)].symbol));
			gi_source_symbol_unref ((yyvsp[(2) - (2)].symbol));
		}
	  }
    break;



/* Line 1455 of yacc.c  */
#line 3830 "scannerparser.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (scanner, YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (scanner, yymsg);
	  }
	else
	  {
	    yyerror (scanner, YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, scanner);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval, scanner);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 1675 of yacc.c  */
#line 1370 "scannerparser.y"

static void
yyerror (GISourceScanner *scanner, const char *s)
{
  /* ignore errors while doing a macro scan as not all object macros
   * have valid expressions */
  if (!scanner->macro_scan)
    {
      fprintf(stderr, "%s:%d: %s in '%s' at '%s'\n",
	      scanner->current_filename, lineno, s, linebuf, yytext);
    }
}

static int
eat_hspace (FILE * f)
{
  int c;
  do
    {
      c = fgetc (f);
    }
  while (c == ' ' || c == '\t');
  return c;
}

static int
eat_line (FILE * f, int c)
{
  while (c != EOF && c != '\n')
    {
      c = fgetc (f);
    }
  if (c == '\n')
    {
      c = fgetc (f);
      if (c == ' ' || c == '\t')
        {
          c = eat_hspace (f);
        }
    }
  return c;
}

static int
read_identifier (FILE * f, int c, char **identifier)
{
  GString *id = g_string_new ("");
  while (g_ascii_isalnum (c) || c == '_')
    {
      g_string_append_c (id, c);
      c = fgetc (f);
    }
  *identifier = g_string_free (id, FALSE);
  return c;
}

void
gi_source_scanner_parse_macros (GISourceScanner *scanner, GList *filenames)
{
  GError *error = NULL;
  char *tmp_name = NULL;
  FILE *fmacros =
    fdopen (g_file_open_tmp ("gen-introspect-XXXXXX.h", &tmp_name, &error),
            "w+");
  g_unlink (tmp_name);

  GList *l;
  for (l = filenames; l != NULL; l = l->next)
    {
      FILE *f = fopen (l->data, "r");
      int line = 1;

      GString *define_line;
      char *str;
      gboolean error_line = FALSE;
      int c = eat_hspace (f);
      while (c != EOF)
        {
          if (c != '#')
            {
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }

          /* print current location */
          str = g_strescape (l->data, "");
          fprintf (fmacros, "# %d \"%s\"\n", line, str);
          g_free (str);

          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          if (strcmp (str, "define") != 0 || (c != ' ' && c != '\t'))
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          g_free (str);
          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          if (strlen (str) == 0 || (c != ' ' && c != '\t' && c != '('))
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          define_line = g_string_new ("#define ");
          g_string_append (define_line, str);
          g_free (str);
          if (c == '(')
            {
              while (c != ')')
                {
                  g_string_append_c (define_line, c);
                  c = fgetc (f);
                  if (c == EOF || c == '\n')
                    {
                      error_line = TRUE;
                      break;
                    }
                }
              if (error_line)
                {
                  g_string_free (define_line, TRUE);
                  /* ignore line */
                  c = eat_line (f, c);
                  line++;
                  continue;
                }

              g_assert (c == ')');
              g_string_append_c (define_line, c);
              c = fgetc (f);

              /* found function-like macro */
              fprintf (fmacros, "%s\n", define_line->str);

              g_string_free (define_line, TRUE);
              /* ignore rest of line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          if (c != ' ' && c != '\t')
            {
              g_string_free (define_line, TRUE);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          while (c != EOF && c != '\n')
            {
              g_string_append_c (define_line, c);
              c = fgetc (f);
              if (c == '\\')
                {
                  c = fgetc (f);
                  if (c == '\n')
                    {
                      /* fold lines when seeing backslash new-line sequence */
                      c = fgetc (f);
                    }
                  else
                    {
                      g_string_append_c (define_line, '\\');
                    }
                }
            }

          /* found object-like macro */
          fprintf (fmacros, "%s\n", define_line->str);

          c = eat_line (f, c);
          line++;
        }

      fclose (f);
    }

  rewind (fmacros);
  gi_source_scanner_parse_file (scanner, fmacros);
}

gboolean
gi_source_scanner_parse_file (GISourceScanner *scanner, FILE *file)
{
  g_return_val_if_fail (file != NULL, FALSE);

  const_table = g_hash_table_new_full (g_str_hash, g_str_equal,
				       g_free, (GDestroyNotify)gi_source_symbol_unref);

  lineno = 1;
  yyin = file;
  yyparse (scanner);

  g_hash_table_destroy (const_table);
  const_table = NULL;

  yyin = NULL;

  return TRUE;
}

gboolean
gi_source_scanner_lex_filename (GISourceScanner *scanner, const gchar *filename)
{
  lineno = 1;
  yyin = fopen (filename, "r");

  while (yylex (scanner) != YYEOF)
    ;

  fclose (yyin);

  return TRUE;
}

