/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 249
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 60
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  Select* yy43;
  TriggerStep* yy75;
  struct LimitVal yy84;
  struct LikeOp yy86;
  Expr * yy158;
  Token yy178;
  struct {int value; int mask;} yy207;
  ExprList* yy242;
  int yy316;
  IdList* yy352;
  struct TrigEvent yy354;
  SrcList* yy419;
  Expr* yy450;
  int yy497;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 587
#define YYNRULE 311
#define YYERRORSYMBOL 139
#define YYERRSYMDT yy497
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   290,   68,  300,   70,  151,  169,  570,  420,   62,   62,
 /*    10 */    62,   62,  205,   64,   64,   64,   64,   65,   65,   66,
 /*    20 */    66,   66,   67,  477,  569,  568,  433,  439,   69,   64,
 /*    30 */    64,   64,   64,   65,   65,   66,   66,   66,   67,   65,
 /*    40 */    65,   66,   66,   66,   67,   61,   59,  296,  443,  444,
 /*    50 */   440,  440,   63,   63,   62,   62,   62,   62,  582,   64,
 /*    60 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  290,
 /*    70 */   570,  387,  420,  149,    2,   80,  161,  115,  240,  341,
 /*    80 */   245,  342,  173,  249,  298,    1,  566,  207,  569,  393,
 /*    90 */   250,  522,  899,  121,  586,  433,  439,    2,  583,   58,
 /*   100 */   577,   21,   64,   64,   64,   64,   65,   65,   66,   66,
 /*   110 */    66,   67,  290,  473,   61,   59,  296,  443,  444,  440,
 /*   120 */   440,   63,   63,   62,   62,   62,   62,  393,   64,   64,
 /*   130 */    64,   64,   65,   65,   66,   66,   66,   67,  433,  439,
 /*   140 */    92,  178,   67,  473,  343,  346,  347,  388,  385,   56,
 /*   150 */   379,  207,  236,  407,  394,  395,  348,   61,   59,  296,
 /*   160 */   443,  444,  440,  440,   63,   63,   62,   62,   62,   62,
 /*   170 */   171,   64,   64,   64,   64,   65,   65,   66,   66,   66,
 /*   180 */    67,  290,  479,  428,  208,  522,  110,  490,  452,  432,
 /*   190 */   406,  223,  394,  395,  532,   21,  408,  318,  517,   68,
 /*   200 */   453,   70,  151,  567,  412,  150,  487,  433,  439,  146,
 /*   210 */   147,  584,  890,  454,  890,  494,  172,  157,  488,  411,
 /*   220 */    28,  337,  415,  261,  290,  495,   61,   59,  296,  443,
 /*   230 */   444,  440,  440,   63,   63,   62,   62,   62,   62,  412,
 /*   240 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*   250 */   433,  439,  581,  314,  389,  417,  417,  417,  549,  204,
 /*   260 */    68,  460,   70,  151,  262,  261,  197,  290,  339,   61,
 /*   270 */    59,  296,  443,  444,  440,  440,   63,   63,   62,   62,
 /*   280 */    62,   62,  318,   64,   64,   64,   64,   65,   65,   66,
 /*   290 */    66,   66,   67,  433,  439,  410,  548,  393,  284,  409,
 /*   300 */   412,  430,  521,  165,  411,   41,  381,  473,  432,  295,
 /*   310 */   423,  424,   61,   59,  296,  443,  444,  440,  440,   63,
 /*   320 */    63,   62,   62,   62,   62,  376,   64,   64,   64,   64,
 /*   330 */    65,   65,   66,   66,   66,   67,  477,  488,  300,  290,
 /*   340 */    76,  415,  205,  483,  332,  234,  238,  370,  267,  266,
 /*   350 */   489,   68,  384,   70,  151,  369,  393,  383,  205,  434,
 /*   360 */   435,  367,  394,  395,  178,  433,  439,  343,  346,  347,
 /*   370 */   529,  504,  572,  207,  417,  417,  417,  528,  169,  348,
 /*   380 */   420,  437,  438,   79,   61,   59,  296,  443,  444,  440,
 /*   390 */   440,   63,   63,   62,   62,   62,   62,  358,   64,   64,
 /*   400 */    64,   64,   65,   65,   66,   66,   66,   67,  290,  436,
 /*   410 */   428,  208,  486,  115,  240,  341,  245,  342,  173,  249,
 /*   420 */   318,  394,  395,  530,  318,  393,  250,  217,  318,  509,
 /*   430 */   405,  520,  152,  224,  433,  439,  321,  423,  424,  517,
 /*   440 */   492,  493,  411,   35,  231,  420,  411,   35,  469,  510,
 /*   450 */   411,   35,  477,   61,   59,  296,  443,  444,  440,  440,
 /*   460 */    63,   63,   62,   62,   62,   62,  412,   64,   64,   64,
 /*   470 */    64,   65,   65,   66,   66,   66,   67,  290,  522,  178,
 /*   480 */   351,  503,  343,  346,  347,  299,  318,  404,   21,  297,
 /*   490 */   394,  395,  318,  334,  348,  482,  318,  457,  318,  393,
 /*   500 */   207,  457,  302,  433,  439,  457,   22,  174,  411,   36,
 /*   510 */   420,  148,  531,  308,  411,   35,  523,  470,  411,   41,
 /*   520 */   411,   49,   61,   59,  296,  443,  444,  440,  440,   63,
 /*   530 */    63,   62,   62,   62,   62,  318,   64,   64,   64,   64,
 /*   540 */    65,   65,   66,   66,   66,   67,  290,  447,  338,  452,
 /*   550 */   253,   66,   66,   66,   67,  428,  448,  411,   49,  232,
 /*   560 */   230,  453,   10,  292,  394,  395,  393,  309,  250,  456,
 /*   570 */   411,    3,  433,  439,  454,  420,  328,   20,  543,  141,
 /*   580 */   584,  889,  324,  889,  446,  446,  393,  430,  322,  165,
 /*   590 */   393,   61,   59,  296,  443,  444,  440,  440,   63,   63,
 /*   600 */    62,   62,   62,   62,  310,   64,   64,   64,   64,   65,
 /*   610 */    65,   66,   66,   66,   67,  290,  371,  318,  271,  541,
 /*   620 */    91,  581,  293,  540,  466,  318,  206,  318,  587,  388,
 /*   630 */   385,  394,  395,   55,  324,  359,  446,  446,  329,  411,
 /*   640 */    29,  433,  439,  324,  481,  446,  446,  411,   24,  411,
 /*   650 */    33,  394,  395,  515,  545,  394,  395,  274,  290,  272,
 /*   660 */    61,   59,  296,  443,  444,  440,  440,   63,   63,   62,
 /*   670 */    62,   62,   62,  318,   64,   64,   64,   64,   65,   65,
 /*   680 */    66,   66,   66,   67,  433,  439,  546,  493,  303,  396,
 /*   690 */   397,  398,  580,  289,  823,  411,   54,  360,  515,  515,
 /*   700 */   189,  290,  363,   61,   59,  296,  443,  444,  440,  440,
 /*   710 */    63,   63,   62,   62,   62,   62,  144,   64,   64,   64,
 /*   720 */    64,   65,   65,   66,   66,   66,   67,  433,  439,  539,
 /*   730 */   357,  539,  248,  216,  412,  468,  168,  157,  273,  515,
 /*   740 */   515,  515,  312,  120,  290,  198,   61,   71,  296,  443,
 /*   750 */   444,  440,  440,   63,   63,   62,   62,   62,   62,  368,
 /*   760 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*   770 */   433,  439,  426,  426,  304,  305,  307,  248,  247,  412,
 /*   780 */   324,  364,  446,  446,  175,  176,  177,  290,  261,  261,
 /*   790 */    59,  296,  443,  444,  440,  440,   63,   63,   62,   62,
 /*   800 */    62,   62,  155,   64,   64,   64,   64,   65,   65,   66,
 /*   810 */    66,   66,   67,  433,  439,  462,  156,  125,  248,  248,
 /*   820 */   248,  420,  463,  367,  261,  255,  335,  193,  468,  556,
 /*   830 */   558,   75,  162,   77,  296,  443,  444,  440,  440,   63,
 /*   840 */    63,   62,   62,   62,   62,  318,   64,   64,   64,   64,
 /*   850 */    65,   65,   66,   66,   66,   67,   72,  325,  318,    4,
 /*   860 */   318,  412,  318,  294,  259,  559,  257,  411,   25,  318,
 /*   870 */   219,  320,   72,  325,  318,    4,  153,  235,  180,  294,
 /*   880 */   411,   52,  411,   97,  411,   94,  420,  320,  327,  218,
 /*   890 */   410,  411,   99,  501,  409,  318,  411,  100,  319,  432,
 /*   900 */   318,  261,  318,  174,  327,  392,  191,  183,  318,  116,
 /*   910 */   412,  318,  412,  416,  261,  432,  318,  411,  111,   74,
 /*   920 */    73,  429,  411,  112,  411,   17,  621,   72,  316,  317,
 /*   930 */   411,   98,  415,  411,   34,   74,   73,  480,  411,   95,
 /*   940 */   318,  412,  560,   72,  316,  317,   72,  325,  415,    4,
 /*   950 */   318,  205,  318,  294,  318,  275,    5,  318,  261,  292,
 /*   960 */   323,  320,  411,   53,  330,  417,  417,  417,  418,  419,
 /*   970 */    12,  378,  411,  113,  411,  114,  411,   26,  327,  411,
 /*   980 */    37,  417,  417,  417,  418,  419,   12,  508,  507,  432,
 /*   990 */   159,  205,  318,  458,  261,  220,  221,  222,  102,  375,
 /*  1000 */   421,  318,   23,  318,  377,  318,   82,  318,  506,   74,
 /*  1010 */    73,  202,  467,  279,  411,   38,  472,   72,  316,  317,
 /*  1020 */   280,  318,  415,  411,   27,  411,   39,  411,   40,  411,
 /*  1030 */    42,  318,  200,  476,  548,  277,  441,  246,  505,  199,
 /*  1040 */   318,  511,  201,  411,   43,  318,  512,  455,  318,   13,
 /*  1050 */   475,  318,  170,  411,   44,  417,  417,  417,  418,  419,
 /*  1060 */    12,  524,  411,   30,  498,  499,  318,  411,   31,   19,
 /*  1070 */   411,   45,  318,  411,   46,  484,  318,   13,  241,  318,
 /*  1080 */   513,  318,  125,  318,  254,  374,  276,  266,  411,   47,
 /*  1090 */   242,  291,  537,  538,  411,   48,  205,  256,  411,   32,
 /*  1100 */   258,  411,   11,  411,   50,  411,   51,  252,  350,  125,
 /*  1110 */   125,  544,  552,  125,  170,  553,  563,   89,   89,    9,
 /*  1120 */   380,  260,  579,  265,  288,  355,  186,  362,  402,  365,
 /*  1130 */   366,  268,  269,  143,  225,  270,  555,  565,  278,  281,
 /*  1140 */   282,  576,  425,  326,  427,  461,  504,  465,  551,  243,
 /*  1150 */   514,  562,  160,  391,  399,  400,  401,    8,  315,  413,
 /*  1160 */    82,  226,  333,  227,   81,  331,   57,  516,  228,  345,
 /*  1170 */    78,  209,  167,  459,  233,  210,  407,  464,  122,   83,
 /*  1180 */   336,  340,  211,  491,  496,  301,  244,  501,  103,  500,
 /*  1190 */   497,  502,  285,  518,  229,  525,  414,  286,  519,  352,
 /*  1200 */   526,  527,  533,  237,  181,  474,  239,  354,  478,  185,
 /*  1210 */   182,  356,  214,  184,   86,  535,  215,  187,  118,  361,
 /*  1220 */   547,  190,  129,  372,  373,  130,  554,  311,  131,  561,
 /*  1230 */   132,  573,  135,   96,  133,  578,  390,  139,  574,  575,
 /*  1240 */   263,  403,  138,  213,  101,  622,  623,  163,   60,  536,
 /*  1250 */   164,  422,  431,  442,  449,  445,  140,  154,  166,  450,
 /*  1260 */   451,    6,   90,   14,   13,  471,    7,  123,  158,  124,
 /*  1270 */   485,   93,  212,   84,  344,  104,  117,  251,  105,   85,
 /*  1280 */   106,  179,  242,  353,  142,   18,  534,  126,  306,  349,
 /*  1290 */   170,  127,  109,  264,  188,  107,  542,  287,  550,  128,
 /*  1300 */   192,   15,   87,   88,  194,  195,  557,  119,  196,  136,
 /*  1310 */   137,  134,   16,  564,  571,  108,  313,  203,  145,  283,
 /*  1320 */   382,  386,  900,  585,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  218,   16,  220,  221,   21,  148,   23,   70,   71,
 /*    10 */    72,   73,  111,   75,   76,   77,   78,   79,   80,   81,
 /*    20 */    82,   83,   84,  148,  166,  167,   42,   43,   74,   75,
 /*    30 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   79,
 /*    40 */    80,   81,   82,   83,   84,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,   73,   20,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   148,  142,   88,   22,  145,   22,   90,   91,   92,   93,
 /*    80 */    94,   95,   96,   97,  209,   19,  228,  229,  166,   23,
 /*    90 */   104,  148,  140,  141,  142,   42,   43,  145,   60,   46,
 /*   100 */   157,  158,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   110 */    83,   84,   16,  162,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,   73,   23,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,   90,   84,  162,   93,   94,   95,    1,    2,   19,
 /*   150 */   228,  229,  201,   23,   88,   89,  105,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   170 */   156,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,  201,   79,   80,  148,   21,  161,   12,   59,
 /*   190 */   169,  154,   88,   89,  157,  158,  170,  148,  177,  218,
 /*   200 */    24,  220,  221,   99,  190,  156,  170,   42,   43,   79,
 /*   210 */    80,   19,   20,   37,   22,   39,  202,  203,   88,  170,
 /*   220 */   171,  207,   92,  148,   16,   49,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  190,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,   60,  143,  144,  125,  126,  127,   11,  149,
 /*   260 */   218,  219,  220,  221,  189,  148,  156,   16,   81,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   73,  148,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,  108,   49,   23,  159,  112,
 /*   300 */   190,  162,  163,  164,  170,  171,  189,  162,   59,  165,
 /*   310 */   166,  167,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,   73,  215,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,  148,   88,   16,   16,
 /*   340 */   132,   92,  111,   20,  210,  211,  201,  100,  101,  102,
 /*   350 */   170,  218,  242,  220,  221,  124,   23,  240,  111,   42,
 /*   360 */    43,  148,   88,   89,   90,   42,   43,   93,   94,   95,
 /*   370 */   177,  178,  239,  229,  125,  126,  127,  184,   21,  105,
 /*   380 */    23,   64,   65,  132,   61,   62,   63,   64,   65,   66,
 /*   390 */    67,   68,   69,   70,   71,   72,   73,  209,   75,   76,
 /*   400 */    77,   78,   79,   80,   81,   82,   83,   84,   16,   92,
 /*   410 */    79,   80,   20,   91,   92,   93,   94,   95,   96,   97,
 /*   420 */   148,   88,   89,  182,  148,   23,  104,  214,  148,   30,
 /*   430 */   168,  169,  156,  191,   42,   43,  165,  166,  167,  177,
 /*   440 */   186,  187,  170,  171,  148,   88,  170,  171,  115,   50,
 /*   450 */   170,  171,  148,   61,   62,   63,   64,   65,   66,   67,
 /*   460 */    68,   69,   70,   71,   72,   73,  190,   75,   76,   77,
 /*   470 */    78,   79,   80,   81,   82,   83,   84,   16,  148,   90,
 /*   480 */    16,   20,   93,   94,   95,  213,  148,  157,  158,  213,
 /*   490 */    88,   89,  148,  213,  105,   20,  148,  225,  148,   23,
 /*   500 */   229,  225,  103,   42,   43,  225,   19,   43,  170,  171,
 /*   510 */    23,  181,  182,  209,  170,  171,  182,  115,  170,  171,
 /*   520 */   170,  171,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   530 */    69,   70,   71,   72,   73,  148,   75,   76,   77,   78,
 /*   540 */    79,   80,   81,   82,   83,   84,   16,   20,  148,   12,
 /*   550 */    20,   81,   82,   83,   84,   79,   20,  170,  171,  211,
 /*   560 */   222,   24,   19,   99,   88,   89,   23,  217,  104,  225,
 /*   570 */   170,  171,   42,   43,   37,   88,   39,   19,   18,   21,
 /*   580 */    19,   20,  107,   22,  109,  110,   23,  162,  163,  164,
 /*   590 */    23,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   600 */    70,   71,   72,   73,  217,   75,   76,   77,   78,   79,
 /*   610 */    80,   81,   82,   83,   84,   16,   56,  148,   14,   25,
 /*   620 */    21,   60,  151,   29,   22,  148,  193,  148,    0,    1,
 /*   630 */     2,   88,   89,  200,  107,   41,  109,  110,  187,  170,
 /*   640 */   171,   42,   43,  107,   81,  109,  110,  170,  171,  170,
 /*   650 */   171,   88,   89,  148,   94,   88,   89,   53,   16,   55,
 /*   660 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   670 */    71,   72,   73,  148,   75,   76,   77,   78,   79,   80,
 /*   680 */    81,   82,   83,   84,   42,   43,  186,  187,  183,    7,
 /*   690 */     8,    9,  245,  246,  134,  170,  171,  226,  148,  148,
 /*   700 */   156,   16,  231,   61,   62,   63,   64,   65,   66,   67,
 /*   710 */    68,   69,   70,   71,   72,   73,  114,   75,   76,   77,
 /*   720 */    78,   79,   80,   81,   82,   83,   84,   42,   43,  100,
 /*   730 */   101,  102,  227,  183,  190,   22,  202,  203,  134,  148,
 /*   740 */   148,  148,  243,  244,   16,  156,   61,   62,   63,   64,
 /*   750 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  215,
 /*   760 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   770 */    42,   43,  125,  126,  183,  183,  183,  227,  227,  190,
 /*   780 */   107,  237,  109,  110,  100,  101,  102,   16,  148,  148,
 /*   790 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   800 */    72,   73,   89,   75,   76,   77,   78,   79,   80,   81,
 /*   810 */    82,   83,   84,   42,   43,   27,  148,   22,  227,  227,
 /*   820 */   227,   23,   34,  148,  148,   14,  148,  156,  115,  189,
 /*   830 */   189,  131,   19,  133,   63,   64,   65,   66,   67,   68,
 /*   840 */    69,   70,   71,   72,   73,  148,   75,   76,   77,   78,
 /*   850 */    79,   80,   81,   82,   83,   84,   16,   17,  148,   19,
 /*   860 */   148,  190,  148,   23,   53,  189,   55,  170,  171,  148,
 /*   870 */   146,   31,   16,   17,  148,   19,  156,  148,  156,   23,
 /*   880 */   170,  171,  170,  171,  170,  171,   88,   31,   48,  214,
 /*   890 */   108,  170,  171,   98,  112,  148,  170,  171,  148,   59,
 /*   900 */   148,  148,  148,   43,   48,  148,   22,  156,  148,  148,
 /*   910 */   190,  148,  190,  148,  148,   59,  148,  170,  171,   79,
 /*   920 */    80,  162,  170,  171,  170,  171,  113,   87,   88,   89,
 /*   930 */   170,  171,   92,  170,  171,   79,   80,   81,  170,  171,
 /*   940 */   148,  190,  189,   87,   88,   89,   16,   17,   92,   19,
 /*   950 */   148,  111,  148,   23,  148,  189,  192,  148,  148,   99,
 /*   960 */    16,   31,  170,  171,  148,  125,  126,  127,  128,  129,
 /*   970 */   130,   91,  170,  171,  170,  171,  170,  171,   48,  170,
 /*   980 */   171,  125,  126,  127,  128,  129,  130,   91,   92,   59,
 /*   990 */     5,  111,  148,  148,  148,   10,   11,   12,   13,  189,
 /*  1000 */    20,  148,   22,  148,  124,  148,  122,  148,  179,   79,
 /*  1010 */    80,   26,  204,   28,  170,  171,  148,   87,   88,   89,
 /*  1020 */    35,  148,   92,  170,  171,  170,  171,  170,  171,  170,
 /*  1030 */   171,  148,   47,  148,   49,  189,   92,  148,  148,   54,
 /*  1040 */   148,  179,   57,  170,  171,  148,  179,   20,  148,   22,
 /*  1050 */    20,  148,   22,  170,  171,  125,  126,  127,  128,  129,
 /*  1060 */   130,  148,  170,  171,    7,    8,  148,  170,  171,   19,
 /*  1070 */   170,  171,  148,  170,  171,   20,  148,   22,   92,  148,
 /*  1080 */    20,  148,   22,  148,  148,  100,  101,  102,  170,  171,
 /*  1090 */   104,  106,   51,   52,  170,  171,  111,  148,  170,  171,
 /*  1100 */   148,  170,  171,  170,  171,  170,  171,   20,   20,   22,
 /*  1110 */    22,   20,   20,   22,   22,   20,   20,   22,   22,   69,
 /*  1120 */   135,  148,   20,  148,   22,  234,  233,  148,  150,  148,
 /*  1130 */   148,  148,  148,  192,  194,  148,  148,  148,  148,  148,
 /*  1140 */   148,  148,  230,  224,  230,  173,  178,  173,  195,  173,
 /*  1150 */   173,  195,    6,  147,  147,  147,  147,   22,  155,  190,
 /*  1160 */   122,  195,  119,  196,  120,  117,  121,  173,  197,  174,
 /*  1170 */   131,  223,  113,  153,   97,  212,   23,  161,  153,   99,
 /*  1180 */   116,   99,  212,  172,  172,   40,  172,   98,   19,  174,
 /*  1190 */   180,  172,  175,  161,  198,  172,  199,  175,  180,   15,
 /*  1200 */   172,  172,  153,  205,  152,  206,  205,  153,  206,  153,
 /*  1210 */   152,   38,  212,  152,  131,  153,  212,  152,   61,  153,
 /*  1220 */   185,  185,   19,  153,   15,  188,  195,  153,  188,  195,
 /*  1230 */   188,   33,  185,  160,  188,  138,    1,  216,  153,  153,
 /*  1240 */   235,   20,  216,  176,  176,  113,  113,  113,   19,  236,
 /*  1250 */   113,   20,   20,   92,   11,  108,   19,   19,   22,   20,
 /*  1260 */    20,  118,  238,   22,   22,  115,  118,   19,  113,   20,
 /*  1270 */    20,  238,   44,   19,   44,   19,   32,   20,   19,   19,
 /*  1280 */    19,   96,  104,   16,   21,  232,   17,   99,   36,   44,
 /*  1290 */    22,   45,  241,  134,   99,   19,   45,    5,    1,  103,
 /*  1300 */   123,   19,   69,   69,  114,   14,   17,  244,  116,  103,
 /*  1310 */   123,  114,   19,  124,   20,   14,  247,  136,   19,  137,
 /*  1320 */    58,    3,  248,    4,
};
#define YY_SHIFT_USE_DFLT (-100)
#define YY_SHIFT_MAX 386
static const short yy_shift_ofst[] = {
 /*     0 */   146,  840,  985,  -16,  840,  930,  930,  930,  274,  104,
 /*    10 */   -99,   96,  930,  930,  930,  930,  930,  -46,  247,  476,
 /*    20 */   567,  798,  331,  331,   53,  165,  208,  251,  323,  392,
 /*    30 */   461,  530,  599,  642,  685,  642,  642,  642,  642,  642,
 /*    40 */   642,  642,  642,  642,  642,  642,  642,  642,  642,  642,
 /*    50 */   642,  642,  728,  771,  771,  856,  930,  930,  930,  930,
 /*    60 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    70 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    80 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    90 */   930,  930,  930,  930,  -62,  -62,  -14,   27,   27,  -40,
 /*   100 */   470,  464,  560,  567,  567,  567,  567,  567,  567,  567,
 /*   110 */   798,   58, -100, -100, -100,  130,  322,  176,  176,  192,
 /*   120 */   561,  628,  357,  567,  357,  567,  567,  567,  567,  567,
 /*   130 */   567,  567,  567,  567,  567,  567,  567,  567,  880,  231,
 /*   140 */   -99,  -99,  -99, -100, -100, -100,  249,  249,   51,  389,
 /*   150 */   475,   66,  527,  536,  537,  333,  402,  543,  563,  682,
 /*   160 */   567,  567,  187,  567,  567,  487,  567,  567,  713,  567,
 /*   170 */   567,  673,  713,  567,  567,  399,  399,  399,  567,  567,
 /*   180 */   673,  567,  567,  673,  567,  594,  629,  567,  567,  673,
 /*   190 */   567,  567,  567,  673,  567,  567,  567,  673,  673,  567,
 /*   200 */   567,  567,  567,  567,  558,  782,  602,  647,  647,  700,
 /*   210 */   788,  788,  788,  860,  788,  788,  795,  884,  884, 1146,
 /*   220 */  1146, 1146, 1146, 1135,  -99, 1038, 1043, 1044, 1048, 1045,
 /*   230 */  1039, 1059, 1077, 1153, 1077, 1059, 1080, 1064, 1080, 1064,
 /*   240 */  1082, 1082, 1145, 1082, 1089, 1082, 1169, 1077, 1077, 1153,
 /*   250 */  1145, 1082, 1082, 1082, 1169, 1184, 1059, 1184, 1059, 1184,
 /*   260 */  1059, 1059, 1173, 1083, 1184, 1059, 1157, 1157, 1203, 1038,
 /*   270 */  1059, 1209, 1209, 1209, 1209, 1038, 1157, 1203, 1059, 1198,
 /*   280 */  1198, 1059, 1059, 1097, -100, -100, -100, -100, -100, -100,
 /*   290 */   317,  604,  684,  811,  813,  980,  944, 1027, 1030, 1055,
 /*   300 */   986, 1057,  896, 1060, 1087, 1088, 1041, 1091, 1092, 1095,
 /*   310 */  1096, 1050, 1102,   38, 1235, 1221, 1132, 1133, 1134, 1137,
 /*   320 */  1229, 1231, 1232, 1161, 1147, 1237, 1243, 1238, 1239, 1236,
 /*   330 */  1240, 1143, 1241, 1148, 1242, 1150, 1248, 1249, 1155, 1250,
 /*   340 */  1244, 1228, 1254, 1230, 1256, 1257, 1259, 1260, 1245, 1261,
 /*   350 */  1185, 1178, 1267, 1269, 1263, 1188, 1252, 1246, 1268, 1251,
 /*   360 */  1159, 1195, 1276, 1292, 1297, 1196, 1233, 1234, 1177, 1282,
 /*   370 */  1190, 1291, 1192, 1289, 1197, 1206, 1187, 1293, 1189, 1294,
 /*   380 */  1301, 1262, 1181, 1182, 1299, 1318, 1319,
};
#define YY_REDUCE_USE_DFLT (-218)
#define YY_REDUCE_MAX 289
static const short yy_reduce_ofst[] = {
 /*     0 */   -48,  276,  110,  -19,   49,  272,  134,  280,  330, -142,
 /*    10 */    14,  133,  338,  344,  348,  350,  387,   42,  544,  -78,
 /*    20 */    37,  139,  144,  271, -217, -217, -217, -217, -217, -217,
 /*    30 */  -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
 /*    40 */  -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
 /*    50 */  -217, -217, -217, -217, -217,  400,  469,  477,  479,  525,
 /*    60 */   697,  710,  712,  714,  721,  726,  747,  752,  754,  760,
 /*    70 */   763,  768,  792,  802,  804,  806,  809,  844,  853,  855,
 /*    80 */   857,  859,  873,  883,  892,  897,  900,  903,  918,  924,
 /*    90 */   928,  931,  933,  935, -217, -217,  262, -217, -217, -217,
 /*   100 */  -217,  193,  471,  505,  550,  591,  592,  593,  117,  -57,
 /*   110 */   425, -217, -217, -217, -217,   26,   21,  254,  500,  447,
 /*   120 */   447,  -71,  -49, -125,  145,  551,   75,  188,  213,  304,
 /*   130 */   640,  641,  676,  753,  766,  810,  675,  846,  589,  671,
 /*   140 */   720,  722,  751,  433,  534,  499,   36,  180,  241,  334,
 /*   150 */   242,  296,  242,  242,  451,  668,  678,  729,  750,  724,
 /*   160 */   757,  761,  764,  750,  765,  759,  816,  845,  808,  868,
 /*   170 */   885,  242,  808,  889,  890,  829,  862,  867,  913,  936,
 /*   180 */   242,  949,  952,  242,  973,  893,  891,  975,  979,  242,
 /*   190 */   981,  982,  983,  242,  984,  987,  988,  242,  242,  989,
 /*   200 */   990,  991,  992,  993,  978,  941,  940,  912,  914,  919,
 /*   210 */   972,  974,  976,  968,  977,  994,  995,  953,  956, 1006,
 /*   220 */  1007, 1008, 1009, 1003,  969,  966,  967,  971,  996,  997,
 /*   230 */   948, 1020,  963, 1016,  970, 1025,  998,  999, 1001, 1002,
 /*   240 */  1011, 1012, 1010, 1014, 1015, 1019, 1017, 1000, 1004, 1032,
 /*   250 */  1018, 1023, 1028, 1029, 1022, 1052, 1049, 1058, 1054, 1061,
 /*   260 */  1056, 1062, 1005, 1013, 1065, 1066, 1035, 1036, 1021, 1031,
 /*   270 */  1070, 1037, 1040, 1042, 1046, 1034, 1047, 1026, 1074, 1024,
 /*   280 */  1033, 1085, 1086, 1051, 1073, 1067, 1068, 1053, 1063, 1069,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   593,  820,  898,  708,  898,  820,  898,  820,  898,  843,
 /*    10 */   712,  872,  816,  820,  898,  898,  898,  791,  898,  843,
 /*    20 */   898,  624,  843,  843,  743,  898,  898,  898,  898,  898,
 /*    30 */   898,  898,  898,  744,  898,  819,  815,  811,  813,  812,
 /*    40 */   745,  732,  741,  748,  724,  857,  750,  751,  757,  758,
 /*    50 */   873,  876,  779,  797,  778,  898,  898,  898,  898,  898,
 /*    60 */   898,  898,  898,  898,  898,  898,  898,  898,  898,  898,
 /*    70 */   898,  898,  898,  898,  898,  898,  898,  898,  898,  898,
 /*    80 */   898,  898,  898,  898,  898,  898,  898,  898,  898,  898,
 /*    90 */   898,  898,  898,  898,  781,  802,  617,  780,  790,  782,
 /*   100 */   783,  677,  612,  898,  898,  898,  898,  898,  898,  898,
 /*   110 */   898,  784,  785,  798,  799,  898,  898,  898,  898,  898,
 /*   120 */   898,  593,  708,  898,  708,  898,  898,  898,  898,  898,
 /*   130 */   898,  898,  898,  898,  898,  898,  898,  898,  898,  898,
 /*   140 */   898,  898,  898,  702,  712,  891,  898,  898,  668,  898,
 /*   150 */   898,  898,  898,  898,  898,  898,  898,  898,  898,  600,
 /*   160 */   598,  898,  700,  898,  898,  626,  898,  898,  710,  898,
 /*   170 */   898,  715,  716,  898,  898,  898,  898,  898,  898,  898,
 /*   180 */   614,  898,  898,  689,  898,  849,  898,  898,  898,  864,
 /*   190 */   898,  898,  898,  862,  898,  898,  898,  691,  753,  830,
 /*   200 */   898,  877,  879,  898,  898,  700,  709,  898,  898,  814,
 /*   210 */   735,  735,  735,  647,  735,  735,  650,  747,  747,  597,
 /*   220 */   597,  597,  597,  667,  898,  747,  738,  740,  728,  742,
 /*   230 */   898,  717,  736,  898,  736,  717,  725,  727,  725,  727,
 /*   240 */   679,  679,  664,  679,  650,  679,  824,  736,  736,  898,
 /*   250 */   664,  679,  679,  679,  824,  609,  717,  609,  717,  609,
 /*   260 */   717,  717,  853,  856,  609,  717,  681,  681,  759,  747,
 /*   270 */   717,  688,  688,  688,  688,  747,  681,  759,  717,  875,
 /*   280 */   875,  717,  717,  884,  634,  652,  652,  859,  891,  896,
 /*   290 */   898,  898,  898,  898,  766,  898,  898,  898,  898,  898,
 /*   300 */   898,  898,  898,  898,  898,  898,  898,  898,  898,  898,
 /*   310 */   898,  836,  898,  898,  898,  898,  771,  767,  898,  768,
 /*   320 */   898,  898,  898,  898,  694,  898,  898,  898,  898,  898,
 /*   330 */   898,  898,  729,  898,  739,  898,  898,  898,  898,  898,
 /*   340 */   898,  898,  898,  898,  898,  898,  898,  898,  898,  898,
 /*   350 */   898,  898,  898,  898,  898,  898,  898,  851,  852,  898,
 /*   360 */   898,  898,  898,  898,  898,  898,  898,  898,  898,  898,
 /*   370 */   898,  898,  898,  898,  898,  898,  898,  898,  898,  898,
 /*   380 */   898,  883,  898,  898,  886,  594,  898,  588,  591,  590,
 /*   390 */   592,  596,  599,  621,  622,  623,  601,  602,  603,  604,
 /*   400 */   605,  606,  607,  613,  615,  633,  635,  619,  637,  698,
 /*   410 */   699,  763,  692,  693,  697,  765,  769,  770,  772,  773,
 /*   420 */   620,  627,  628,  631,  632,  839,  841,  840,  842,  630,
 /*   430 */   629,  774,  777,  786,  787,  789,  795,  801,  804,  788,
 /*   440 */   793,  794,  796,  800,  803,  695,  696,  807,  809,  810,
 /*   450 */   865,  866,  867,  868,  869,  805,  817,  818,  718,  808,
 /*   460 */   792,  730,  733,  734,  737,  731,  701,  711,  720,  721,
 /*   470 */   722,  723,  706,  707,  713,  726,  761,  762,  714,  703,
 /*   480 */   704,  705,  806,  764,  775,  776,  638,  639,  771,  640,
 /*   490 */   641,  642,  680,  683,  684,  685,  643,  662,  665,  666,
 /*   500 */   644,  651,  645,  646,  653,  654,  655,  658,  659,  660,
 /*   510 */   661,  656,  657,  825,  826,  828,  827,  648,  649,  663,
 /*   520 */   636,  625,  618,  669,  672,  673,  674,  675,  676,  678,
 /*   530 */   670,  671,  616,  608,  610,  719,  845,  854,  855,  850,
 /*   540 */   846,  847,  848,  611,  821,  822,  682,  755,  756,  844,
 /*   550 */   858,  860,  760,  861,  863,  888,  686,  687,  690,  829,
 /*   560 */   870,  746,  749,  752,  754,  831,  832,  833,  834,  837,
 /*   570 */   838,  835,  871,  874,  878,  880,  881,  882,  885,  887,
 /*   580 */   892,  893,  894,  897,  895,  595,  589,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "VIRTUAL",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "ANY",           "OR",            "AND",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "COLLATE",       "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "TO",            "ADD",           "COLUMNKW",      "error",       
  "input",         "cmdlist",       "ecmd",          "cmdx",        
  "cmd",           "explain",       "transtype",     "trans_opt",   
  "nm",            "create_table",  "create_table_args",  "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "on_opt",        "using_opt",     "seltablist_paren",
  "joinop2",       "inscollist",    "sortlist",      "sortitem",    
  "collate",       "exprlist",      "setlist",       "insert_cmd",  
  "inscollist_opt",  "itemlist",      "likeop",        "escape",      
  "between_op",    "in_op",         "case_operand",  "case_exprlist",
  "case_else",     "expritem",      "uniqueflag",    "idxitem",     
  "nmnum",         "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
  "add_column_fullname",  "kwcolumn_opt",  "create_vtab",   "vtabarglist", 
  "vtabarg",       "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 144 */ "sortlist ::= sortitem collate sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "collate ::=",
 /* 150 */ "collate ::= COLLATE id",
 /* 151 */ "groupby_opt ::=",
 /* 152 */ "groupby_opt ::= GROUP BY exprlist",
 /* 153 */ "having_opt ::=",
 /* 154 */ "having_opt ::= HAVING expr",
 /* 155 */ "limit_opt ::=",
 /* 156 */ "limit_opt ::= LIMIT expr",
 /* 157 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 158 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 159 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 160 */ "where_opt ::=",
 /* 161 */ "where_opt ::= WHERE expr",
 /* 162 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 163 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 164 */ "setlist ::= nm EQ expr",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 167 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 168 */ "insert_cmd ::= INSERT orconf",
 /* 169 */ "insert_cmd ::= REPLACE",
 /* 170 */ "itemlist ::= itemlist COMMA expr",
 /* 171 */ "itemlist ::= expr",
 /* 172 */ "inscollist_opt ::=",
 /* 173 */ "inscollist_opt ::= LP inscollist RP",
 /* 174 */ "inscollist ::= inscollist COMMA nm",
 /* 175 */ "inscollist ::= nm",
 /* 176 */ "expr ::= term",
 /* 177 */ "expr ::= LP expr RP",
 /* 178 */ "term ::= NULL",
 /* 179 */ "expr ::= ID",
 /* 180 */ "expr ::= JOIN_KW",
 /* 181 */ "expr ::= nm DOT nm",
 /* 182 */ "expr ::= nm DOT nm DOT nm",
 /* 183 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 184 */ "term ::= STRING",
 /* 185 */ "expr ::= REGISTER",
 /* 186 */ "expr ::= VARIABLE",
 /* 187 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 188 */ "expr ::= ID LP distinct exprlist RP",
 /* 189 */ "expr ::= ID LP STAR RP",
 /* 190 */ "term ::= CTIME_KW",
 /* 191 */ "expr ::= expr AND expr",
 /* 192 */ "expr ::= expr OR expr",
 /* 193 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 194 */ "expr ::= expr EQ|NE expr",
 /* 195 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 196 */ "expr ::= expr PLUS|MINUS expr",
 /* 197 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 198 */ "expr ::= expr CONCAT expr",
 /* 199 */ "likeop ::= LIKE_KW",
 /* 200 */ "likeop ::= NOT LIKE_KW",
 /* 201 */ "likeop ::= MATCH",
 /* 202 */ "likeop ::= NOT MATCH",
 /* 203 */ "escape ::= ESCAPE expr",
 /* 204 */ "escape ::=",
 /* 205 */ "expr ::= expr likeop expr escape",
 /* 206 */ "expr ::= expr ISNULL|NOTNULL",
 /* 207 */ "expr ::= expr IS NULL",
 /* 208 */ "expr ::= expr NOT NULL",
 /* 209 */ "expr ::= expr IS NOT NULL",
 /* 210 */ "expr ::= NOT|BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "between_op ::= BETWEEN",
 /* 214 */ "between_op ::= NOT BETWEEN",
 /* 215 */ "expr ::= expr between_op expr AND expr",
 /* 216 */ "in_op ::= IN",
 /* 217 */ "in_op ::= NOT IN",
 /* 218 */ "expr ::= expr in_op LP exprlist RP",
 /* 219 */ "expr ::= LP select RP",
 /* 220 */ "expr ::= expr in_op LP select RP",
 /* 221 */ "expr ::= expr in_op nm dbnm",
 /* 222 */ "expr ::= EXISTS LP select RP",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= exprlist COMMA expritem",
 /* 231 */ "exprlist ::= expritem",
 /* 232 */ "expritem ::= expr",
 /* 233 */ "expritem ::=",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 243 */ "cmd ::= VACUUM",
 /* 244 */ "cmd ::= VACUUM nm",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 248 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 249 */ "cmd ::= PRAGMA nm dbnm",
 /* 250 */ "nmnum ::= plus_num",
 /* 251 */ "nmnum ::= nm",
 /* 252 */ "plus_num ::= plus_opt number",
 /* 253 */ "minus_num ::= MINUS number",
 /* 254 */ "number ::= INTEGER|FLOAT",
 /* 255 */ "plus_opt ::= PLUS",
 /* 256 */ "plus_opt ::=",
 /* 257 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 258 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 259 */ "trigger_time ::= BEFORE",
 /* 260 */ "trigger_time ::= AFTER",
 /* 261 */ "trigger_time ::= INSTEAD OF",
 /* 262 */ "trigger_time ::=",
 /* 263 */ "trigger_event ::= DELETE|INSERT",
 /* 264 */ "trigger_event ::= UPDATE",
 /* 265 */ "trigger_event ::= UPDATE OF inscollist",
 /* 266 */ "foreach_clause ::=",
 /* 267 */ "foreach_clause ::= FOR EACH ROW",
 /* 268 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 269 */ "when_clause ::=",
 /* 270 */ "when_clause ::= WHEN expr",
 /* 271 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 272 */ "trigger_cmd_list ::=",
 /* 273 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 274 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 275 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 276 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 277 */ "trigger_cmd ::= select",
 /* 278 */ "expr ::= RAISE LP IGNORE RP",
 /* 279 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 280 */ "raisetype ::= ROLLBACK",
 /* 281 */ "raisetype ::= ABORT",
 /* 282 */ "raisetype ::= FAIL",
 /* 283 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 284 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 285 */ "key_opt ::=",
 /* 286 */ "key_opt ::= KEY expr",
 /* 287 */ "database_kw_opt ::= DATABASE",
 /* 288 */ "database_kw_opt ::=",
 /* 289 */ "cmd ::= DETACH database_kw_opt expr",
 /* 290 */ "cmd ::= REINDEX",
 /* 291 */ "cmd ::= REINDEX nm dbnm",
 /* 292 */ "cmd ::= ANALYZE",
 /* 293 */ "cmd ::= ANALYZE nm dbnm",
 /* 294 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 295 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 296 */ "add_column_fullname ::= fullname",
 /* 297 */ "kwcolumn_opt ::=",
 /* 298 */ "kwcolumn_opt ::= COLUMNKW",
 /* 299 */ "cmd ::= create_vtab",
 /* 300 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 301 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 302 */ "vtabarglist ::= vtabarg",
 /* 303 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 304 */ "vtabarg ::=",
 /* 305 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 306 */ "vtabargtoken ::= ANY",
 /* 307 */ "vtabargtoken ::= lp anylist RP",
 /* 308 */ "lp ::= LP",
 /* 309 */ "anylist ::=",
 /* 310 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 156:
    case 190:
    case 207:
#line 374 "parse.y"
{sqlite3SelectDelete((yypminor->yy43));}
#line 1252 "parse.c"
      break;
    case 170:
    case 171:
    case 195:
    case 197:
    case 205:
    case 211:
    case 219:
    case 222:
    case 224:
    case 225:
    case 236:
#line 618 "parse.y"
{sqlite3ExprDelete((yypminor->yy450));}
#line 1267 "parse.c"
      break;
    case 175:
    case 183:
    case 193:
    case 196:
    case 198:
    case 200:
    case 210:
    case 213:
    case 214:
    case 217:
    case 223:
#line 855 "parse.y"
{sqlite3ExprListDelete((yypminor->yy242));}
#line 1282 "parse.c"
      break;
    case 189:
    case 194:
    case 202:
    case 203:
#line 487 "parse.y"
{sqlite3SrcListDelete((yypminor->yy419));}
#line 1290 "parse.c"
      break;
    case 199:
#line 548 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy84).pLimit);
  sqlite3ExprDelete((yypminor->yy84).pOffset);
}
#line 1298 "parse.c"
      break;
    case 206:
    case 209:
    case 216:
#line 504 "parse.y"
{sqlite3IdListDelete((yypminor->yy352));}
#line 1305 "parse.c"
      break;
    case 232:
    case 237:
#line 952 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy75));}
#line 1311 "parse.c"
      break;
    case 234:
#line 936 "parse.y"
{sqlite3IdListDelete((yypminor->yy354).b);}
#line 1316 "parse.c"
      break;
    case 239:
#line 1020 "parse.y"
{sqlite3ExprDelete((yypminor->yy158));}
#line 1321 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1490 "parse.c"
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 140, 1 },
  { 141, 2 },
  { 141, 1 },
  { 143, 1 },
  { 142, 1 },
  { 142, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 3 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 147, 2 },
  { 146, 0 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 149, 6 },
  { 152, 0 },
  { 152, 3 },
  { 151, 1 },
  { 151, 0 },
  { 150, 4 },
  { 150, 2 },
  { 154, 3 },
  { 154, 1 },
  { 157, 3 },
  { 158, 1 },
  { 161, 1 },
  { 162, 1 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 159, 0 },
  { 159, 1 },
  { 163, 1 },
  { 163, 4 },
  { 163, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 160, 2 },
  { 160, 0 },
  { 168, 3 },
  { 168, 1 },
  { 169, 2 },
  { 169, 4 },
  { 169, 3 },
  { 169, 3 },
  { 169, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 4 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 174, 0 },
  { 174, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 155, 0 },
  { 155, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 5 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 172, 0 },
  { 172, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 144, 4 },
  { 188, 2 },
  { 188, 0 },
  { 144, 8 },
  { 144, 4 },
  { 144, 1 },
  { 156, 1 },
  { 156, 3 },
  { 191, 1 },
  { 191, 2 },
  { 191, 1 },
  { 190, 9 },
  { 192, 1 },
  { 192, 1 },
  { 192, 0 },
  { 200, 2 },
  { 200, 0 },
  { 193, 3 },
  { 193, 2 },
  { 193, 4 },
  { 201, 2 },
  { 201, 1 },
  { 201, 0 },
  { 194, 0 },
  { 194, 2 },
  { 203, 2 },
  { 203, 0 },
  { 202, 6 },
  { 202, 7 },
  { 207, 1 },
  { 207, 1 },
  { 153, 0 },
  { 153, 2 },
  { 189, 2 },
  { 204, 1 },
  { 204, 2 },
  { 204, 3 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 206, 4 },
  { 206, 0 },
  { 198, 0 },
  { 198, 3 },
  { 210, 5 },
  { 210, 3 },
  { 211, 1 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 212, 0 },
  { 212, 2 },
  { 196, 0 },
  { 196, 3 },
  { 197, 0 },
  { 197, 2 },
  { 199, 0 },
  { 199, 2 },
  { 199, 4 },
  { 199, 4 },
  { 144, 4 },
  { 195, 0 },
  { 195, 2 },
  { 144, 6 },
  { 214, 5 },
  { 214, 3 },
  { 144, 8 },
  { 144, 5 },
  { 144, 6 },
  { 215, 2 },
  { 215, 1 },
  { 217, 3 },
  { 217, 1 },
  { 216, 0 },
  { 216, 3 },
  { 209, 3 },
  { 209, 1 },
  { 171, 1 },
  { 171, 3 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
  { 170, 1 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 6 },
  { 171, 5 },
  { 171, 4 },
  { 170, 1 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 218, 1 },
  { 218, 2 },
  { 218, 1 },
  { 218, 2 },
  { 219, 2 },
  { 219, 0 },
  { 171, 4 },
  { 171, 2 },
  { 171, 3 },
  { 171, 3 },
  { 171, 4 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 220, 1 },
  { 220, 2 },
  { 171, 5 },
  { 221, 1 },
  { 221, 2 },
  { 171, 5 },
  { 171, 3 },
  { 171, 5 },
  { 171, 4 },
  { 171, 4 },
  { 171, 5 },
  { 223, 5 },
  { 223, 4 },
  { 224, 2 },
  { 224, 0 },
  { 222, 1 },
  { 222, 0 },
  { 213, 3 },
  { 213, 1 },
  { 225, 1 },
  { 225, 0 },
  { 144, 11 },
  { 226, 1 },
  { 226, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 227, 1 },
  { 144, 4 },
  { 144, 1 },
  { 144, 2 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 6 },
  { 144, 3 },
  { 228, 1 },
  { 228, 1 },
  { 166, 2 },
  { 167, 2 },
  { 230, 1 },
  { 229, 1 },
  { 229, 0 },
  { 144, 5 },
  { 231, 11 },
  { 233, 1 },
  { 233, 1 },
  { 233, 2 },
  { 233, 0 },
  { 234, 1 },
  { 234, 1 },
  { 234, 3 },
  { 235, 0 },
  { 235, 3 },
  { 235, 3 },
  { 236, 0 },
  { 236, 2 },
  { 232, 3 },
  { 232, 0 },
  { 237, 6 },
  { 237, 8 },
  { 237, 5 },
  { 237, 4 },
  { 237, 1 },
  { 171, 4 },
  { 171, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 144, 4 },
  { 144, 6 },
  { 239, 0 },
  { 239, 2 },
  { 238, 1 },
  { 238, 0 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 6 },
  { 144, 6 },
  { 240, 1 },
  { 241, 0 },
  { 241, 1 },
  { 144, 1 },
  { 144, 4 },
  { 242, 7 },
  { 243, 1 },
  { 243, 3 },
  { 244, 0 },
  { 244, 2 },
  { 245, 1 },
  { 245, 3 },
  { 246, 1 },
  { 247, 0 },
  { 247, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1884 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1889 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1894 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1899 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy316);}
#line 1904 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy316 = TK_DEFERRED;}
#line 1909 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy316 = yymsp[0].major;}
#line 1918 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1924 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1929 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy178,&yymsp[0].minor.yy178,yymsp[-4].minor.yy316,0,0,yymsp[-2].minor.yy316);
}
#line 1936 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 213:
      case 216:
#line 132 "parse.y"
{yygotominor.yy316 = 0;}
#line 1951 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 214:
      case 217:
#line 133 "parse.y"
{yygotominor.yy316 = 1;}
#line 1963 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy178,&yymsp[0].minor.yy0,0);
}
#line 1970 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy43);
  sqlite3SelectDelete(yymsp[0].minor.yy43);
}
#line 1978 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy178.z = yymsp[-2].minor.yy178.z;
  yygotominor.yy178.n = (pParse->sLastToken.z-yymsp[-2].minor.yy178.z) + pParse->sLastToken.n;
}
#line 1986 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy178);
  yygotominor.yy178 = yymsp[0].minor.yy178;
}
#line 1994 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 254:
#line 168 "parse.y"
{yygotominor.yy178 = yymsp[0].minor.yy0;}
#line 2004 "parse.c"
        break;
      case 38:
#line 228 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy178);}
#line 2009 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 150:
      case 241:
      case 250:
      case 251:
      case 252:
      case 253:
#line 229 "parse.y"
{yygotominor.yy178 = yymsp[0].minor.yy178;}
#line 2024 "parse.c"
        break;
      case 40:
#line 230 "parse.y"
{
  yygotominor.yy178.z = yymsp[-3].minor.yy178.z;
  yygotominor.yy178.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy178.z;
}
#line 2032 "parse.c"
        break;
      case 41:
#line 234 "parse.y"
{
  yygotominor.yy178.z = yymsp[-5].minor.yy178.z;
  yygotominor.yy178.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy178.z;
}
#line 2040 "parse.c"
        break;
      case 43:
#line 240 "parse.y"
{yygotominor.yy178.z=yymsp[-1].minor.yy178.z; yygotominor.yy178.n=yymsp[0].minor.yy178.n+(yymsp[0].minor.yy178.z-yymsp[-1].minor.yy178.z);}
#line 2045 "parse.c"
        break;
      case 44:
#line 242 "parse.y"
{ yygotominor.yy316 = atoi((char*)yymsp[0].minor.yy178.z); }
#line 2050 "parse.c"
        break;
      case 45:
#line 243 "parse.y"
{ yygotominor.yy316 = -atoi((char*)yymsp[0].minor.yy178.z); }
#line 2055 "parse.c"
        break;
      case 50:
      case 52:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy450);}
#line 2061 "parse.c"
        break;
      case 51:
#line 253 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy450);}
#line 2066 "parse.c"
        break;
      case 53:
#line 255 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy450, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2074 "parse.c"
        break;
      case 54:
#line 259 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy178);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2082 "parse.c"
        break;
      case 56:
#line 268 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy316);}
#line 2087 "parse.c"
        break;
      case 57:
#line 270 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy316,yymsp[0].minor.yy316,yymsp[-2].minor.yy316);}
#line 2092 "parse.c"
        break;
      case 58:
#line 271 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy316,0,0,0,0);}
#line 2097 "parse.c"
        break;
      case 59:
#line 272 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy450);}
#line 2102 "parse.c"
        break;
      case 60:
#line 274 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy178,yymsp[-1].minor.yy242,yymsp[0].minor.yy316);}
#line 2107 "parse.c"
        break;
      case 61:
#line 275 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy316);}
#line 2112 "parse.c"
        break;
      case 62:
#line 276 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy178.z, yymsp[0].minor.yy178.n);}
#line 2117 "parse.c"
        break;
      case 65:
#line 289 "parse.y"
{ yygotominor.yy316 = OE_Restrict * 0x010101; }
#line 2122 "parse.c"
        break;
      case 66:
#line 290 "parse.y"
{ yygotominor.yy316 = (yymsp[-1].minor.yy316 & yymsp[0].minor.yy207.mask) | yymsp[0].minor.yy207.value; }
#line 2127 "parse.c"
        break;
      case 67:
#line 292 "parse.y"
{ yygotominor.yy207.value = 0;     yygotominor.yy207.mask = 0x000000; }
#line 2132 "parse.c"
        break;
      case 68:
#line 293 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy316;     yygotominor.yy207.mask = 0x0000ff; }
#line 2137 "parse.c"
        break;
      case 69:
#line 294 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy316<<8;  yygotominor.yy207.mask = 0x00ff00; }
#line 2142 "parse.c"
        break;
      case 70:
#line 295 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy316<<16; yygotominor.yy207.mask = 0xff0000; }
#line 2147 "parse.c"
        break;
      case 71:
#line 297 "parse.y"
{ yygotominor.yy316 = OE_SetNull; }
#line 2152 "parse.c"
        break;
      case 72:
#line 298 "parse.y"
{ yygotominor.yy316 = OE_SetDflt; }
#line 2157 "parse.c"
        break;
      case 73:
#line 299 "parse.y"
{ yygotominor.yy316 = OE_Cascade; }
#line 2162 "parse.c"
        break;
      case 74:
#line 300 "parse.y"
{ yygotominor.yy316 = OE_Restrict; }
#line 2167 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 168:
#line 302 "parse.y"
{yygotominor.yy316 = yymsp[0].minor.yy316;}
#line 2178 "parse.c"
        break;
      case 80:
#line 312 "parse.y"
{yygotominor.yy178.n = 0; yygotominor.yy178.z = 0;}
#line 2183 "parse.c"
        break;
      case 81:
#line 313 "parse.y"
{yygotominor.yy178 = yymsp[-1].minor.yy0;}
#line 2188 "parse.c"
        break;
      case 86:
#line 319 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy242,yymsp[0].minor.yy316,yymsp[-2].minor.yy316,0);}
#line 2193 "parse.c"
        break;
      case 87:
#line 321 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy242,yymsp[0].minor.yy316,0,0,0,0);}
#line 2198 "parse.c"
        break;
      case 88:
#line 322 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy450);}
#line 2203 "parse.c"
        break;
      case 89:
#line 324 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy242, &yymsp[-3].minor.yy178, yymsp[-2].minor.yy242, yymsp[-1].minor.yy316);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy316);
}
#line 2211 "parse.c"
        break;
      case 92:
      case 94:
#line 338 "parse.y"
{yygotominor.yy316 = OE_Default;}
#line 2217 "parse.c"
        break;
      case 97:
#line 343 "parse.y"
{yygotominor.yy316 = OE_Ignore;}
#line 2222 "parse.c"
        break;
      case 98:
      case 169:
#line 344 "parse.y"
{yygotominor.yy316 = OE_Replace;}
#line 2228 "parse.c"
        break;
      case 99:
#line 348 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy419, 0, yymsp[-1].minor.yy316);
}
#line 2235 "parse.c"
        break;
      case 102:
#line 358 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy178, &yymsp[-2].minor.yy178, yymsp[0].minor.yy43, yymsp[-6].minor.yy316, yymsp[-4].minor.yy316);
}
#line 2242 "parse.c"
        break;
      case 103:
#line 361 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy419, 1, yymsp[-1].minor.yy316);
}
#line 2249 "parse.c"
        break;
      case 104:
#line 368 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy43, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy43);
}
#line 2257 "parse.c"
        break;
      case 105:
      case 128:
#line 378 "parse.y"
{yygotominor.yy43 = yymsp[0].minor.yy43;}
#line 2263 "parse.c"
        break;
      case 106:
#line 380 "parse.y"
{
  if( yymsp[0].minor.yy43 ){
    yymsp[0].minor.yy43->op = yymsp[-1].minor.yy316;
    yymsp[0].minor.yy43->pPrior = yymsp[-2].minor.yy43;
  }
  yygotominor.yy43 = yymsp[0].minor.yy43;
}
#line 2274 "parse.c"
        break;
      case 108:
#line 389 "parse.y"
{yygotominor.yy316 = TK_ALL;}
#line 2279 "parse.c"
        break;
      case 110:
#line 393 "parse.y"
{
  yygotominor.yy43 = sqlite3SelectNew(yymsp[-6].minor.yy242,yymsp[-5].minor.yy419,yymsp[-4].minor.yy450,yymsp[-3].minor.yy242,yymsp[-2].minor.yy450,yymsp[-1].minor.yy242,yymsp[-7].minor.yy316,yymsp[0].minor.yy84.pLimit,yymsp[0].minor.yy84.pOffset);
}
#line 2286 "parse.c"
        break;
      case 114:
      case 238:
#line 414 "parse.y"
{yygotominor.yy242 = yymsp[-1].minor.yy242;}
#line 2292 "parse.c"
        break;
      case 115:
      case 141:
      case 151:
      case 237:
#line 415 "parse.y"
{yygotominor.yy242 = 0;}
#line 2300 "parse.c"
        break;
      case 116:
#line 416 "parse.y"
{
   yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-2].minor.yy242,yymsp[-1].minor.yy450,yymsp[0].minor.yy178.n?&yymsp[0].minor.yy178:0);
}
#line 2307 "parse.c"
        break;
      case 117:
#line 419 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-1].minor.yy242, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2314 "parse.c"
        break;
      case 118:
#line 422 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy178);
  yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-3].minor.yy242, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2323 "parse.c"
        break;
      case 121:
#line 434 "parse.y"
{yygotominor.yy178.n = 0;}
#line 2328 "parse.c"
        break;
      case 122:
#line 446 "parse.y"
{yygotominor.yy419 = sqliteMalloc(sizeof(*yygotominor.yy419));}
#line 2333 "parse.c"
        break;
      case 123:
#line 447 "parse.y"
{
  yygotominor.yy419 = yymsp[0].minor.yy419;
  sqlite3SrcListShiftJoinType(yygotominor.yy419);
}
#line 2341 "parse.c"
        break;
      case 124:
#line 455 "parse.y"
{
   yygotominor.yy419 = yymsp[-1].minor.yy419;
   if( yygotominor.yy419 && yygotominor.yy419->nSrc>0 ) yygotominor.yy419->a[yygotominor.yy419->nSrc-1].jointype = yymsp[0].minor.yy316;
}
#line 2349 "parse.c"
        break;
      case 125:
#line 459 "parse.y"
{yygotominor.yy419 = 0;}
#line 2354 "parse.c"
        break;
      case 126:
#line 460 "parse.y"
{
  yygotominor.yy419 = sqlite3SrcListAppendFromTerm(yymsp[-5].minor.yy419,&yymsp[-4].minor.yy178,&yymsp[-3].minor.yy178,&yymsp[-2].minor.yy178,0,yymsp[-1].minor.yy450,yymsp[0].minor.yy352);
}
#line 2361 "parse.c"
        break;
      case 127:
#line 465 "parse.y"
{
    yygotominor.yy419 = sqlite3SrcListAppendFromTerm(yymsp[-6].minor.yy419,0,0,&yymsp[-2].minor.yy178,yymsp[-4].minor.yy43,yymsp[-1].minor.yy450,yymsp[0].minor.yy352);
  }
#line 2368 "parse.c"
        break;
      case 129:
#line 476 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy419);
     yygotominor.yy43 = sqlite3SelectNew(0,yymsp[0].minor.yy419,0,0,0,0,0,0,0);
  }
#line 2376 "parse.c"
        break;
      case 130:
#line 483 "parse.y"
{yygotominor.yy178.z=0; yygotominor.yy178.n=0;}
#line 2381 "parse.c"
        break;
      case 132:
#line 488 "parse.y"
{yygotominor.yy419 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy178,&yymsp[0].minor.yy178);}
#line 2386 "parse.c"
        break;
      case 133:
#line 492 "parse.y"
{ yygotominor.yy316 = JT_INNER; }
#line 2391 "parse.c"
        break;
      case 134:
#line 493 "parse.y"
{ yygotominor.yy316 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2396 "parse.c"
        break;
      case 135:
#line 494 "parse.y"
{ yygotominor.yy316 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy178,0); }
#line 2401 "parse.c"
        break;
      case 136:
#line 496 "parse.y"
{ yygotominor.yy316 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy178,&yymsp[-1].minor.yy178); }
#line 2406 "parse.c"
        break;
      case 137:
      case 145:
      case 154:
      case 161:
      case 176:
      case 203:
      case 226:
      case 228:
      case 232:
#line 500 "parse.y"
{yygotominor.yy450 = yymsp[0].minor.yy450;}
#line 2419 "parse.c"
        break;
      case 138:
      case 153:
      case 160:
      case 204:
      case 227:
      case 229:
      case 233:
#line 501 "parse.y"
{yygotominor.yy450 = 0;}
#line 2430 "parse.c"
        break;
      case 139:
      case 173:
#line 505 "parse.y"
{yygotominor.yy352 = yymsp[-1].minor.yy352;}
#line 2436 "parse.c"
        break;
      case 140:
      case 172:
#line 506 "parse.y"
{yygotominor.yy352 = 0;}
#line 2442 "parse.c"
        break;
      case 142:
      case 152:
#line 517 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2448 "parse.c"
        break;
      case 143:
#line 518 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-4].minor.yy242,yymsp[-2].minor.yy450,yymsp[-1].minor.yy178.n>0?&yymsp[-1].minor.yy178:0);
  if( yygotominor.yy242 ) yygotominor.yy242->a[yygotominor.yy242->nExpr-1].sortOrder = yymsp[0].minor.yy316;
}
#line 2456 "parse.c"
        break;
      case 144:
#line 522 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy450,yymsp[-1].minor.yy178.n>0?&yymsp[-1].minor.yy178:0);
  if( yygotominor.yy242 && yygotominor.yy242->a ) yygotominor.yy242->a[0].sortOrder = yymsp[0].minor.yy316;
}
#line 2464 "parse.c"
        break;
      case 146:
      case 148:
#line 531 "parse.y"
{yygotominor.yy316 = SQLITE_SO_ASC;}
#line 2470 "parse.c"
        break;
      case 147:
#line 532 "parse.y"
{yygotominor.yy316 = SQLITE_SO_DESC;}
#line 2475 "parse.c"
        break;
      case 149:
#line 534 "parse.y"
{yygotominor.yy178.z = 0; yygotominor.yy178.n = 0;}
#line 2480 "parse.c"
        break;
      case 155:
#line 552 "parse.y"
{yygotominor.yy84.pLimit = 0; yygotominor.yy84.pOffset = 0;}
#line 2485 "parse.c"
        break;
      case 156:
#line 553 "parse.y"
{yygotominor.yy84.pLimit = yymsp[0].minor.yy450; yygotominor.yy84.pOffset = 0;}
#line 2490 "parse.c"
        break;
      case 157:
#line 555 "parse.y"
{yygotominor.yy84.pLimit = yymsp[-2].minor.yy450; yygotominor.yy84.pOffset = yymsp[0].minor.yy450;}
#line 2495 "parse.c"
        break;
      case 158:
#line 557 "parse.y"
{yygotominor.yy84.pOffset = yymsp[-2].minor.yy450; yygotominor.yy84.pLimit = yymsp[0].minor.yy450;}
#line 2500 "parse.c"
        break;
      case 159:
#line 561 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy419,yymsp[0].minor.yy450);}
#line 2505 "parse.c"
        break;
      case 162:
#line 572 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy419,yymsp[-1].minor.yy242,yymsp[0].minor.yy450,yymsp[-4].minor.yy316);}
#line 2510 "parse.c"
        break;
      case 163:
#line 578 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-4].minor.yy242,yymsp[0].minor.yy450,&yymsp[-2].minor.yy178);}
#line 2515 "parse.c"
        break;
      case 164:
#line 579 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(0,yymsp[0].minor.yy450,&yymsp[-2].minor.yy178);}
#line 2520 "parse.c"
        break;
      case 165:
#line 585 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy419, yymsp[-1].minor.yy242, 0, yymsp[-4].minor.yy352, yymsp[-7].minor.yy316);}
#line 2525 "parse.c"
        break;
      case 166:
#line 587 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy419, 0, yymsp[0].minor.yy43, yymsp[-1].minor.yy352, yymsp[-4].minor.yy316);}
#line 2530 "parse.c"
        break;
      case 167:
#line 589 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy419, 0, 0, yymsp[-2].minor.yy352, yymsp[-5].minor.yy316);}
#line 2535 "parse.c"
        break;
      case 170:
      case 230:
#line 599 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-2].minor.yy242,yymsp[0].minor.yy450,0);}
#line 2541 "parse.c"
        break;
      case 171:
      case 231:
#line 600 "parse.y"
{yygotominor.yy242 = sqlite3ExprListAppend(0,yymsp[0].minor.yy450,0);}
#line 2547 "parse.c"
        break;
      case 174:
#line 609 "parse.y"
{yygotominor.yy352 = sqlite3IdListAppend(yymsp[-2].minor.yy352,&yymsp[0].minor.yy178);}
#line 2552 "parse.c"
        break;
      case 175:
#line 610 "parse.y"
{yygotominor.yy352 = sqlite3IdListAppend(0,&yymsp[0].minor.yy178);}
#line 2557 "parse.c"
        break;
      case 177:
#line 621 "parse.y"
{yygotominor.yy450 = yymsp[-1].minor.yy450; sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2562 "parse.c"
        break;
      case 178:
      case 183:
      case 184:
#line 622 "parse.y"
{yygotominor.yy450 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2569 "parse.c"
        break;
      case 179:
      case 180:
#line 623 "parse.y"
{yygotominor.yy450 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2575 "parse.c"
        break;
      case 181:
#line 625 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy178);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy178);
  yygotominor.yy450 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2584 "parse.c"
        break;
      case 182:
#line 630 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy178);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy178);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy178);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy450 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2595 "parse.c"
        break;
      case 185:
#line 639 "parse.y"
{yygotominor.yy450 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2600 "parse.c"
        break;
      case 186:
#line 640 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy450 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2609 "parse.c"
        break;
      case 187:
#line 646 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy450, 0, &yymsp[-1].minor.yy178);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2617 "parse.c"
        break;
      case 188:
#line 651 "parse.y"
{
  yygotominor.yy450 = sqlite3ExprFunction(yymsp[-1].minor.yy242, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy316 && yygotominor.yy450 ){
    yygotominor.yy450->flags |= EP_Distinct;
  }
}
#line 2628 "parse.c"
        break;
      case 189:
#line 658 "parse.y"
{
  yygotominor.yy450 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2636 "parse.c"
        break;
      case 190:
#line 662 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy450 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy450 ){
    yygotominor.yy450->op = TK_CONST_FUNC;  
    yygotominor.yy450->span = yymsp[0].minor.yy0;
  }
}
#line 2649 "parse.c"
        break;
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
#line 671 "parse.y"
{yygotominor.yy450 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy450, yymsp[0].minor.yy450, 0);}
#line 2661 "parse.c"
        break;
      case 199:
      case 201:
#line 681 "parse.y"
{yygotominor.yy86.eOperator = yymsp[0].minor.yy0; yygotominor.yy86.not = 0;}
#line 2667 "parse.c"
        break;
      case 200:
      case 202:
#line 682 "parse.y"
{yygotominor.yy86.eOperator = yymsp[0].minor.yy0; yygotominor.yy86.not = 1;}
#line 2673 "parse.c"
        break;
      case 205:
#line 689 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy450, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy450, 0);
  if( yymsp[0].minor.yy450 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy450, 0);
  }
  yygotominor.yy450 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy86.eOperator);
  if( yymsp[-2].minor.yy86.not ) yygotominor.yy450 = sqlite3Expr(TK_NOT, yygotominor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450, &yymsp[-3].minor.yy450->span, &yymsp[-1].minor.yy450->span);
  if( yygotominor.yy450 ) yygotominor.yy450->flags |= EP_InfixFunc;
}
#line 2689 "parse.c"
        break;
      case 206:
#line 702 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2697 "parse.c"
        break;
      case 207:
#line 706 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2705 "parse.c"
        break;
      case 208:
#line 710 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2713 "parse.c"
        break;
      case 209:
#line 714 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-3].minor.yy450->span,&yymsp[0].minor.yy0);
}
#line 2721 "parse.c"
        break;
      case 210:
#line 718 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy450->span);
}
#line 2729 "parse.c"
        break;
      case 211:
#line 722 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy450->span);
}
#line 2737 "parse.c"
        break;
      case 212:
#line 726 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy450->span);
}
#line 2745 "parse.c"
        break;
      case 215:
#line 733 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy450, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy450, 0);
  yygotominor.yy450 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy450, 0, 0);
  if( yygotominor.yy450 ){
    yygotominor.yy450->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy316 ) yygotominor.yy450 = sqlite3Expr(TK_NOT, yygotominor.yy450, 0, 0);
  sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy450->span,&yymsp[0].minor.yy450->span);
}
#line 2761 "parse.c"
        break;
      case 218:
#line 749 "parse.y"
{
    yygotominor.yy450 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy450, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pList = yymsp[-1].minor.yy242;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy242);
    }
    if( yymsp[-3].minor.yy316 ) yygotominor.yy450 = sqlite3Expr(TK_NOT, yygotominor.yy450, 0, 0);
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy450->span,&yymsp[0].minor.yy0);
  }
#line 2775 "parse.c"
        break;
      case 219:
#line 759 "parse.y"
{
    yygotominor.yy450 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pSelect = yymsp[-1].minor.yy43;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy43);
    }
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2788 "parse.c"
        break;
      case 220:
#line 768 "parse.y"
{
    yygotominor.yy450 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy450, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pSelect = yymsp[-1].minor.yy43;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy43);
    }
    if( yymsp[-3].minor.yy316 ) yygotominor.yy450 = sqlite3Expr(TK_NOT, yygotominor.yy450, 0, 0);
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-4].minor.yy450->span,&yymsp[0].minor.yy0);
  }
#line 2802 "parse.c"
        break;
      case 221:
#line 778 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy178,&yymsp[0].minor.yy178);
    yygotominor.yy450 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy450, 0, 0);
    if( yygotominor.yy450 ){
      yygotominor.yy450->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy316 ) yygotominor.yy450 = sqlite3Expr(TK_NOT, yygotominor.yy450, 0, 0);
    sqlite3ExprSpan(yygotominor.yy450,&yymsp[-3].minor.yy450->span,yymsp[0].minor.yy178.z?&yymsp[0].minor.yy178:&yymsp[-1].minor.yy178);
  }
#line 2817 "parse.c"
        break;
      case 222:
#line 789 "parse.y"
{
    Expr *p = yygotominor.yy450 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy43;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy43);
    }
  }
#line 2830 "parse.c"
        break;
      case 223:
#line 801 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy450, yymsp[-1].minor.yy450, 0);
  if( yygotominor.yy450 ){
    yygotominor.yy450->pList = yymsp[-2].minor.yy242;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy242);
  }
  sqlite3ExprSpan(yygotominor.yy450, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2843 "parse.c"
        break;
      case 224:
#line 812 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-4].minor.yy242, yymsp[-2].minor.yy450, 0);
  yygotominor.yy242 = sqlite3ExprListAppend(yygotominor.yy242, yymsp[0].minor.yy450, 0);
}
#line 2851 "parse.c"
        break;
      case 225:
#line 816 "parse.y"
{
  yygotominor.yy242 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy450, 0);
  yygotominor.yy242 = sqlite3ExprListAppend(yygotominor.yy242, yymsp[0].minor.yy450, 0);
}
#line 2859 "parse.c"
        break;
      case 234:
#line 843 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy178, &yymsp[-5].minor.yy178, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy178,0), yymsp[-1].minor.yy242, yymsp[-9].minor.yy316,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy316);
}
#line 2867 "parse.c"
        break;
      case 235:
      case 281:
#line 849 "parse.y"
{yygotominor.yy316 = OE_Abort;}
#line 2873 "parse.c"
        break;
      case 236:
#line 850 "parse.y"
{yygotominor.yy316 = OE_None;}
#line 2878 "parse.c"
        break;
      case 239:
#line 860 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy178.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy178.z, yymsp[-1].minor.yy178.n);
  }
  yygotominor.yy242 = sqlite3ExprListAppend(yymsp[-4].minor.yy242, p, &yymsp[-2].minor.yy178);
  if( yygotominor.yy242 ) yygotominor.yy242->a[yygotominor.yy242->nExpr-1].sortOrder = yymsp[0].minor.yy316;
}
#line 2891 "parse.c"
        break;
      case 240:
#line 869 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy178.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy178.z, yymsp[-1].minor.yy178.n);
  }
  yygotominor.yy242 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy178);
  if( yygotominor.yy242 ) yygotominor.yy242->a[yygotominor.yy242->nExpr-1].sortOrder = yymsp[0].minor.yy316;
}
#line 2904 "parse.c"
        break;
      case 242:
#line 883 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy419, yymsp[-1].minor.yy316);}
#line 2909 "parse.c"
        break;
      case 243:
      case 244:
#line 888 "parse.y"
{sqlite3Vacuum(pParse);}
#line 2915 "parse.c"
        break;
      case 245:
#line 895 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy178,&yymsp[-2].minor.yy178,&yymsp[0].minor.yy178,0);}
#line 2920 "parse.c"
        break;
      case 246:
#line 896 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy178,&yymsp[-2].minor.yy178,&yymsp[0].minor.yy0,0);}
#line 2925 "parse.c"
        break;
      case 247:
#line 897 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy178,&yymsp[-2].minor.yy178,&yymsp[0].minor.yy178,1);
}
#line 2932 "parse.c"
        break;
      case 248:
#line 900 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy178,&yymsp[-3].minor.yy178,&yymsp[-1].minor.yy178,0);}
#line 2937 "parse.c"
        break;
      case 249:
#line 901 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy178,&yymsp[0].minor.yy178,0,0);}
#line 2942 "parse.c"
        break;
      case 257:
#line 915 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy178.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy178.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy75, &all);
}
#line 2952 "parse.c"
        break;
      case 258:
#line 924 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy178, &yymsp[-6].minor.yy178, yymsp[-5].minor.yy316, yymsp[-4].minor.yy354.a, yymsp[-4].minor.yy354.b, yymsp[-2].minor.yy419, yymsp[-1].minor.yy316, yymsp[0].minor.yy450, yymsp[-10].minor.yy316, yymsp[-8].minor.yy316);
  yygotominor.yy178 = (yymsp[-6].minor.yy178.n==0?yymsp[-7].minor.yy178:yymsp[-6].minor.yy178);
}
#line 2960 "parse.c"
        break;
      case 259:
      case 262:
#line 930 "parse.y"
{ yygotominor.yy316 = TK_BEFORE; }
#line 2966 "parse.c"
        break;
      case 260:
#line 931 "parse.y"
{ yygotominor.yy316 = TK_AFTER;  }
#line 2971 "parse.c"
        break;
      case 261:
#line 932 "parse.y"
{ yygotominor.yy316 = TK_INSTEAD;}
#line 2976 "parse.c"
        break;
      case 263:
      case 264:
#line 937 "parse.y"
{yygotominor.yy354.a = yymsp[0].major; yygotominor.yy354.b = 0;}
#line 2982 "parse.c"
        break;
      case 265:
#line 939 "parse.y"
{yygotominor.yy354.a = TK_UPDATE; yygotominor.yy354.b = yymsp[0].minor.yy352;}
#line 2987 "parse.c"
        break;
      case 266:
      case 267:
#line 942 "parse.y"
{ yygotominor.yy316 = TK_ROW; }
#line 2993 "parse.c"
        break;
      case 268:
#line 944 "parse.y"
{ yygotominor.yy316 = TK_STATEMENT; }
#line 2998 "parse.c"
        break;
      case 269:
#line 948 "parse.y"
{ yygotominor.yy450 = 0; }
#line 3003 "parse.c"
        break;
      case 270:
#line 949 "parse.y"
{ yygotominor.yy450 = yymsp[0].minor.yy450; }
#line 3008 "parse.c"
        break;
      case 271:
#line 953 "parse.y"
{
  if( yymsp[-2].minor.yy75 ){
    yymsp[-2].minor.yy75->pLast->pNext = yymsp[-1].minor.yy75;
  }else{
    yymsp[-2].minor.yy75 = yymsp[-1].minor.yy75;
  }
  yymsp[-2].minor.yy75->pLast = yymsp[-1].minor.yy75;
  yygotominor.yy75 = yymsp[-2].minor.yy75;
}
#line 3021 "parse.c"
        break;
      case 272:
#line 962 "parse.y"
{ yygotominor.yy75 = 0; }
#line 3026 "parse.c"
        break;
      case 273:
#line 968 "parse.y"
{ yygotominor.yy75 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy178, yymsp[-1].minor.yy242, yymsp[0].minor.yy450, yymsp[-4].minor.yy316); }
#line 3031 "parse.c"
        break;
      case 274:
#line 973 "parse.y"
{yygotominor.yy75 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy178, yymsp[-4].minor.yy352, yymsp[-1].minor.yy242, 0, yymsp[-7].minor.yy316);}
#line 3036 "parse.c"
        break;
      case 275:
#line 976 "parse.y"
{yygotominor.yy75 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy178, yymsp[-1].minor.yy352, 0, yymsp[0].minor.yy43, yymsp[-4].minor.yy316);}
#line 3041 "parse.c"
        break;
      case 276:
#line 980 "parse.y"
{yygotominor.yy75 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy178, yymsp[0].minor.yy450);}
#line 3046 "parse.c"
        break;
      case 277:
#line 983 "parse.y"
{yygotominor.yy75 = sqlite3TriggerSelectStep(yymsp[0].minor.yy43); }
#line 3051 "parse.c"
        break;
      case 278:
#line 986 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy450 ){
    yygotominor.yy450->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy450, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3062 "parse.c"
        break;
      case 279:
#line 993 "parse.y"
{
  yygotominor.yy450 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy178); 
  if( yygotominor.yy450 ) {
    yygotominor.yy450->iColumn = yymsp[-3].minor.yy316;
    sqlite3ExprSpan(yygotominor.yy450, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3073 "parse.c"
        break;
      case 280:
#line 1003 "parse.y"
{yygotominor.yy316 = OE_Rollback;}
#line 3078 "parse.c"
        break;
      case 282:
#line 1005 "parse.y"
{yygotominor.yy316 = OE_Fail;}
#line 3083 "parse.c"
        break;
      case 283:
#line 1010 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy419,yymsp[-1].minor.yy316);
}
#line 3090 "parse.c"
        break;
      case 284:
#line 1016 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy450, yymsp[-1].minor.yy450, yymsp[0].minor.yy158);
}
#line 3097 "parse.c"
        break;
      case 285:
#line 1021 "parse.y"
{ yygotominor.yy158 = 0; }
#line 3102 "parse.c"
        break;
      case 286:
#line 1022 "parse.y"
{ yygotominor.yy158 = yymsp[0].minor.yy450; }
#line 3107 "parse.c"
        break;
      case 289:
#line 1028 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy450);
}
#line 3114 "parse.c"
        break;
      case 290:
#line 1034 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3119 "parse.c"
        break;
      case 291:
#line 1035 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy178, &yymsp[0].minor.yy178);}
#line 3124 "parse.c"
        break;
      case 292:
#line 1040 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3129 "parse.c"
        break;
      case 293:
#line 1041 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy178, &yymsp[0].minor.yy178);}
#line 3134 "parse.c"
        break;
      case 294:
#line 1046 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy419,&yymsp[0].minor.yy178);
}
#line 3141 "parse.c"
        break;
      case 295:
#line 1049 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy178);
}
#line 3148 "parse.c"
        break;
      case 296:
#line 1052 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy419);
}
#line 3155 "parse.c"
        break;
      case 299:
#line 1061 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3160 "parse.c"
        break;
      case 300:
#line 1062 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3165 "parse.c"
        break;
      case 301:
#line 1063 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy178, &yymsp[-2].minor.yy178, &yymsp[0].minor.yy178);
}
#line 3172 "parse.c"
        break;
      case 304:
#line 1068 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3177 "parse.c"
        break;
      case 306:
      case 307:
      case 308:
      case 310:
#line 1070 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3185 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3253 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
