/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
/**
 * Objects of this class are created and managed inside a GnomeCanvas
 * widget. Its purpose is to contain and control a collection of
 * GnomeCanvasItem objects, displayed by the GnomeCanvas. The only way
 * to add a GnomeCanvasItem to a GnomeCanvas is to add it to a
 * GnomeCanvasGroup object. Because the GnomeCanvasGroup is also a
 * GnomeCanvasItem it can contain other GnomeCanvasGroups. There is
 * always one GnomeCanvasGroup in a GnomeCanvas.
 */
public class CanvasGroup extends CanvasItem {
	/**
	 * Constructs an instance of CanvasGroup from a native widget resource.
	 * @param handle The handle to the native widget.
	 */
	CanvasGroup(int handle) {
		super(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_canvas_group_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_canvas_group_get_type();
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
