# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: TextUI.py,v 1.12 1999/07/16 13:25:23 gobry Exp $

from gnome.ui import *
from gtk import *

import Pyblio.GnomeUI.Database
import Pyblio.Base
import string, re
from Pyblio.GnomeUI import Config

class Search (GtkDialog):

    def __init__ (self, data):

        GtkDialog.__init__ (self)
        

        self.set_title ('Search')
        self.set_usize (400, 500)        
        self.data = data

        # Buttons
        apply_b = GnomeStockButton (STOCK_PIXMAP_SEARCH)
        apply_b.connect ("clicked", self.apply)

        close_b = GnomeStockButton (STOCK_BUTTON_CLOSE)
        close_b.connect ("clicked", self.close)
        
        self.action_area.add (apply_b)
        self.action_area.add (close_b)

        # user levels
        self.notebook = GtkNotebook ()
        self.vbox.pack_start (self.notebook, expand = FALSE, fill = FALSE)

        # status
        self.status = GtkStatusbar ()
        self.status.set_border_width (5)
        
        self.vbox.pack_start (self.status, expand = FALSE, fill = FALSE)
        
        # Simple search
        table = GtkTable (2,2)
        table.set_border_width (5)
        table.set_col_spacings (5)
        
        table.attach (GtkLabel ('Field'), 0, 1, 0, 1)
        table.attach (GtkLabel ('Pattern'), 1, 2, 0, 1)
        
        self.field = GtkCombo ()
        table.attach (self.field, 0, 1, 1, 2)

        self.text = GnomeEntry ('match')
        table.attach (self.text, 1, 2, 1, 2)
        self.text.gtk_entry ().connect ("activate", self.apply)
        
        self.notebook.append_page (table, GtkLabel ('Simple Search'))

        # extended search
        self.notebook.append_page (GtkLabel ('Not yet implemented'),
                                   GtkLabel ('Expert Search'))


        # database
        self.database = Pyblio.GnomeUI.Database.Database ()

        holder = GtkScrolledWindow ()
        holder.set_policy (POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        holder.add (self.database)

        self.vbox.pack_start (holder)
        self.database.connect ("select_row", self.select)

        # fill the combo
        self.field.set_popdown_strings ([' - all - '] + list (Config.SearchedFields))
        return

        
    def apply (self, widget):
        if self.data.data is None: return

        if self.notebook.get_current_page () != 0:
            return

        field = string.lower (self.field.entry.get_text ())
        match = self.text.gtk_entry ().get_text ()

        if match == '': return

        error = 0
        if field == ' - all - ' or field == '':
            test = None
            for f in Config.SearchedFields:
                try:
                    new = Pyblio.Base.Tester (f, match)
                except re.error, err:
                    error = 1
                    break

                if test:
                    test = test | new
                else:
                    test = new
                    
        else:
            try:
                test = Pyblio.Base.Tester (field, match)
            except re.error, err:
                error = 1
                
        if error:
            dialog = GnomeErrorDialog ('while compiling %s\nerror: %s' % (match, err [0]))
            dialog.run_and_close ()
            return

        self.status.pop (1)
        r = self.data.data.where (test)
        self.database.set (r)
        self.status.push (1, 'found %d matches' % len (r))
        
        return
    
    def close (self, widget):
        self.destroy ()
        return

    def select (self, *arg):
        e = self.database.selection
        
        if e:
            for entry in e:
                row = self.data.access.index (entry.key)
                self.data.select_row (row, 0)
                self.data.moveto (row, 0, .5, .5)
    
