/* Candido Engine
 * Copyright (C) 2005 Richard Stellingwerff.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Written by Owen Taylor <otaylor@redhat.com>
 * and by Alexander Larsson <alexl@redhat.com>
 * Modified by Richard Stellingwerff <remenic@gmail.com>
 */
#include <gtk/gtkstyle.h>

#include "animation.h"
#include "candido_types.h"

typedef struct _CandidoStyle CandidoStyle;
typedef struct _CandidoStyleClass CandidoStyleClass;

extern GType candido_type_style;

#define CANDIDO_TYPE_STYLE              candido_type_style
#define CANDIDO_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), CANDIDO_TYPE_STYLE, CandidoStyle))
#define CANDIDO_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), CANDIDO_TYPE_STYLE, CandidoStyleClass))
#define CANDIDO_IS_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), CANDIDO_TYPE_STYLE))
#define CANDIDO_IS_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), CANDIDO_TYPE_STYLE))
#define CANDIDO_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), CANDIDO_TYPE_STYLE, CandidoStyleClass))

struct _CandidoStyle
{
	GtkStyle parent_instance;

	CandidoColors colors;
	
	guint8   squaredstyle;
	guint8   progressbarstyle;
	guint8   menubarstyle;
	guint8   menubaritemstyle;
	guint8   menuitemstyle;
	guint8   listviewitemstyle;
	GdkColor scrollbar_color;
	gboolean has_scrollbar_color;
	gboolean animation;
};

struct _CandidoStyleClass
{
  GtkStyleClass parent_class;
};


void candido_style_register_type (GTypeModule *module);
