
/* autogenerated from tvtime.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union
{
  orc_int16 i;
  orc_int8 x2[2];
} orc_union16;
typedef union
{
  orc_int32 i;
  float f;
  orc_int16 x2[2];
  orc_int8 x4[4];
} orc_union32;
typedef union
{
  orc_int64 i;
  double f;
  orc_int32 x2[2];
  float x2f[2];
  orc_int16 x4[4];
} orc_union64;
#endif

void deinterlace_line_vfir (guint8 * d1, const guint8 * s1, const guint8 * s2,
    const guint8 * s3, const guint8 * s4, const guint8 * s5, int n);
void deinterlace_line_linear (guint8 * d1, const guint8 * s1, const guint8 * s2,
    int n);
void deinterlace_line_linear_blend (guint8 * d1, const guint8 * s1,
    const guint8 * s2, const guint8 * s3, int n);
void deinterlace_line_greedy (orc_uint8 * d1, const orc_uint8 * s1,
    const orc_uint8 * s2, const orc_uint8 * s3, const orc_uint8 * s4, int p1,
    int n);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
/* end Orc C target preamble */



/* deinterlace_line_vfir */
#ifdef DISABLE_ORC
void
deinterlace_line_vfir (guint8 * d1, const guint8 * s1, const guint8 * s2,
    const guint8 * s3, const guint8 * s4, const guint8 * s5, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  const orc_int8 *ORC_RESTRICT ptr8;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;
  ptr8 = (orc_int8 *) s5;

  /* 16: loadpw */
  var40.i = 0x00000004;         /* 4 or 1.97626e-323f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var42.i = (orc_uint8) var35;
    /* 2: loadb */
    var36 = ptr8[i];
    /* 3: convubw */
    var43.i = (orc_uint8) var36;
    /* 4: addw */
    var44.i = var42.i + var43.i;
    /* 5: loadb */
    var37 = ptr5[i];
    /* 6: convubw */
    var45.i = (orc_uint8) var37;
    /* 7: loadb */
    var38 = ptr7[i];
    /* 8: convubw */
    var46.i = (orc_uint8) var38;
    /* 9: addw */
    var47.i = var45.i + var46.i;
    /* 10: shlw */
    var48.i = var47.i << 2;
    /* 11: loadb */
    var39 = ptr6[i];
    /* 12: convubw */
    var49.i = (orc_uint8) var39;
    /* 13: shlw */
    var50.i = var49.i << 1;
    /* 14: subw */
    var51.i = var48.i - var44.i;
    /* 15: addw */
    var52.i = var51.i + var50.i;
    /* 17: addw */
    var53.i = var52.i + var40.i;
    /* 18: shrsw */
    var54.i = var53.i >> 3;
    /* 19: convsuswb */
    var41 = ORC_CLAMP_UB (var54.i);
    /* 20: storeb */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_deinterlace_line_vfir (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  const orc_int8 *ORC_RESTRICT ptr8;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];
  ptr8 = (orc_int8 *) ex->arrays[8];

  /* 16: loadpw */
  var40.i = 0x00000004;         /* 4 or 1.97626e-323f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var42.i = (orc_uint8) var35;
    /* 2: loadb */
    var36 = ptr8[i];
    /* 3: convubw */
    var43.i = (orc_uint8) var36;
    /* 4: addw */
    var44.i = var42.i + var43.i;
    /* 5: loadb */
    var37 = ptr5[i];
    /* 6: convubw */
    var45.i = (orc_uint8) var37;
    /* 7: loadb */
    var38 = ptr7[i];
    /* 8: convubw */
    var46.i = (orc_uint8) var38;
    /* 9: addw */
    var47.i = var45.i + var46.i;
    /* 10: shlw */
    var48.i = var47.i << 2;
    /* 11: loadb */
    var39 = ptr6[i];
    /* 12: convubw */
    var49.i = (orc_uint8) var39;
    /* 13: shlw */
    var50.i = var49.i << 1;
    /* 14: subw */
    var51.i = var48.i - var44.i;
    /* 15: addw */
    var52.i = var51.i + var50.i;
    /* 17: addw */
    var53.i = var52.i + var40.i;
    /* 18: shrsw */
    var54.i = var53.i >> 3;
    /* 19: convsuswb */
    var41 = ORC_CLAMP_UB (var54.i);
    /* 20: storeb */
    ptr0[i] = var41;
  }

}

void
deinterlace_line_vfir (guint8 * d1, const guint8 * s1, const guint8 * s2,
    const guint8 * s3, const guint8 * s4, const guint8 * s5, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "deinterlace_line_vfir");
      orc_program_set_backup_function (p, _backup_deinterlace_line_vfir);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_source (p, 1, "s5");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_constant (p, 4, 0x00000001, "c2");
      orc_program_add_constant (p, 4, 0x00000004, "c3");
      orc_program_add_constant (p, 4, 0x00000003, "c4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S5, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T3, ORC_VAR_S4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T2,
          ORC_VAR_D1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->arrays[ORC_VAR_S5] = (void *) s5;

  func = p->code_exec;
  func (ex);
}
#endif


/* deinterlace_line_linear */
#ifdef DISABLE_ORC
void
deinterlace_line_linear (guint8 * d1, const guint8 * s1, const guint8 * s2,
    int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: avgub */
    var34 = ((orc_uint8) var32 + (orc_uint8) var33 + 1) >> 1;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_deinterlace_line_linear (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: avgub */
    var34 = ((orc_uint8) var32 + (orc_uint8) var33 + 1) >> 1;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
deinterlace_line_linear (guint8 * d1, const guint8 * s1, const guint8 * s2,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "deinterlace_line_linear");
      orc_program_set_backup_function (p, _backup_deinterlace_line_linear);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2,
          ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;

  func = p->code_exec;
  func (ex);
}
#endif


/* deinterlace_line_linear_blend */
#ifdef DISABLE_ORC
void
deinterlace_line_linear_blend (guint8 * d1, const guint8 * s1,
    const guint8 * s2, const guint8 * s3, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 9: loadpw */
  var38.i = 0x00000002;         /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var40.i = (orc_uint8) var35;
    /* 2: loadb */
    var36 = ptr5[i];
    /* 3: convubw */
    var41.i = (orc_uint8) var36;
    /* 4: loadb */
    var37 = ptr6[i];
    /* 5: convubw */
    var42.i = (orc_uint8) var37;
    /* 6: addw */
    var43.i = var40.i + var41.i;
    /* 7: addw */
    var44.i = var42.i + var42.i;
    /* 8: addw */
    var45.i = var43.i + var44.i;
    /* 10: addw */
    var46.i = var45.i + var38.i;
    /* 11: shrsw */
    var47.i = var46.i >> 2;
    /* 12: convsuswb */
    var39 = ORC_CLAMP_UB (var47.i);
    /* 13: storeb */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_deinterlace_line_linear_blend (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 9: loadpw */
  var38.i = 0x00000002;         /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var40.i = (orc_uint8) var35;
    /* 2: loadb */
    var36 = ptr5[i];
    /* 3: convubw */
    var41.i = (orc_uint8) var36;
    /* 4: loadb */
    var37 = ptr6[i];
    /* 5: convubw */
    var42.i = (orc_uint8) var37;
    /* 6: addw */
    var43.i = var40.i + var41.i;
    /* 7: addw */
    var44.i = var42.i + var42.i;
    /* 8: addw */
    var45.i = var43.i + var44.i;
    /* 10: addw */
    var46.i = var45.i + var38.i;
    /* 11: shrsw */
    var47.i = var46.i >> 2;
    /* 12: convsuswb */
    var39 = ORC_CLAMP_UB (var47.i);
    /* 13: storeb */
    ptr0[i] = var39;
  }

}

void
deinterlace_line_linear_blend (guint8 * d1, const guint8 * s1,
    const guint8 * s2, const guint8 * s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "deinterlace_line_linear_blend");
      orc_program_set_backup_function (p,
          _backup_deinterlace_line_linear_blend);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;

  func = p->code_exec;
  func (ex);
}
#endif


/* deinterlace_line_greedy */
#ifdef DISABLE_ORC
void
deinterlace_line_greedy (orc_uint8 * d1, const orc_uint8 * s1,
    const orc_uint8 * s2, const orc_uint8 * s3, const orc_uint8 * s4, int p1,
    int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_int8 var49;
  orc_int8 var50;
  orc_int8 var51;
  orc_int8 var52;
  orc_int8 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_int8 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_int8 var64;
  orc_int8 var65;
  orc_int8 var66;
  orc_int8 var67;
  orc_int8 var68;
  orc_int8 var69;
  orc_int8 var70;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;

  /* 11: loadpb */
  var44 = 0x00000080;           /* 128 or 6.32404e-322f */
  /* 13: loadpb */
  var45 = 0x00000080;           /* 128 or 6.32404e-322f */
  /* 21: loadpb */
  var46 = p1;
  /* 23: loadpb */
  var47 = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var49 = ptr4[i];
    /* 1: loadb */
    var50 = ptr7[i];
    /* 2: loadb */
    var51 = ptr6[i];
    /* 3: loadb */
    var52 = ptr5[i];
    /* 4: avgub */
    var53 = ((orc_uint8) var52 + (orc_uint8) var51 + 1) >> 1;
    /* 5: maxub */
    var54 = ORC_MAX ((orc_uint8) var49, (orc_uint8) var53);
    /* 6: minub */
    var55 = ORC_MIN ((orc_uint8) var49, (orc_uint8) var53);
    /* 7: subb */
    var56 = var54 - var55;
    /* 8: maxub */
    var57 = ORC_MAX ((orc_uint8) var50, (orc_uint8) var53);
    /* 9: minub */
    var58 = ORC_MIN ((orc_uint8) var50, (orc_uint8) var53);
    /* 10: subb */
    var59 = var57 - var58;
    /* 12: xorb */
    var60 = var56 ^ var44;
    /* 14: xorb */
    var61 = var59 ^ var45;
    /* 15: cmpgtsb */
    var62 = (var60 > var61) ? (~0) : 0;
    /* 16: andb */
    var63 = var50 & var62;
    /* 17: andnb */
    var64 = (~var62) & var49;
    /* 18: orb */
    var65 = var63 | var64;
    /* 19: maxub */
    var66 = ORC_MAX ((orc_uint8) var52, (orc_uint8) var51);
    /* 20: minub */
    var67 = ORC_MIN ((orc_uint8) var52, (orc_uint8) var51);
    /* 22: addusb */
    var68 = ORC_CLAMP_UB ((orc_uint8) var66 + (orc_uint8) var46);
    /* 24: subusb */
    var69 = ORC_CLAMP_UB ((orc_uint8) var67 - (orc_uint8) var47);
    /* 25: minub */
    var70 = ORC_MIN ((orc_uint8) var65, (orc_uint8) var68);
    /* 26: maxub */
    var48 = ORC_MAX ((orc_uint8) var70, (orc_uint8) var69);
    /* 27: storeb */
    ptr0[i] = var48;
  }

}

#else
static void
_backup_deinterlace_line_greedy (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_int8 var49;
  orc_int8 var50;
  orc_int8 var51;
  orc_int8 var52;
  orc_int8 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_int8 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_int8 var64;
  orc_int8 var65;
  orc_int8 var66;
  orc_int8 var67;
  orc_int8 var68;
  orc_int8 var69;
  orc_int8 var70;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];

  /* 11: loadpb */
  var44 = 0x00000080;           /* 128 or 6.32404e-322f */
  /* 13: loadpb */
  var45 = 0x00000080;           /* 128 or 6.32404e-322f */
  /* 21: loadpb */
  var46 = ex->params[24];
  /* 23: loadpb */
  var47 = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var49 = ptr4[i];
    /* 1: loadb */
    var50 = ptr7[i];
    /* 2: loadb */
    var51 = ptr6[i];
    /* 3: loadb */
    var52 = ptr5[i];
    /* 4: avgub */
    var53 = ((orc_uint8) var52 + (orc_uint8) var51 + 1) >> 1;
    /* 5: maxub */
    var54 = ORC_MAX ((orc_uint8) var49, (orc_uint8) var53);
    /* 6: minub */
    var55 = ORC_MIN ((orc_uint8) var49, (orc_uint8) var53);
    /* 7: subb */
    var56 = var54 - var55;
    /* 8: maxub */
    var57 = ORC_MAX ((orc_uint8) var50, (orc_uint8) var53);
    /* 9: minub */
    var58 = ORC_MIN ((orc_uint8) var50, (orc_uint8) var53);
    /* 10: subb */
    var59 = var57 - var58;
    /* 12: xorb */
    var60 = var56 ^ var44;
    /* 14: xorb */
    var61 = var59 ^ var45;
    /* 15: cmpgtsb */
    var62 = (var60 > var61) ? (~0) : 0;
    /* 16: andb */
    var63 = var50 & var62;
    /* 17: andnb */
    var64 = (~var62) & var49;
    /* 18: orb */
    var65 = var63 | var64;
    /* 19: maxub */
    var66 = ORC_MAX ((orc_uint8) var52, (orc_uint8) var51);
    /* 20: minub */
    var67 = ORC_MIN ((orc_uint8) var52, (orc_uint8) var51);
    /* 22: addusb */
    var68 = ORC_CLAMP_UB ((orc_uint8) var66 + (orc_uint8) var46);
    /* 24: subusb */
    var69 = ORC_CLAMP_UB ((orc_uint8) var67 - (orc_uint8) var47);
    /* 25: minub */
    var70 = ORC_MIN ((orc_uint8) var65, (orc_uint8) var68);
    /* 26: maxub */
    var48 = ORC_MAX ((orc_uint8) var70, (orc_uint8) var69);
    /* 27: storeb */
    ptr0[i] = var48;
  }

}

void
deinterlace_line_greedy (orc_uint8 * d1, const orc_uint8 * s1,
    const orc_uint8 * s2, const orc_uint8 * s3, const orc_uint8 * s4, int p1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "deinterlace_line_greedy");
      orc_program_set_backup_function (p, _backup_deinterlace_line_greedy);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 4, 0x00000080, "c1");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 1, "t6");
      orc_program_add_temporary (p, 1, "t7");
      orc_program_add_temporary (p, 1, "t8");
      orc_program_add_temporary (p, 1, "t9");
      orc_program_add_temporary (p, 1, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");

      orc_program_append_2 (p, "loadb", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadb", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadb", 0, ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadb", 0, ORC_VAR_T4, ORC_VAR_S2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "maxub", 0, ORC_VAR_T8, ORC_VAR_T1, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "minub", 0, ORC_VAR_T9, ORC_VAR_T1, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T6, ORC_VAR_T8, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "maxub", 0, ORC_VAR_T8, ORC_VAR_T2, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "minub", 0, ORC_VAR_T9, ORC_VAR_T2, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "xorb", 0, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "xorb", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "cmpgtsb", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andb", 0, ORC_VAR_T8, ORC_VAR_T2, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andnb", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orb", 0, ORC_VAR_T10, ORC_VAR_T8, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "maxub", 0, ORC_VAR_T12, ORC_VAR_T4, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "minub", 0, ORC_VAR_T11, ORC_VAR_T4, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addusb", 0, ORC_VAR_T12, ORC_VAR_T12,
          ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "subusb", 0, ORC_VAR_T11, ORC_VAR_T11,
          ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "minub", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T12, ORC_VAR_D1);
      orc_program_append_2 (p, "maxub", 0, ORC_VAR_D1, ORC_VAR_T10, ORC_VAR_T11,
          ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->params[ORC_VAR_P1] = p1;

  func = p->code_exec;
  func (ex);
}
#endif
