/*
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>

#include "addrview.h"

int main( int argc, char **argv )
{
  KAboutData aboutData( "addrview", I18N_NOOP( "KDE Address View" ),
                        "0.1", "Test Programm", KAboutData::License_GPL,
                        I18N_NOOP( "(c) 2003 Tobias Koenig" ) );
  KCmdLineArgs::init( argc, argv, &aboutData );

  KApplication app;

  AddrView *addrView = new AddrView();

  app.setMainWidget( addrView );
  addrView->show();

  return app.exec();
}
