/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#ifndef BANKSKROOGOID_H
#define BANKSKROOGOID_H
/** @file
* This file is Plasma Applet for Bank Skroogoid
*
* @author Siddharth SHARMA
*/
#include <Plasma/Applet>
#include <Plasma/Label>
#include <qgraphicslinearlayout.h>
#include <qsignalmapper.h>

class SKGDocumentBank;
/**
* Class BankSkroogoid
*/
class BankSkroogoid : public Plasma::Applet
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    explicit BankSkroogoid(QObject* parent, const QVariantList& args);

    /**
    * Default Destructor
    */
    ~BankSkroogoid();

    /**
     * Reimplemented from Plasma::Applet
     */
    virtual void init();

private Q_SLOTS:
    /**
     * Opens a new tab with the given account
     * @param accountName The name of the account
     */
    void openAccountTab(QString accountName);

    /**
     * Fetch data from the specified source
     */
    void dataUpdated(const QString& sourceName, const Plasma::DataEngine::Data& engineData);

private:
    /**
     * The current Skrooge document
     */
    SKGDocumentBank* doc;

    /**
     * QGraphicsLinearLayout layout for adding items
     */
    QGraphicsLinearLayout* widgetLayout;

    /**
     * The signal mapper, used to open the account tab
     */
    QSignalMapper* signalMapper;
};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(bankskroogoid, BankSkroogoid)

#endif
