<?php
/**
 * $Horde: horde/admin/perms.php,v 1.26 2003/07/30 20:16:19 chuck Exp $
 *
 * Copyright 1999, 2000, 2001 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__) . '/..');
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Menu.php';
require_once HORDE_BASE . '/lib/Perms.php';
require_once HORDE_BASE . '/lib/Group.php';
require_once HORDE_BASE . '/lib/Tree.php';

if (!Auth::isAdmin()) {
    Horde::authenticationFailureRedirect();
}

Horde::compressOutput();

$perms = &Perms::singleton();
$groups = &Group::singleton();
$auth = &Auth::singleton($conf['auth']['driver']);

$form = null;
$reload = false;
$actionID = Horde::getFormData('actionID');
switch ($actionID) {

case 'addchild':
    if (Horde::getFormData('cid') == '-1') {
        $form = 'addchild.inc';
        $pname = _("All Permissions");
    } else {
        $permission = &$perms->getPermissionById(Horde::getFormData('cid'));
        if (!is_a($permission, 'PEAR_Error')) {
            $pname = $permission->getShortName();
            $form = 'addchild.inc';
        }
    }
    break;

case 'addchildform':
    $parent = Horde::getFormData('cid');
    if ($parent == '-1') {
        $child = &$perms->newPermission(Horde::getFormData('child'));
        $result = $perms->addPermission($child);
    } else {
        $pOb = &$perms->getPermissionById($parent);
        $name = $pOb->getName() . ':' . Category::encodeName(Horde::getFormData('child'));
        $child = &$perms->newPermission($name);
        $result = $perms->addPermission($child);
    }
    if (is_a($result, 'PEAR_Error')) {
        $notification->push(sprintf(_("'%s' was not created: %s."), $child->getShortName(), $result->getMessage()), 'horde.error');
    } else {
        $notification->push(sprintf(_("'%s' was added to the permissions system."), $child->getShortName()), 'horde.success');
        $permission = &$child;
        $form = 'edit.inc';
        $reload = true;
    }
    break;

case 'delete':
    $permission = &$perms->getPermissionById(Horde::getFormData('cid'));
    if (!is_a($permission, 'PEAR_Error')) {
        $form = 'delete.inc';
    }
    break;

case 'deleteform':
    if (Horde::getFormData('confirm') == _("Delete")) {
        $permission = &$perms->getPermissionById(Horde::getFormData('cid'));
        if (is_a($permission, 'PEAR_Error')) {
            $notification->push(_("Attempt to delete a non-existent permission."), 'horde.error');
        } else {
            $result = $perms->removePermission($permission, true);
            if (is_a($result, 'PEAR_Error')) {
                $notification->push(sprintf(_("Unable to delete '%s': %s."), $permission->getShortName(), $result->getMessage()), 'horde.error');
            } else {
                $notification->push(sprintf(_("Successfully deleted '%s'."), $permission->getShortName()), 'horde.success');
                $reload = true;
            }
        }
    }
    break;

case 'edit':
    $permission = &$perms->getPermissionById(Horde::getFormData('cid'));
    if (!is_a($permission, 'PEAR_Error')) {
        $form = 'edit.inc';
    } elseif (($category = Horde::getFormData('category')) !== null) {
        $permission = &$perms->getPermission($category);
        if (!is_a($permission, 'PEAR_Error')) {
            $form = 'edit.inc';
        } elseif (Horde::getFormData('autocreate')) {
            $parent = Horde::getFormData('parent');
            $permission = &$perms->newPermission($category);
            $result = $perms->addPermission($permission, $parent);
            if (!is_a($result, 'PEAR_Error')) {
                $form = 'edit.inc';
            }
        }
    }
    break;

case 'editform':
    $permission = &$perms->getPermissionById(Horde::getFormData('cid'));
    if (is_a($permission, 'PEAR_Error')) {
        $notification->push(_("Attempt to edit a non-existent permission."), 'horde.error');
    } else {
        // Process default permissions.
        if (Horde::getFormData('default_show')) {
            $permission->addDefaultPermission(_PERMS_SHOW, false);
        } else {
            $permission->removeDefaultPermission(_PERMS_SHOW, false);
        }
        if (Horde::getFormData('default_read')) {
            $permission->addDefaultPermission(_PERMS_READ, false);
        } else {
            $permission->removeDefaultPermission(_PERMS_READ, false);
        }
        if (Horde::getFormData('default_edit')) {
            $permission->addDefaultPermission(_PERMS_EDIT, false);
        } else {
            $permission->removeDefaultPermission(_PERMS_EDIT, false);
        }
        if (Horde::getFormData('default_delete')) {
            $permission->addDefaultPermission(_PERMS_DELETE, false);
        } else {
            $permission->removeDefaultPermission(_PERMS_DELETE, false);
        }

        // Process guest permissions.
        if (Horde::getFormData('guest_show')) {
            $permission->addGuestPermission(_PERMS_SHOW, false);
        } else {
            $permission->removeGuestPermission(_PERMS_SHOW, false);
        }
        if (Horde::getFormData('guest_read')) {
            $permission->addGuestPermission(_PERMS_READ, false);
        } else {
            $permission->removeGuestPermission(_PERMS_READ, false);
        }
        if (Horde::getFormData('guest_edit')) {
            $permission->addGuestPermission(_PERMS_EDIT, false);
        } else {
            $permission->removeGuestPermission(_PERMS_EDIT, false);
        }
        if (Horde::getFormData('guest_delete')) {
            $permission->addGuestPermission(_PERMS_DELETE, false);
        } else {
            $permission->removeGuestPermission(_PERMS_DELETE, false);
        }

        // Process creator permissions.
        if (Horde::getFormData('creator_show')) {
            $permission->addCreatorPermission(_PERMS_SHOW, false);
        } else {
            $permission->removeCreatorPermission(_PERMS_SHOW, false);
        }
        if (Horde::getFormData('creator_read')) {
            $permission->addCreatorPermission(_PERMS_READ, false);
        } else {
            $permission->removeCreatorPermission(_PERMS_READ, false);
        }
        if (Horde::getFormData('creator_edit')) {
            $permission->addCreatorPermission(_PERMS_EDIT, false);
        } else {
            $permission->removeCreatorPermission(_PERMS_EDIT, false);
        }
        if (Horde::getFormData('creator_delete')) {
            $permission->addCreatorPermission(_PERMS_DELETE, false);
        } else {
            $permission->removeCreatorPermission(_PERMS_DELETE, false);
        }

        // Process user permissions.
        $u_names = Horde::getFormData('u_names');
        $u_show = Horde::getFormData('u_show');
        $u_read = Horde::getFormData('u_read');
        $u_edit = Horde::getFormData('u_edit');
        $u_delete = Horde::getFormData('u_delete');

        foreach ($u_names as $key => $user) {
            if (empty($user)) {
                continue;
            }

            if (!empty($u_show[$key])) {
                $permission->addUserPermission($user, _PERMS_SHOW, false);
            } else {
                $permission->removeUserPermission($user, _PERMS_SHOW, false);
            }
            if (!empty($u_read[$key])) {
                $permission->addUserPermission($user, _PERMS_READ, false);
            } else {
                $permission->removeUserPermission($user, _PERMS_READ, false);
            }
            if (!empty($u_edit[$key])) {
                $permission->addUserPermission($user, _PERMS_EDIT, false);
            } else {
                $permission->removeUserPermission($user, _PERMS_EDIT, false);
            }
            if (!empty($u_delete[$key])) {
                $permission->addUserPermission($user, _PERMS_DELETE, false);
            } else {
                $permission->removeUserPermission($user, _PERMS_DELETE, false);
            }
        }

        // Process group permissions.
        $g_names = Horde::getFormData('g_names');
        $g_show = Horde::getFormData('g_show');
        $g_read = Horde::getFormData('g_read');
        $g_edit = Horde::getFormData('g_edit');
        $g_delete = Horde::getFormData('g_delete');

        foreach ($g_names as $key => $group) {
            if (empty($group)) {
                continue;
            }

            if (!empty($g_show[$key])) {
                $permission->addGroupPermission($group, _PERMS_SHOW, false);
            } else {
                $permission->removeGroupPermission($group, _PERMS_SHOW, false);
            }
            if (!empty($g_read[$key])) {
                $permission->addGroupPermission($group, _PERMS_READ, false);
            } else {
                $permission->removeGroupPermission($group, _PERMS_READ, false);
            }
            if (!empty($g_edit[$key])) {
                $permission->addGroupPermission($group, _PERMS_EDIT, false);
            } else {
                $permission->removeGroupPermission($group, _PERMS_EDIT, false);
            }
            if (!empty($g_delete[$key])) {
                $permission->addGroupPermission($group, _PERMS_DELETE, false);
            } else {
                $permission->removeGroupPermission($group, _PERMS_DELETE, false);
            }
        }

        $permission->save();
        $notification->push(sprintf(_("Updated '%s'."), $permission->getShortName()), 'horde.success');
        $reload = true;
    }
    break;
}

$title = _("Permissions Administration");
require HORDE_TEMPLATES . '/common-header.inc';
require HORDE_TEMPLATES . '/admin/common-header.inc';
$notification->notify();
if (!empty($form)) {
    require HORDE_TEMPLATES . '/admin/perms/' . $form;
}

/* Get the perms tree. */
$nodes = $perms->_perms->get(CATEGORY_FORMAT_FLAT, -1, true);

/* Set up some node params. */
$current = Horde::getFormData('cid');
$icondir = array('icondir' => $registry->getParam('graphics'));
$perms_node = $icondir + array('icon' => 'perms.gif');
$add = Horde::applicationUrl('admin/perms.php?actionID=addchild');
$edit = Horde::applicationUrl('admin/perms.php?actionID=edit');
$delete = Horde::applicationUrl('admin/perms.php?actionID=delete');
$edit_img = Horde::img('edit.gif', _("Edit Permission"));
$delete_img = Horde::img('delete.gif', _("Delete Permission"));

/* Set up the tree. */
$tree = &Horde_Tree::singleton('category_tree', 'javascript');
$tree->setOption(array('border' => '0', 'class' => 'item', 'cellpadding' => '0', 'cellspacing' => '0', 'alternate' => true));

foreach ($nodes as $cid => $node) {
    $node_class = ($current == $cid) ? array('class' => 'selected') : array();
    if ($cid == -1) {
        $add_img = Horde::img('perms.gif', _("Add New Permission"));
        $add_link = Horde::link(Horde::addParameter($add, 'cid', $cid), _("Add New Permission")) . $add_img . '</a>';

        $base_node_params = $icondir + array('icon' => 'administration.gif');
        $tree->addNode($cid, null, _("All Permissions"), 0, true, $base_node_params + $node_class, array($add_link));
    } else {
        $add_img = Horde::img('perms.gif', _("Add Child Permission"));
        $add_link = Horde::link(Horde::addParameter($add, 'cid', $cid), _("Add Child Permission")) . $add_img . '</a>';
        $edit_link = Horde::link(Horde::addParameter($edit, 'cid', $cid), _("Edit Permission")) . $edit_img . '</a>';
        $delete_link = Horde::link(Horde::addParameter($delete, 'cid', $cid), _("Delete Permission")) . $delete_img . '</a>';

        $parent_id = $perms->_perms->getParent($node);
        $perms_extra = array($add_link, $edit_link, $delete_link);
        $tree->addNode($cid, $parent_id, Category::getShortName($node), substr_count($node, ':') + 1, false, $perms_node + $node_class, $perms_extra);
    }
}

$tree->renderTree();
require HORDE_TEMPLATES . '/common-footer.inc';
