<?php
/**
 * $Horde: horde/admin/user.php,v 1.26 2003/07/29 16:24:50 jwm Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__) . '/..');
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Menu.php';
require_once HORDE_BASE . '/lib/Form.php';
require_once HORDE_BASE . '/lib/Form/Renderer.php';

if (!Auth::isAdmin()) {
    Horde::fatal('Forbidden.', __FILE__, __LINE__);
}
$auth = &Auth::singleton($conf['auth']['driver']);

Horde::compressOutput();


if ($conf['signup']['approve']) {
    require_once HORDE_BASE . '/lib/Signup.php';
    $signup = &Horde_Signup::singleton();
}

$vars = &Horde_Form::getDefaultVars();
$addForm = &new Horde_Form($vars, _("Add a new user:"), 'adduser');
$addForm->_submit = _("Add user");
$addForm->_reset = _("Reset");

$vars->setVar('form', 'add');
$addForm->addHidden('', 'form', 'text', true, true);
$addForm->addVariable(_("Username"), 'user_name', 'text', true);
$addForm->addVariable(_("Password"), 'password', 'passwordconfirm', true, false, _("type the password twice to confirm"));

/* Use hooks get any extra fields for new accounts. */
$extra = Horde::callHook('_horde_hook_signup_getextra');
if (!is_a($extra, 'PEAR_Error') && !empty($extra)) {
    foreach ($extra as $field_name => $field) {
        $readonly = isset($field['readonly']) ? $field['readonly'] : null;
        $desc = isset($field['desc']) ? $field['desc'] : null;
        $field_params = isset($field['params']) ? $field['params'] : array();

        $addForm->addVariable($field['label'], 'extra[' . $field_name . ']', $field['type'], $field['required'], $readonly, $desc, $field_params);
    }
}


// Process forms. Use Horde::getPost() instead of Horde::getFormData()
// for a lot of the data because we want to actively ignore GET data
// in some cases - adding/modifying users - as a security precaution.
switch (Horde::getFormData('form')) {
case 'add':
    $addForm->validate($vars);

    if ($addForm->isValid() && $vars->getVar('formname') == 'adduser') {
        $addForm->getInfo($vars, $info);

        if (empty($info['user_name'])) {
            $notification->push(_("You must specify the username to add."), 'horde.error');
        } elseif (empty($info['password'])) {
            $notification->push(_("Passwords cannot be blank."), 'horde.error');
        } else {
            $credentials = array('password' => $info['password']);
            foreach ($info['extra'] as $field => $value) {
                $credentials[$field] = $value;
            }

            if (is_a($ret = $auth->addUser($info['user_name'], $credentials), 'PEAR_Error')) {
                $notification->push(sprintf(_("There was a problem adding '%s' to the system: %s"), $info['user_name'], $ret->getMessage()), 'horde.error');
            } else {
                $result = Horde::callHook('_horde_hook_signup_addextra',
                    array($info['user_name'], $info['extra']));
                if (is_a($result, 'PEAR_Error')) {
                    $notification->push(sprintf(_("Added '%s' to the system, but could not add additional signup information: %s."), $info['user_name'], $result->getMessage()), 'horde.warning');
                } else {
                    if (Horde::getFormData('removeQueuedSignup')) {
                        $signup->removeQueuedSignup($info['user_name']);
                    }
                    $notification->push(sprintf(_("Successfully added '%s' to the system."), $info['user_name']), 'horde.success');
                    $addForm->unsetVars($vars);
                }
            }
        }
    }
    break;

case 'remove_f':
    $f_user_name = Horde::getFormData('user_name');
    $remove_form = true;
    break;

case 'remove':
    $f_user_name = Horde::getFormData('user_name');
    if (empty($f_user_name)) {
        $notification->push(_("You must specify a username to remove."), 'horde.message');
    } elseif (Horde::getFormData('submit') !== _("Cancel")) {
        if (is_a($auth->removeUser($f_user_name), 'PEAR_Error')) {
            $notification->push(sprintf(_("There was a problem removing '%s' from the system."), $f_user_name), 'horde.error');
        } else {
            $notification->push(sprintf(_("Successfully removed '%s' from the system."), $f_user_name), 'horde.success');
        }
    }
    break;

case 'update_f':
    $f_user_name = Horde::getFormData('user_name');
    $update_form = true;
    break;

case 'update':
    $user_name_1 = Horde::getPost('user_name');
    $user_name_2 = Horde::getPost('user_name2', $user_name_1);
    $fullname = Horde::getPost('user_fullname');
    $email = Horde::getPost('user_email');

    if ($auth->hasCapability('update')) {
        $user_pass_1 = Horde::getPost('user_pass_1');
        $user_pass_2 = Horde::getPost('user_pass_2');

        if (empty($user_name_1)) {
            $notification->push(_("You must specify the username to update."), 'horde.error');
        } elseif (empty($user_pass_1) || empty($user_pass_2)) {
            // Don't update, but don't complain.
        } elseif ($user_pass_1 != $user_pass_2) {
            $notification->push(_("Passwords must match."), 'horde.error');
        } else {
            $result = $auth->updateUser($user_name_1,
                                        $user_name_2,
                                        array('password' => $user_pass_1));
        }
    }

    if (isset($result) && is_a($result, 'PEAR_Error')) {
        $notification->push(sprintf(_("There was a problem updating '%s': %s"),
                                    $user_name_1, $result->getMessage()), 'horde.error');
    } else {
        require_once HORDE_BASE . '/lib/Identity.php';
        $identity = &new Identity($user_name_1);
        $identity->setValue('fullname', $fullname);
        $identity->setValue('from_addr', $email);
        $identity->save();

        $notification->push(sprintf(_("Successfully updated '%s'"),
                                    $user_name_2), 'horde.success');
    }
    break;

case 'approve_f':
    $thisSignup = $signup->getQueuedSignup(Horde::getFormData('user_name'));
    $info = $thisSignup->getData();

    $vars->setVar('password',
                  array('original' => $info['password'],
                        'confirm' => $info['password']));
    unset($info['password']);
    $vars->setVar('extra', $info);

    $vars->setVar('removeQueuedSignup', true);
    $addForm->addHidden('', 'removeQueuedSignup', 'boolean', true);

    break;

case 'removequeued_f':
    $f_user_name = Horde::getFormData('user_name'); 
    $removequeued_form = true;
    break;

case 'removequeued':
    $result = $signup->removeQueuedSignup(Horde::getFormData('user_name'));
    if (is_a($result, 'PEAR_Error')) {
        $notification->push($result);
    } else {
        $notification->push('The signup request for ' . Horde::getFormData('user_name') . ' has been removed.');
    }
    break;
}


$title = _("User Administration");
require HORDE_TEMPLATES . '/common-header.inc';
require HORDE_TEMPLATES . '/admin/common-header.inc';
$notification->notify();

if ($auth->hasCapability('add')) {
    if (isset($update_form) && $auth->hasCapability('list')) {
        require_once HORDE_BASE . '/lib/Identity.php';
        $identity = &new Identity($f_user_name);
        require HORDE_TEMPLATES . '/admin/user/update.inc';
    } elseif (isset($remove_form) && $auth->hasCapability('list') && $auth->hasCapability('remove')) {
        require HORDE_TEMPLATES . '/admin/user/remove.inc';
    } elseif (isset($removequeued_form)) {
        require HORDE_TEMPLATES . '/admin/user/removequeued.inc';
    } else {
        require HORDE_TEMPLATES . '/admin/user/add.inc';
    }

    if ($conf['signup']['approve']) {
        require HORDE_TEMPLATES . '/admin/user/approve.inc';
    }
} else {
    require HORDE_TEMPLATES . '/admin/user/noadd.inc';
}

if ($auth->hasCapability('list')) {
    $users = $auth->listUsers();
    if (is_a($users, 'PEAR_Error')) {
        Horde::fatal($users, __FILE__, __LINE__);
    }
    require HORDE_TEMPLATES . '/admin/user/list.inc';
} else {
    require HORDE_TEMPLATES . '/admin/user/nolist.inc';
}

require HORDE_TEMPLATES . '/common-footer.inc';
