<?php
// $Horde: horde/config/prefs.php.dist,v 1.43 2003/08/11 23:04:09 jan Exp $

$prefGroups['language'] = array(
    'column' => _("Your Information"),
    'label' => _("Language"),
    'desc' => _("Set your preferred display language."),
    'members' => array('language'));

$prefGroups['display'] = array(
    'column' => _("Other Information"),
    'label' => _("Display Options"),
    'desc' => _("Set your startup application, color scheme, page refreshing, and other display options."),
    'members' => array('initial_application', 'show_last_login', 'theme', 'summary_refresh_time',
                       'show_sidebar', 'moz_sidebar', 'menu_view', 'widget_accesskey'));

$prefGroups['remote'] = array(
    'column' => _("Other Information"),
    'label' => _("Remote Servers"),
    'desc' => _("Set up remote servers that you want to access from your portal."),
    'url' => 'rpcsum.php');


// user language
$_prefs['language'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => _("Select your preferred language:")
);

// color theme
$_prefs['theme'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => _("Select your color scheme.")
);

$_prefs['summary_refresh_time'] = array(
    'value' => 300,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(0 => _("Never"),
                    30 => _("Every 30 seconds"),
                    60 => _("Every minute"),
                    300 => _("Every 5 minutes"),
                    900 => _("Every 15 minutes"),
                    1800 => _("Every half hour")),
    'desc' => _("Refresh Portal View:")
);

$_prefs['show_sidebar'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => true,
    'type' => 'checkbox',
    'desc' => sprintf(_("Show the %s Menu on the left?"), $GLOBALS['registry']->getParam('name', 'horde'))
);

// link to the identities ui
$_prefs['moz_sidebar'] = array(
    'type' => 'link',
    'xurl' => sprintf('javascript:if (window.sidebar && window.sidebar.addPanel) window.sidebar.addPanel(\'%s\', \'%s\', \'%s\'); else alert(\'%s\');',
                      $GLOBALS['registry']->getParam('name', 'horde'),
                      Horde::url($GLOBALS['registry']->getParam('webroot', 'horde') . '/util/sidebar.php', true, -1),
                      Horde::url($GLOBALS['registry']->getParam('webroot', 'horde') . '/prefs.php', true, -1),
                      addslashes(_("Couldn't find the Mozilla Sidebar. Make sure the sidebar is open."))),
    'desc' => sprintf(_("Add the %s Menu as a Mozilla Sidebar"), $GLOBALS['registry']->getParam('name', 'horde'))
);

$_prefs['menu_view'] = array(
    'value' => 'both',
    'locked' => false,
    'shared' => true,
    'type' => 'enum',
    'enum' => array('text' => _("Text Only"),
                    'icon' => _("Icons Only"),
                    'both' => _("Icons with text")),
    'desc' => _("Menu mode:")
);

// perform maintenance operations?
$_prefs['do_maintenance'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => true,
    'type' => 'checkbox',
    'desc' => _("Perform maintenance operations on login?")
);

// confirm when doing maintenance operations? If false (0), they will
// be performed with no input from/check with the user.
$_prefs['confirm_maintenance'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => true,
    'type' => 'checkbox',
    'desc' => _("Ask for confirmation before doing maintenance operations?")
);

// what application should we go to after login?
$_prefs['initial_application'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => sprintf(_("What application should %s display after login?"), $GLOBALS['registry']->getParam('name'))
);

$_prefs['widget_accesskey'] = array(
    'value' => true,
    'locked' => false,
    'shared' => true,
    'type' => 'checkbox',
    'desc' => _("Should access keys be defined for most links?")
);

// the layout of the portal page.
$_prefs['portal_layout'] = array(
    'value' => 'a:0:{}',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit',
    'desc' => 'Layout of portal page'
);

// the remote servers.
$_prefs['remote_summaries'] = array(
    'type' => 'implicit',
    'value' => 'a:0:{}',
    'locked' => false,
    'shared' => false
);

// last login time of user
// value is a serialized array of the UNIX timestamp of the last
// login, and the host that the last login was from.
$_prefs['last_login'] = array(
    'value' => 'a:0:{}',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit'
);

// show the last login time of user
// a value of 0 = no, 1 = yes
$_prefs['show_last_login'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => true,
    'type' => 'checkbox',
    'desc' => _("Show last login time when logging in?")
);

// Personal Information preferences

// default identity
// Set locked to true if you don't want the users to have multiple identities.
$_prefs['default_identity'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// identities array
// Don't change anything here.
$_prefs['identities'] = array(
    'value' => 'a:0:{}',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// user full name for From: line
$_prefs['fullname'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// user preferred email address for From: line
$_prefs['from_addr'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');
