<?php

require_once HORDE_BASE . '/lib/MIME/Viewer/tnef.php';

/**
 * The IMP_MIME_Viewer_tnef class allows MS-TNEF attachments to be displayed.
 *
 * $Horde: imp/lib/MIME/Viewer/tnef.php,v 1.15 2003/07/05 22:16:47 jan Exp $
 *
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.15 $
 * @since   IMP 4.0
 * @package horde.mime.viewer
 */
class IMP_MIME_Viewer_tnef extends MIME_Viewer_tnef {

    /**
     * The contentType of the attachment.
     *
     * @var string $_contentType
     */
    var $_contentType = 'application/octet-stream';


    /**
     * Render out the currently set contents.
     *
     * @access public
     *
     * @param array $params  An array with a reference to a MIME_Contents
     *                       object.
     *
     * @return string  Either the list of tnef files or the data of an
     *                 individual tnef file.
     */
    function render($params)
    {
        $contents =& $params[0];

        require_once HORDE_BASE . '/lib/Compress.php';

        $text = '';

        /* Get the data from the attachment. */
        $tnef = &Horde_Compress::singleton('tnef');
        $tnefData = $tnef->decompress($this->mime_part->getContents());

        /* Display the requested file. Its position in the $tnefData array
           can be found in 'tnef_attachment'. */
        if (Horde::getFormData('tnef_attachment')) {
            $tnefKey = Horde::getFormData('tnef_attachment') - 1;
            /* Verify that the requested file exists. */
            if (array_key_exists($tnefKey, $tnefData)) {
                $text = $tnefData[$tnefKey]['stream'];
                if (empty($text)) {
                    $text = '<pre>' . _("Could not extract the requested file from the MS-TNEF attachment.") . '</pre>';
                } else {
                    $this->mime_part->setName($tnefData[$tnefKey]['name']);
                    $this->mime_part->setType($tnefData[$tnefKey]['type'] . '/' . $tnefData[$tnefKey]['subtype']);
                }
            } else {
                $text = '<pre>' . _("The requested file does not exist in the MS-TNEF attachment.") . '</pre>';
            }
        } else {
            if (empty($tnefData)) {
                $text = '<pre>' . _("No attachments found.") . '</pre>';
            } else {
                foreach ($tnefData as $key => $data) {
                    $link = $contents->linkView($this->mime_part, 'view_attach', $data['name'], array('jstext' => sprintf(_("View %s"), $data['name']), 'viewparams' => array('tnef_attachment' => ($key + 1))));
                    $text .= _("Attached File:") . '&nbsp;&nbsp;' . $link . '&nbsp;&nbsp;(' . $data['type'] . '/' . $data['subtype'] . ")<br />\n";
                }
            }
        }

        return $text;
    }

    /**
     * Return the content-type
     *
     * @access public
     *
     * @return string  The content-type of the output.
     */
    function getType()
    {
        if (Horde::getFormData('tnef_attachment')) {
            return $this->_contentType;
        } else {
            return 'text/html';
        }
    }

}
