<?php
/**
 * The Horde_Form_Renderer_rows class provides a Horde_Form Renderer
 * plug-in that renders forms with multiple rows.
 *
 * $Horde: horde/lib/Form/Renderer/rows.php,v 1.13 2003/04/27 00:27:52 chuck Exp $
 *
 * Copyright 2002-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.13 $
 * @package horde.form
 */
class Horde_Form_Renderer_rows extends Horde_Form_Renderer {

    var $_rows = 1;
    var $_cols;

    function render(&$form, &$vars, $active)
    {
        // No custom renderer - use the default one.
        $variables = &$form->getVariables();
        $this->_cols = count($variables);

        // Check for a form token error.
        if (($tokenError = $form->getError('__formToken')) !== null) {
?><tr class="item0" valign="top"><td colspan="<?php echo $this->_cols ?>"><span class="form-error"><?php echo $tokenError ?></span></td></tr><?php
        }

        $this->_renderColumnHeaders($variables, $form);
        $this->_renderHiddenVars($form, $vars, null);

        for ($i = 0; $i < $this->_rows; $i++) {
            $this->_beginRow();
            $first = null;
            foreach ($variables as $var) {
                if (is_null($first)) {
                    $this->_renderHiddenVars($form, $vars, $i);
                    $first = false;
                }

                $type = $var->getTypeName();
                switch ($type) {
                case 'header':
                case 'description':
                case 'spacer':
                    break;

                default:
                    $format = (!$active || $var->isReadonly()) ? 'Display' : 'Input';
                    $method = "_renderVar${format}_$type";

                    $this->_beginCell();

                    if (@method_exists($this, $method) == false) {
                        $method = "_renderVar${format}Default";
                    }

                    $this->$method($form, $var, $vars, $i);
                    $this->_endCell();
                }
            }
            $this->_endRow();
        }
    }

    function _beginCell()
    {
?><td class="item"><?php
    }

    function _endCell()
    {
?></td><?php
    }

    function _beginRow()
    {
?><tr><?php
    }

    function _renderHiddenVars($form, $vars, $i = null)
    {
        foreach ($form->_hiddenVariables as $var) {
            if (is_null($i) && !$var->isArrayVal()) {
?><input type="hidden" name="<?php echo $var->getVarName() ?>" value="<?php echo $var->getValue($vars) ?>" /><?php
            } elseif (!is_null($i) && $var->isArrayVal()) {
?><input type="hidden" name="<?php echo $var->getVarName() ?>" value="<?php echo $var->getValue($vars, $i) ?>" /><?php
            }
        }
    }

    function _endRow()
    {
?></tr><?php
    }

    function _renderSubmit($submit)
    {
?><tr><td>&nbsp;</td></tr><tr><td colspan="<?php echo $this->_cols ?>" class="header"><input class="button" name="submitbutton" type="submit" value="<?php echo $submit ?>" /></td></tr><?php
    }

    function _renderVarInput_boolean(&$form, &$var, &$vars, $index = null)
    {
?><input type="checkbox" name="<?php echo str_replace('[]', '[' . $index . ']', $var->getVarName()) ?>"<?php echo $var->getValue($vars, $index) ? ' checked="checked"' : '' ?> /><?php
    }

    function _renderColumnHeaders($variables, $form)
    {
?><tr>
<?php foreach ($variables as $var): ?>
<?php
        $message = $form->getError($var);
        $isvalid = empty($message);

        $req = $var->isRequired() ? '<span class="form-error">' . $this->_requiredMarker . '</span> ' : '';
        $msg = $isvalid ? '' : '<br /><span class="smallheader"><span class="form-error">' . ucfirst($message) . '</span></span>';
?>
<td class="header" valign="top"><?php echo $req . $var->getHumanName(); if ($var->hasDescription()) { echo '<br /><span class="smallheader">' . $var->getDescription() . '</span>'; } echo $msg; ?>
<?php if ($var->hasAction()): ?><script language="JavaScript" type="text/javascript">
<!--
<?php $var->_action->printJavaScript() ?>
// -->
</script>
<?php endif; ?></td>
<?php endforeach; ?>
</tr><?php
    }

}
