<?php
/**
 * The MIME_Viewer_text class renders out plain text with URLs made
 * into hyperlinks.
 *
 * $Horde: horde/lib/MIME/Viewer/plain.php,v 1.8 2003/01/19 21:23:05 slusarz Exp $
 *
 * Copyright 1999-2003 Anil Madhavapeddy <anil@recoil.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @version $Revision: 1.8 $
 * @since   Horde 1.3
 * @package horde.mime.viewer
 */
class MIME_Viewer_plain extends MIME_Viewer {

    /**
     * Render out the contents.
     *
     * @access public
     *
     * @param optional array $params  Any parameters the Viewer may need.
     *
     * @return string  The rendered contents.
     */
    function render($params = array())
    {
        include_once HORDE_BASE . '/lib/Text.php';

        return Text::toHTML($this->mime_part->getContents(), TEXT_HTML_MICRO, null, null);
    }

    /**
     * Return the MIME content type of the rendered content.
     *
     * @access public
     *
     * @return string  The content type of the output. 
     */
    function getType()
    {
        return 'text/html';
    }

}
