<?php
/**
 * Horde external API interface.
 *
 * This file defines Horde's external API interface. Other
 * applications can interact with Horde through this API.
 *
 * $Horde: horde/lib/api.php,v 1.13 2003/07/31 03:29:48 chuck Exp $
 */

$_services['admin_list'] = array(true);

/**
 * General API for deleting Horde_Links
 */
$_services['deleteLink'] = array(
    'link' => '%application%/deletelink.php?' .
    'from_application=|from_application|' .
    ini_get('arg_separator.output') . 'from_parameters=|from_parameters|' .
    ini_get('arg_separator.output') . 'to_application=|to_application|' .
    ini_get('arg_separator.output') . 'to_parameters=|to_parameters|' .
    ini_get('arg_separator.output') . 'link_type=|link_type|' .
    ini_get('arg_separator.output') . 'return_url=|url|');

$_services['listApps'] = array(
    'args' => array('filter'),
    'type' => 'array');

$_services['listAPIs'] = array(
    'args' => array(),
    'type' => 'array');

$_services['block'] = array(
    'args' => array('type', 'params'),
    'type' => 'array');

$_services['blocks'] = array(
    'args' => array(),
    'type' => 'array');


function &_horde_block($type, $params)
{
    @define('HORDE_BASE', dirname(__FILE__) . '/..');
    require_once HORDE_BASE . '/lib/base.php';

    $class = 'Horde_Block_' . $type;
    require_once HORDE_BASE . '/lib/Block/' . $type . '.php';
    return new $class($params);
}

function _horde_blocks()
{
    require_once HORDE_BASE . '/lib/Registry.php';
    $registry = &Registry::singleton();

    $blocks = array();
    if (is_array($registry->applets)) {
        foreach ($registry->applets as $applet => $params) {
            $blocks[$applet] = array('name' => $params['name'],
                                     'params' => array($applet => $params));
        }
    }
    return $blocks;
}

function _horde_admin_list()
{
    return array('users' => array(
                     'link' => '%application%/admin/user.php',
                     'name' => _("Users"),
                     'icon' => 'user.gif'),
                 'groups' => array(
                     'link' => '%application%/admin/groups.php',
                     'name' => _("Groups"),
                     'icon' => 'group.gif'),
                 'perms' => array(
                     'link' => '%application%/admin/perms.php',
                     'name' => _("Permissions"),
                     'icon' => 'perms.gif'),
                 'phpshell' => array(
                     'link' => '%application%/admin/phpshell.php',
                     'name' => _("PHP Shell"),
                     'icon' => 'shell.gif'),
                 'sqlshell' => array(
                     'link' => '%application%/admin/sqlshell.php',
                     'name' => _("SQL Shell"),
                     'icon' => 'sql.gif'),
                 'cmdshell' => array(
                     'link' => '%application%/admin/cmdshell.php',
                     'name' => _("Command Shell"),
                     'icon' => 'shell.gif'),
                 );
}

function _horde_listApps($filter = null)
{
    return $GLOBALS['registry']->listApps($filter);
}

function _horde_listAPIs()
{
    return $GLOBALS['registry']->listAPIs();
}
