<?php

require_once HORDE_BASE . '/lib/iCalendar.php';

class Moment_Storage_kolab extends Moment_Storage {

    var $_params = array();
    var $_server;
    var $_folder;

    function Moment_Storage_kolab($user, $params = array())
    {
        $this->_user = $user;

        $this->_params = $params;
        $this->_server = array_key_exists('server', $params) ? $params['server'] : 'localhost';
        $this->_folder = array_key_exists('folder', $params) ? $params['folder'] : '/freebusy/';
    }

    function search($email, $private_only = false)
    {
        $vfb = Kolab::getFreeBusy($this->_server, $this->_folder, $email);
        if (PEAR::isError($vfb)) return $vfb;

        $cal = new Horde_iCalendar;
        $cal->parsevCalendar($vfb);
        return $cal;
    }

    function store($email, $vfb, $public = false)
    {
        $vfbfile = $vfb->exportvCalendar();
        return Kolab::storeFreeBusy($this->_server, $this->_folder, $vfbfile);
    }

}
