<?php
/**
 * $Horde: moment/lib/base.php,v 1.10 2003/04/20 20:51:10 chuck Exp $
 *
 * Copyright 2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * Freebusy base inclusion file.
 *
 * This file brings in all of the dependencies that every Freebusy
 * script will need and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Freebusy
@define('MOMENT_BASE', dirname(__FILE__) . '/..');

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once HORDE_BASE . '/lib/Help.php';
require_once HORDE_BASE . '/lib/Template.php';

// iCalendar
require_once HORDE_BASE . '/lib/iCalendar.php';
Horde_iCalendar::includeComponentClasses();

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('moment');
$conf = &$GLOBALS['conf'];
@define('MOMENT_TEMPLATES', $registry->getParam('templates'));

// PEAR date class
require_once 'Date/Calc.php';

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = &new Browser();

// Redirect the user to the Horde login page if they haven't authenticated.
if (!Auth::isAuthenticated() && !$registry->allowGuests()) {
    Horde::authenticationFailureRedirect();
}

// Moment base libraries.
require_once MOMENT_BASE . '/lib/Moment.php';
require_once MOMENT_BASE . '/lib/Driver.php';

// Notification system.
require_once HORDE_BASE . '/lib/Notification.php';
$notification = &Notification::singleton();
$notification->attach('status');

$print_view = false;
