<?php
/*
 * Nag Configuration File
 *
 * This file contains global configuration settings for Nag. Values may be
 * safely edited by hand. Use conf.php.dist as a reference.
 *
 * Default user preferences are defined in 'prefs.php'.
 *
 * Strings should be enclosed in 'quotes'.
 * Integers should be given literally (without quotes).
 * Boolean values may be 'true' or 'false'.
 *
 * $Horde: nag/config/conf.php.dist,v 1.17.2.3 2002/10/15 16:52:41 jan Exp $
 */


/**
 ** Task List Settings
 **/

$conf['list']['date_format'] = '%x %X';


/**
 ** Task View Settings
 **/

$conf['view']['date_format'] = '%x';
$conf['view']['time_format'] = '%X';


/**
 ** Storage System Settings
 **/

// What storage driver should we use?  Valid values are 'sql'.
$conf['storage']['driver'] = 'kolab';

// Any parameters that the storage driver needs. This includes
// database or ldap server, username/password to connect with, etc.
// Below is an example configuration for an sql driver, in this case
// MySQL.
$conf['storage']['params'] = array();
$conf['storage']['params']['server'] = $conf['server']['name'];
$conf['storage']['params']['folder'] = 'INBOX/Tasks';
// $conf['storage']['params']['phptype'] = 'mysql';
// $conf['storage']['params']['hostspec'] = 'localhost';
// $conf['storage']['params']['username'] = 'horde';
// $conf['storage']['params']['password'] = '*****';
// $conf['storage']['params']['database'] = 'horde';
// $conf['storage']['params']['table'] = 'nag_tasks';


/**
 ** Menu settings
 **/

// Should we display a Print link in the Horde application
// menus?
$conf['menu']['print'] = true;

// This is an array of applications (using the names defined in
// horde/config/registry.php) to include links to in the menubar. An
// example providing a link to Turba (an addressbook program) would
// be: $conf['menu']['apps'] = array('turba');
$conf['menu']['apps'] = array();
