<?php
/**
 * Nag external API interface.
 *
 * This file defines Nag's external API interface.  Other applications can
 * interact with Nag through this API.
 *
 * $Horde: nag/lib/api.php,v 1.45 2003/06/04 03:18:34 chuck Exp $
 */

$_services['list'] = array(
    'args' => array('sortby', 'sortdir'),
    'type' => 'array');

$_services['search'] = array(
    'link' => '%application%/search.php');

$_services['show'] = array(
    'link' => '%application%/view.php?task=|task|' . ini_get('arg_separator.output') . 'tasklist=|tasklist|');

$_services['add'] = array(
    'args' => array('name', 'description', 'due'),
    'type' => 'integer');

$_services['block'] = array(
    'args' => array('type', 'params'),
    'type' => 'array');

$_services['blocks'] = array(
    'args' => array(),
    'type' => 'array');

/**
 * API's for linking Nag tasks into other applications.
 */
$_services['linkParameters'] = array(
    'args' => array(),
    'type' => 'array');

$_services['getLinkDescription'] = array(
    'args' => _nag_linkParameters(),
    'type' => 'string');

$_services['getLinkSummary'] = array(
    'args' => _nag_linkParameters(),
    'type' => 'string');

$_services['addLink'] = array(
    'link' => '%application%/addlink.php?link_type=|link_type|' .
    ini_get('arg_separator.output') . 'from_application=|from_application|' . 
    ini_get('arg_separator.output') . 'from_parameters=|from_parameters|' .
    ini_get('arg_separator.output') . 'url=|url|');

$_services['followLink'] = array(
    'link' => '%application%/view.php?task=|task|' . ini_get('arg_separator.output') . 'tasklist=|tasklist|');

$_services['listCategories'] = array(
    'args' => array('tasklist'),
    'type' => 'array');

$_services['formatCategory'] = array(
    'args' => array('categoryID', 'tasklist'),
    'type' => 'string');

$_services['getListTypes'] = array(
    'args' => array(),
    'type' => 'array');

$_services['listAs'] = array(
    'args' => array('type'),
    'type' => 'array');


function _nag_linkParameters()
{
    return array('tasklist', 'task');
}

function _nag_formatCategory($categoryID = 0, $tasklist = null)
{
    require_once dirname(__FILE__) . '/base.php';
    global $conf;

    if (!isset($conf['storage']['driver']) ||
        !isset($conf['storage']['params'])) {
        return PEAR::raiseError('Not configured');
    }

    if (!array_key_exists($tasklist, Nag::listTasklists(false, _PERMS_READ))) {
        return PEAR::raiseError(_("Permission Denied"));
    }
    return Nag::formatCategory($categoryID, $tasklist);
}

function _nag_listCategories($tasklist = null)
{
    require_once dirname(__FILE__) . '/base.php';
    global $conf;

    if (!isset($conf['storage']['driver']) ||
        !isset($conf['storage']['params'])) {
        return PEAR::raiseError('Not configured');
    }

    if (!array_key_exists($tasklist, Nag::listTasklists(false, _PERMS_READ))) {
        return PEAR::raiseError(_("Permission Denied"));
    }
    return Nag::listCategories($tasklist);
}

function &_nag_block($type, $params) 
{
    @define('NAG_BASE', dirname(__FILE__) . '/..');
    require_once NAG_BASE . '/lib/base.php';

    switch ($type) {
    case 'summary':
        require_once NAG_BASE . '/lib/Block/summary.php';
        return new nag_summary_Block($params);
    }

    return new Horde_Block();
}

function _nag_blocks()
{
    return array('summary' => array('name' => _("Tasks Summary"),
                                    'type' => 'summary',
                                    'params' => array()));
}

function _nag_list($sortby = null, $sortdir = null)
{
    global $conf, $prefs;
    require_once dirname(__FILE__) . '/base.php';

    if (!isset($sortby)) {
        $sortby = $prefs->getValue('sortby');
    }
    if (!isset($sortdir)) {
        $sortdir = $prefs->getValue('sortdir');
    }

    return Nag::listTasks($sortby, $sortdir);
}

function _nag_add($name = '', $description = '', $due = 0)
{
    global $conf;
    require_once dirname(__FILE__) . '/base.php';

    /* Create a Nag_Driver instance. */
    require_once NAG_BASE . '/lib/Driver.php';
    $storage = &Nag_Driver::singleton($conf['storage']['driver'],
                                      Auth::getAuth(), $conf['storage']['params']);
    $storage->retrieve();

    /* Add the new task. */
    $result = $storage->addTask($name, $description, $due);
    if ($result >= 0) {
        $result = $storage->store();
    }

    return $result;
}

function _nag_getLinkDescription($tasklist_id, $task_id)
{
    require_once dirname(__FILE__) . '/base.php';

    if (!array_key_exists($tasklist_id, Nag::listTasklists(false, _PERMS_READ))) {
        return PEAR::raiseError(_("Permission Denied"));
    }

    $task = Nag::getTask($tasklist_id, $task_id);
    if (empty($task['desc'])) {
        return '<b>' . $task['name'] . '</b>';
    }
    return '<b>' . $task['name'] . '</b>:&nbsp;' . $task['desc'];
}

function _nag_getLinkSummary($tasklist_id, $task_id)
{
    require_once dirname(__FILE__) . '/base.php';

    if (!array_key_exists($tasklist_id, Nag::listTasklists(false, _PERMS_READ))) {
        return PEAR::raiseError(_("Permission Denied"));
    }

    $task = Nag::getTask($tasklist_id, $task_id);
    if ($task) {
        return $task['name'];
    } else {
        return _("Task not found.");
    }
}

function _nag_getListTypes()
{
    return array('taskHash' => true);
}

function _nag_listAs($type)
{
    require_once dirname(__FILE__) . '/base.php';
    return Nag::listTasks();
}
