﻿# C++/WinRT Change Log

## October 2017 release for Fall Creators Update SDK (16299) and Visual Studio 2017 v15.3

This release provides a projection refresh for the [Fall Creators Update SDK](https://developer.microsoft.com/en-us/windows/downloads/windows-10-sdk), which is included with Visual Studio 2017 v15.4.

## August 2017 release for Spring Creators Update SDK (15063) and Visual Studio 2017 v15.3

This release removes the Anniversary Update (10.0.14393.0) headers and now requires Visual Studio 2017 v15.3 or later.  If you require the older headers or support for Visual Studio 2015, you can sync to a previous commit such as the
[February 2017 Release](https://github.com/Microsoft/cppwinrt/tree/february_2017_release).


### Breaking Changes
For consistency with threading APIs, thread_context has been renamed:
* thread_context -> apartment_context

### What's new

#### C++17
This update takes advantage of many improvements in `C++17` to simplify and improve the quality of the library. These are only possible thanks to much hard work on the part of the Visual C++ team and delivered in the Visual Studio 2017 15.3 release. These include:
 
  * Simpler static_assert
  * Nested namespace definitions
  * constexpr functions
  * if constexpr
  * optional
  * string_view
  * __has_include
  * Logical operator traits

#### Coroutines
The base library has been updated to reflect the latest coroutine draft standard as we continue to track the progress of this new language feature.

#### Clang
While Visual C++ continues to be our primary target, we use Clang as our secondary compiler to ensure standard conformance. Many small changes have been made in this update to support Clang builds and to fix correctness bugs that were only found with Clang builds.

#### Support for \[\[deprecated]]
The C++/WinRT language projection now reports on any deprecated Windows APIs via the standard \[\[deprecated]] attribute. For example, the following code will produce a C++ compiler error:
```C++
using namespace Windows::Storage::Pickers;
 
FileOpenPicker::ResumePickSingleFileAsync();
error C4996: 'winrt::Windows::Storage::Pickers::FileOpenPicker::ResumePickSingleFileAsync': Instead, use PickSingleFileAsync
```
Note that with the VC /sdl switch, this will generate an error C4996 as above.  To treat this as a warning that can be disabled, turn off the /sdl switch.

#### Improved support for WinRT error origination, propagation, chaining, and extensibility
This is largely an improvement to enable the Windows Runtime to produce more coherent crash dumps for postmortem debugging, but a few small changes inside the C++/WinRT exception type – winrt::hresult_error – have also been made to provide improved error messages during live debugging. The debugger team has also done work to make it easier to debug errors that occur in a brokered process.

#### Improved code gen (fewer instructions) and build throughput
The C++/WinRT compiler now produces considerably smaller headers by omitting a lot of type information from internal type projections that weren’t adding any value and were only causing the C++ compiler to do more work unnecessarily. In addition, the code we generate for a few input parameter bindings now results in noticeably fewer CPU instructions, resulting in small binaries. This includes high-traffic types such as strings and collections.

#### Support for compile-time generic GUID calculation
This is one of the biggest improvements in this update. Previously, any generic interface that was not defined in metadata lacked a specialization informing the projection of the GUID for that particular interface specialization. For example:
```C++ 
using namespace Windows::Foundation::Collections;

IMap<hstring, float> map;
```
If you happened to use the map and the compiler could not find an appropriate specialization providing the GUID, a cryptic compiler error was produced. Even if you could recognize the problem, determining the correct GUID to assign to the specialization was non-trivial and largely undocumented. This update now codifies the algorithm for determining the GUID for arbitrary specializations purely in constexpr functions that C++/WinRT uses internally to compute GUIDs at compile-time as needed. This solves what is likely our top usability concern with C++/WinRT. It also provides a great stress test for the compiler.

#### Simplified ABI interop
As we’ve improved the quality and maturity of the projection, we’ve also reduced the need for a developer to access the ABI. As such, the ABI generated by the C++/WinRT compiler is no longer something that we would like you to use. There simply isn’t any good reason for that and it allows us to optimize it for our own internal use to give you the fastest possible builds.

While the C++/WinRT language projection is designed to provide no-compromise access to the modern Windows API, we recognize that there are instances where you need to interop with other libraries or tools that may not support C++/WinRT directly. The base library (winrt/base.h) provides a set of helper functions that assist in converting between C++/WinRT types and their equivalents in other language projections such as C++/CX or the Windows SDK headers produced by the MIDL compiler. Although we don’t directly support interop with other language projections, to avoid cross-dependencies, you can use the following helper functions to streamline the process as you migrate your code to C++/WinRT.

See the [Interoperability Helper Functions](./Docs/Interoperability%20Helper%20Functions.md) document for all the details and examples.


#### Simplified and more intuitive parameter binding for strings and collections
Strings, arrays, and collections all present unique challenges to any language projection. C++/WinRT is unique in that it provides blazingly fast performance for all three, avoiding copies, and minimizing machine instructions at call sites. We also provide natural conversion support for std::wstring_view and most C++ standard library containers without introducing copies.

#### Removal of implementation details from winrt namespace
We have steadily cleaned up the base library to avoid leaking any unnecessary implementation details. The winrt namespace is now a lot leaner, exposing only those functions and types that you could conceivably need to use in order to make the most of C++/WinRT. Anything that begins with impl_ or is within the winrt::impl namespace should be considered an implementation detail subject to change at any time. We do not consider it a breaking change to rename or remove an implementation detail and that includes the use of the internal ABI used by C++/WinRT.

As soon as the Visual C++ compiler resolves a few more bugs, we plan to provide C++/WinRT as a C++ module. At that point, all of these implementation details will physically be unavailable as they will not be epxorted by the C++/WinRT module.

#### Automatic object identity and hashing support
We now provide intelligent object identy and hashing support for all C++/WinRT types so that you can easily use them as keys in standard containers like std::map and std::unordered_map.

#### Optimized agility implementation
C++/WinRT favors agile object implementations and so should you. We make it very simple to create agile objects and also provide the leanest possible implementation, reducing the overhead of (automatically) implementing IAgileObject and IMarshal to the point where instances of C++/WinRT types are considerably smaller than their WRL and C++/CX counterparts.

#### Optimized delegate implementation
WinRT delegates are likewise optimized for space so that they may be safely used as ABI-portable callbacks without much concern for their overhead.

#### Support for derived classes and binary composability in winrt::implements
The implements class template remains at the heart of much of the C++/WinRT language projection when it comes to authoring types. It has received many improvements to make it easier to implement complex WinRT types and particularly in support for composable types, such as those required by the Windows.UI APIs.

#### Default implementation of GetRuntimeClassName
You may notice that objects created with winrt::implements now provide a default implementation of GetRuntimeClassName that returns the metadata name for the first interface being implemented. In many cases, this is sufficient to support the runtime, but you can of course override this with your own class names as necessary.

#### Support for disabling factory caching
C++/WinRT provides the fastest factory caching of any language projection. However, due to the unfortunate relationship between COM statics, the CRT, and the OS loader it is entirely possible that those statics are not torn down correctly when C++/WinRT is used within a DLL. We now provide an option to disable caching in those cases. We are also investigating how we might finally solve the problem of COM statics once and for all.

#### Experimental natvis support
The experimental natvis support makes it easier to interrogate C++/WinRT types from within a debugger.  See [Debug Visualization - Experimental](./Docs/Debug%20Visualization%20-%20Experimental.md) for details on how to use this support.

### Summary
Those are just a few highlights for now. We have worked hard to build a world-class language projection for the systems programmer and the app developer alike. Our goal is to enable C++ developers to write beautiful high-performance apps and components with incredible ease.


## February 2017 release for Windows Anniversary SDK (14393)

### Breaking Changes

#### Renames
To prevent name collisions, ABI accessors in the winrt namespace have been suffixed with "_abi":
* get -> get_abi
* put -> put_abi
* attach -> attach_abi
* copy_from -> copy_from_abi
* copy_to -> copy_to_abi
* detach -> detach_abi

For consistency with the C++17 standard’s wstring_view, the hstring and array read-only view types have been renamed:
* hstring_ref -> hstring_view
* array_ref -> array_view

To clarify their purpose and avoid name collisions, apartment initialization artifacts have been renamed:
* initialize_type -> apartment_type
* initialize -> init_apartment
* uninitialize -> uninit_apartment
 
#### Relocations
Artifacts have been relocated to more appropriate namespaces
* Implementation details have been moved from winrt to winrt\::impl, such as struct handle, abi_arg_in, and abi_arg_out
* Foundational types have been moved from winrt\::Windows to winrt\::Windows\::Foundation, such as IUnknown, IInspectable, IWeakReference, IWeakReferenceSource, and TrustLevel

#### Deprecated
The WinRT \[deprecated\] attribute is now propagated to the C++ \[\[deprecated\]\] attribute in projected artifacts.  Referencing these artifacts will now cause the VC compiler to emit a C4996 warning, which may break compilation.

#### Usability Improvements
A few breaking changes have been made to improve usability of the projection:
* Removal of IUnknown::operator->(): callers should use get_abi() instead.
* Windows\::Foundation\::IReference, which represents a nullable type, is now projected to winrt\::optional, which maps more closely to std\::optional usage.
* To support efficient (non-copying) passing of collection input parameters, conversion from standard collections has been redesigned.  The lvalue-reference converting (copying) constructors have been removed from projected interfaces (IIterable, IVectorView, IVector, IMapView, IMap).  Instead, the projection is now implemented with winrt view types (iterable, map_view, vector_view) providing rvalue-reference converting (moving) constructors.
