/**
 * OpenAL cross platform audio library
 * Copyright (C) 1999-2000 by authors.
 * This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the
 *  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA  02111-1307, USA.
 * Or go to http://www.gnu.org/copyleft/lgpl.html
 */

#include "include\alMain.h"
#include "include\alError.h"
#include "include\alEax.h"
#include "include\eax.h"

ALAPI ALenum ALAPIENTRY EAXGet(const GUID *propertySetID,ALuint property,ALuint source,ALvoid *value,ALuint size)
{
	LPKSPROPERTYSET EaxPropertySet;
	ALuint returnsize;
	ALsource *Source;

	if (alIsSource(source))
	{
		Source=((ALsource *)source);
		if (IDirectSound3DBuffer_QueryInterface((LPDIRECTSOUND3DBUFFER)Source->uservalue2,&IID_IKsPropertySet,(LPUNKNOWN *)&EaxPropertySet)==DS_OK)
		{
			IKsPropertySet_Get(EaxPropertySet,propertySetID,property,NULL,0,value,size,&returnsize);
			IKsPropertySet_Release(EaxPropertySet);
		}
	}
	else
	{
		EaxPropertySet=alcGetContextsDevice(alcGetCurrentContext())->DSpropertyset;
		if (EaxPropertySet)
		{
			IKsPropertySet_Get(EaxPropertySet,propertySetID,property,NULL,0,value,size,&returnsize);
		}
	}
	return AL_NO_ERROR;
}

ALAPI ALenum ALAPIENTRY EAXSet(const GUID *propertySetID,ALuint property,ALuint source,ALvoid *value,ALuint size)
{
	LPKSPROPERTYSET EaxPropertySet;
	ALsource *Source;

	if (alIsSource(source))
	{
		Source=((ALsource *)source);
		if (IDirectSound3DBuffer_QueryInterface((LPDIRECTSOUND3DBUFFER)Source->uservalue2,&IID_IKsPropertySet,(LPUNKNOWN *)&EaxPropertySet)==DS_OK)
		{
			IKsPropertySet_Set(EaxPropertySet,propertySetID,property,NULL,0,value,size);
			IKsPropertySet_Release(EaxPropertySet);
		}
	}
	else
	{
		EaxPropertySet=alcGetContextsDevice(alcGetCurrentContext())->DSpropertyset;
		if (EaxPropertySet)
		{
			IKsPropertySet_Set(EaxPropertySet,propertySetID,property,NULL,0,value,size);
		}
	}
	return AL_NO_ERROR;
}
