﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/personalize/Personalize_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Personalize {
namespace Model {
class CreateDatasetImportJobResult {
 public:
  AWS_PERSONALIZE_API CreateDatasetImportJobResult() = default;
  AWS_PERSONALIZE_API CreateDatasetImportJobResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PERSONALIZE_API CreateDatasetImportJobResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the dataset import job.</p>
   */
  inline const Aws::String& GetDatasetImportJobArn() const { return m_datasetImportJobArn; }
  template <typename DatasetImportJobArnT = Aws::String>
  void SetDatasetImportJobArn(DatasetImportJobArnT&& value) {
    m_datasetImportJobArnHasBeenSet = true;
    m_datasetImportJobArn = std::forward<DatasetImportJobArnT>(value);
  }
  template <typename DatasetImportJobArnT = Aws::String>
  CreateDatasetImportJobResult& WithDatasetImportJobArn(DatasetImportJobArnT&& value) {
    SetDatasetImportJobArn(std::forward<DatasetImportJobArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateDatasetImportJobResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_datasetImportJobArn;

  Aws::String m_requestId;
  bool m_datasetImportJobArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Personalize
}  // namespace Aws
