/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;

public class StringReferenceInitializer
extends SimplifiedVisitor
implements ConstantVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;

    public StringReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        if (stringConstant.referencedClass == null) {
            stringConstant.referencedClass = this.findClass(ClassUtil.internalClassName(ClassUtil.externalBaseType(stringConstant.getString(clazz))));
        }
    }

    private Clazz findClass(String name) {
        Clazz clazz = this.programClassPool.getClass(name);
        if (clazz == null) {
            clazz = this.libraryClassPool.getClass(name);
        }
        return clazz;
    }
}

