/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.StringWriter;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.UnicodeWriterToWriter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingIncident;

public class MessageWarner
extends XMLEmitter {
    private boolean abort = false;
    private String errorCode = null;
    private StringWriter stringWriter;

    @Override
    public void startDocument(int properties) throws XPathException {
        this.stringWriter = new StringWriter();
        this.writer = new UnicodeWriterToWriter(this.stringWriter);
        this.abort = ReceiverOption.contains(properties, 16384);
        super.startDocument(properties);
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        if (target.equals("error-code")) {
            this.errorCode = data.toString();
        } else {
            super.processingInstruction(target, data, locationId, properties);
        }
    }

    @Override
    public void endDocument() throws XPathException {
        ErrorReporter reporter = this.getPipelineConfiguration().getErrorReporter();
        XmlProcessingIncident de = new XmlProcessingIncident(this.stringWriter.toString(), this.errorCode == null ? "XTMM9000" : this.errorCode);
        if (!this.abort) {
            de = de.asWarning();
        }
        reporter.report(de);
    }

    @Override
    public void close() {
    }
}

