/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.explorer.AccessedNodes;
import org.freeplane.features.explorer.NodeAlias;
import org.freeplane.features.map.NodeModel;

class NodeMatcher {
    private final String matchedString;
    private final MatchedElement matchedElement;
    private static final String REST_CHARACTERS = "...";

    public NodeMatcher(String searchedString) {
        this.matchedElement = MatchedElement.of(searchedString);
        this.matchedString = this.matchedElement.matchedStringOf(searchedString);
    }

    public boolean matches(NodeModel node) {
        if (this.matchedElement == MatchedElement.COUNTER) {
            throw new IllegalArgumentException("Can not match nodes by index");
        }
        if (this.matchedElement == MatchedElement.ALIAS) {
            return this.matches(node.getExtension(NodeAlias.class));
        }
        return this.matches(HtmlUtils.htmlToPlain(node.getText()));
    }

    private boolean matches(NodeAlias alias) {
        return alias != null && this.matchedString.equals(alias.value);
    }

    private boolean matches(String text) {
        if (this.matchedElement == MatchedElement.START) {
            return text.startsWith(this.matchedString);
        }
        return text.equals(this.matchedString);
    }

    public List<NodeModel> filterMatchingNodes(Iterable<NodeModel> iterable, AccessedNodes accessedNodes) {
        if (this.matchedElement == MatchedElement.COUNTER) {
            return this.getNodeByCounter(iterable, accessedNodes);
        }
        return this.getNodesByContent(iterable, accessedNodes);
    }

    private List<NodeModel> getNodesByContent(Iterable<NodeModel> iterable, AccessedNodes accessedNodes) {
        int counter = 0;
        List<NodeModel> nodes = null;
        for (NodeModel node : iterable) {
            accessedNodes.accessNode(node);
            if (!this.matches(node)) continue;
            if (++counter == 1) {
                nodes = new ArrayList<NodeModel>();
            }
            nodes.add(node);
        }
        return nodes != null ? nodes : Collections.emptyList();
    }

    private List<NodeModel> getNodeByCounter(Iterable<NodeModel> iterable, AccessedNodes accessedNodes) {
        int counter = 1;
        int requiredCounter = Integer.valueOf(this.matchedString);
        for (NodeModel node : iterable) {
            if (counter == requiredCounter) {
                return Collections.singletonList(node);
            }
            ++counter;
        }
        return Collections.emptyList();
    }

    private static enum MatchedElement {
        ALIAS{

            @Override
            String matchedStringOf(String searchedString) {
                return searchedString.substring(1);
            }
        }
        ,
        COUNTER{

            @Override
            String matchedStringOf(String searchedString) {
                return searchedString.substring(1);
            }
        }
        ,
        TEXT{

            @Override
            String matchedStringOf(String searchedString) {
                return searchedString.substring(1, searchedString.length() - 1);
            }
        }
        ,
        START{

            @Override
            String matchedStringOf(String searchedString) {
                return searchedString.substring(1, searchedString.length() - NodeMatcher.REST_CHARACTERS.length() - 1);
            }
        }
        ,
        NO_CONTENT{

            @Override
            String matchedStringOf(String searchedString) {
                return "";
            }
        };


        static MatchedElement of(String searchedString) {
            if (searchedString.isEmpty()) {
                return NO_CONTENT;
            }
            if (searchedString.startsWith("~")) {
                if (StringUtils.isNumeric((String)searchedString.substring(1))) {
                    return COUNTER;
                }
                return ALIAS;
            }
            if (searchedString.length() >= 2) {
                if (searchedString.startsWith("\"")) {
                    if (searchedString.endsWith("...\"")) {
                        return START;
                    }
                    if (searchedString.endsWith("\"")) {
                        return TEXT;
                    }
                } else if (searchedString.startsWith("'")) {
                    if (searchedString.endsWith("...'")) {
                        return START;
                    }
                    if (searchedString.endsWith("'")) {
                        return TEXT;
                    }
                }
            }
            throw new IllegalArgumentException("invalid search string " + searchedString);
        }

        abstract String matchedStringOf(String var1);
    }
}

