/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.PngjExceptionInternal;

public class ImageLines {
    public final ImageInfo imgInfo;
    public final int channels;
    public final int bitDepth;
    public final ImageLine.SampleType sampleType;
    public final boolean samplesUnpacked;
    public final int elementsPerRow;
    public final int rowOffset;
    public final int nRows;
    public final int rowStep;
    public final int[][] scanlines;
    public final byte[][] scanlinesb;

    public ImageLines(ImageInfo imageInfo, ImageLine.SampleType sampleType, boolean bl, int n, int n2, int n3) {
        this.imgInfo = imageInfo;
        this.channels = imageInfo.channels;
        this.bitDepth = imageInfo.bitDepth;
        this.sampleType = sampleType;
        this.samplesUnpacked = bl || !imageInfo.packed;
        this.elementsPerRow = bl ? imageInfo.samplesPerRow : imageInfo.samplesPerRowPacked;
        this.rowOffset = n;
        this.nRows = n2;
        this.rowStep = n3;
        if (sampleType == ImageLine.SampleType.INT) {
            this.scanlines = new int[n2][this.elementsPerRow];
            this.scanlinesb = null;
        } else if (sampleType == ImageLine.SampleType.BYTE) {
            this.scanlinesb = new byte[n2][this.elementsPerRow];
            this.scanlines = null;
        } else {
            throw new PngjExceptionInternal("bad ImageLine initialization");
        }
    }

    public int imageRowToMatrixRow(int n) {
        int n2 = (n - this.rowOffset) / this.rowStep;
        return n2 < 0 ? 0 : (n2 < this.nRows ? n2 : this.nRows - 1);
    }

    public int imageRowToMatrixRowStrict(int n) {
        int n2 = (n -= this.rowOffset) >= 0 && n % this.rowStep == 0 ? n / this.rowStep : -1;
        return n2 < this.nRows ? n2 : -1;
    }

    public int matrixRowToImageRow(int n) {
        return n * this.rowStep + this.rowOffset;
    }

    public ImageLine getImageLineAtMatrixRow(int n) {
        if (n < 0 || n > this.nRows) {
            throw new PngjException("Bad row " + n + ". Should be positive and less than " + this.nRows);
        }
        ImageLine imageLine = this.sampleType == ImageLine.SampleType.INT ? new ImageLine(this.imgInfo, this.sampleType, this.samplesUnpacked, this.scanlines[n], null) : new ImageLine(this.imgInfo, this.sampleType, this.samplesUnpacked, null, this.scanlinesb[n]);
        imageLine.setRown(this.matrixRowToImageRow(n));
        return imageLine;
    }
}

