/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.PeekInputStream;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.TerminalInputListener;

public abstract class AbstractWindowsTerminalInput
implements TerminalInput {
    private final PeekInputStream inputStream = new PeekInputStream(new FileInputStream(FileDescriptor.in));
    final Object lock = new Object();

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    void readNonRaw(TerminalInputListener listener) {
        if (this.peek(0) == 10 || this.peek(0) == 13 && this.peek(1) == 10) {
            this.inputStream.consumeAll();
            listener.controlKey(TerminalInputListener.Key.Enter);
            return;
        }
        int ch = this.next();
        if (ch < 0) {
            listener.endInput();
        } else {
            listener.character((char)ch);
        }
    }

    int peek(int i) {
        try {
            return this.inputStream.peek(i);
        }
        catch (IOException e) {
            throw new NativeException("Could not read from console.", e);
        }
    }

    int next() {
        try {
            return this.inputStream.read();
        }
        catch (IOException e) {
            throw new NativeException("Could not read from console.", e);
        }
    }
}

