/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import org.gradle.api.Task;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public interface TaskDetails {
    public Path getPath();

    public @Nullable String getDescription();

    public String getTypeName();

    public static TaskDetails of(Path path, Task task) {
        return TaskDetails.of(path, new DslObject((Object)task).getPublicType().getFullyQualifiedName(), task.getDescription());
    }

    public static TaskDetails of(Path path, String typeName, @Nullable String description) {
        return new DefaultTaskDetails(path, typeName, description);
    }

    public static final class DefaultTaskDetails
    implements TaskDetails {
        private final Path path;
        private final String typeName;
        private final @Nullable String description;

        private DefaultTaskDetails(Path path, String typeName, @Nullable String description) {
            this.path = path;
            this.typeName = typeName;
            this.description = description;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public @Nullable String getDescription() {
            return this.description;
        }
    }
}

