/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteStorageThreadPool
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteStorageThreadPool.class);
    private final KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup(this.getClass());

    public RemoteStorageThreadPool(String threadNamePattern, int numThreads, int maxPendingTasks) {
        super(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxPendingTasks), ThreadUtils.createThreadFactory((String)threadNamePattern, (boolean)false, (t, e) -> LOGGER.error("Uncaught exception in thread '{}':", (Object)t.getName(), (Object)e)));
        this.metricsGroup.newGauge(RemoteStorageMetrics.REMOTE_LOG_READER_TASK_QUEUE_SIZE_METRIC.getName(), () -> this.getQueue().size());
        this.metricsGroup.newGauge(RemoteStorageMetrics.REMOTE_LOG_READER_AVG_IDLE_PERCENT_METRIC.getName(), () -> 1.0 - (double)this.getActiveCount() / (double)this.getCorePoolSize());
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable th) {
        if (th != null) {
            if (th instanceof FatalExitError) {
                LOGGER.error("Stopping the server as it encountered a fatal error.");
                Exit.exit((int)((FatalExitError)th).statusCode());
            } else if (!this.isShutdown()) {
                LOGGER.error("Error occurred while executing task: {}", (Object)runnable, (Object)th);
            }
        }
    }

    public void removeMetrics() {
        RemoteStorageMetrics.REMOTE_STORAGE_THREAD_POOL_METRICS.forEach(arg_0 -> ((KafkaMetricsGroup)this.metricsGroup).removeMetric(arg_0));
    }
}

